/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text;

import java.util.HashMap;
import org.eclipse.mtj.internal.core.text.DocumentXMLNode;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.IDocumentTextNode;
import org.eclipse.mtj.internal.core.util.MTJTextHelper;

public class DocumentTextNode
extends DocumentXMLNode
implements IDocumentTextNode {
    private static final long serialVersionUID = 1L;
    protected static final HashMap<Character, String> SUBSTITUTE_CHARS = new HashMap(5);
    private transient IDocumentElementNode fEnclosingElement = null;
    private transient int fLength = 0;
    private transient int fOffset = -1;
    private String fText;

    static {
        SUBSTITUTE_CHARS.put(new Character('&'), "&amp;");
        SUBSTITUTE_CHARS.put(new Character('<'), "&lt;");
        SUBSTITUTE_CHARS.put(new Character('>'), "&gt;");
        SUBSTITUTE_CHARS.put(new Character('\''), "&apos;");
        SUBSTITUTE_CHARS.put(new Character('\"'), "&quot;");
    }

    public IDocumentElementNode getEnclosingElement() {
        return this.fEnclosingElement;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public String getText() {
        return this.fText == null ? "" : this.fText;
    }

    public int getXMLType() {
        return 2;
    }

    public void reconnect(IDocumentElementNode parent) {
        this.fEnclosingElement = parent;
        this.fLength = -1;
        this.fOffset = -1;
    }

    public void setEnclosingElement(IDocumentElementNode node) {
        this.fEnclosingElement = node;
    }

    public void setLength(int length) {
        this.fLength = length;
    }

    public void setOffset(int offset) {
        this.fOffset = offset;
    }

    public void setText(String text) {
        this.fText = text;
    }

    public String write() {
        String content = this.getText().trim();
        return MTJTextHelper.translateWriteText(content, SUBSTITUTE_CHARS);
    }
}

