/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.text.l10n;

import org.eclipse.mtj.internal.core.text.DocumentNodeFactory;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.IDocumentNodeFactory;
import org.eclipse.mtj.internal.core.text.l10n.L10nEntry;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;

public class L10nDocumentFactory
extends DocumentNodeFactory
implements IDocumentNodeFactory {
    private L10nModel fModel;

    public L10nDocumentFactory(L10nModel model) {
        this.fModel = model;
    }

    public IDocumentElementNode createDocumentNode(String name, IDocumentElementNode parent) {
        if (this.isLocales(name)) {
            return this.createL10nLocales();
        }
        if (this.isEntry(name)) {
            return this.createL10nEntry(parent);
        }
        if (this.isLocale(name)) {
            return this.createL10nLocale(parent);
        }
        return super.createDocumentNode(name, parent);
    }

    public L10nEntry createL10nEntry(IDocumentElementNode parent) {
        L10nEntry entry = null;
        try {
            entry = this.fModel.getLocales().getLocale(parent).createEntry();
        }
        catch (Exception exception) {}
        return entry;
    }

    public L10nLocale createL10nLocale(IDocumentElementNode parent) {
        return this.fModel.getLocales().createlLocale();
    }

    public L10nLocales createL10nLocales() {
        return new L10nLocales(this.fModel);
    }

    private boolean isEntry(String name) {
        return this.isL10nElement(name, "entry");
    }

    private boolean isL10nElement(String name, String elementName) {
        return name.equals(elementName);
    }

    private boolean isLocale(String name) {
        return this.isL10nElement(name, "locale");
    }

    private boolean isLocales(String name) {
        return this.isL10nElement(name, "locales");
    }
}

