/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.mtj.internal.core.Messages;

public class MTJStatusHandler {
    public static final IStatus OK_STATUS = new Status(0, "org.eclipse.mtj.core", 0, Messages.MTJCore_OK_STATUS_msg, null);
    public static final IStatus PROMPTER_STATUS = new Status(1, "org.eclipse.debug.ui", 200, "", null);

    public static Object statusPrompt(IStatus status, Object source) throws CoreException {
        Object result = null;
        IStatusHandler prompterStatus = DebugPlugin.getDefault().getStatusHandler(PROMPTER_STATUS);
        if (prompterStatus == null) {
            throw new CoreException(status);
        }
        result = prompterStatus.handleStatus(status, source);
        return result;
    }

    public static IStatus newStatus(int severity, int code, String message) {
        return MTJStatusHandler.newStatus(severity, code, message, null);
    }

    public static IStatus newStatus(int severity, int code, String message, Throwable exception) {
        return new Status(severity, "org.eclipse.mtj.core", code, message, exception);
    }

    public static void throwCoreException(int severity, int code, Throwable exception) throws CoreException {
        String message = null;
        if (exception != null) {
            message = exception.getMessage();
        }
        if (message == null) {
            message = Messages.MTJCore_no_message2;
        }
        Status status = new Status(severity, "org.eclipse.mtj.core", code, message, exception);
        throw new CoreException((IStatus)status);
    }

    public static void throwCoreException(int severity, int code, String message) throws CoreException {
        if (message == null) {
            message = Messages.MTJCore_no_message2;
        }
        Status status = new Status(severity, "org.eclipse.mtj.core", code, message, null);
        throw new CoreException((IStatus)status);
    }
}

