/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui;

import org.eclipse.mtj.core.symbol.ISymbol;
import org.eclipse.mtj.internal.core.text.l10n.L10nEntry;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocale;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nObject;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.util.SharedLabelProvider;
import org.eclipse.swt.graphics.Image;

public class MTJLabelProvider
extends SharedLabelProvider {
    public Image getImage(Object obj) {
        if (obj instanceof L10nObject) {
            return this.getObjectImage((L10nObject)obj);
        }
        return super.getImage(obj);
    }

    public String getObjectText(L10nObject obj) {
        return obj.getName();
    }

    public String getColumnText(Object obj, int index) {
        if (obj instanceof ISymbol) {
            return this.getObjectColumnText((ISymbol)obj, index);
        }
        return super.getColumnText(obj, index);
    }

    private String getObjectColumnText(ISymbol obj, int index) {
        String text = "";
        switch (index) {
            case 0: {
                text = obj.getName();
                break;
            }
            case 1: {
                text = obj.getValue();
            }
        }
        return text;
    }

    public String getText(Object obj) {
        if (obj instanceof L10nObject) {
            return this.getObjectText((L10nObject)obj);
        }
        return super.getText(obj);
    }

    public boolean isFullNameModeEnabled() {
        return MTJUIPlugin.isFullNameModeEnabled();
    }

    private Image getObjectImage(L10nObject object) {
        if (object instanceof L10nLocales) {
            return this.get(MTJUIPluginImages.DESC_LOCALES_OBJ);
        }
        if (object instanceof L10nLocale) {
            L10nLocale entry = (L10nLocale)object;
            switch (entry.getStatus().getSeverity()) {
                case 2: {
                    return this.get(MTJUIPluginImages.DESC_LOCALE_OBJ, 2);
                }
                case 4: {
                    return this.get(MTJUIPluginImages.DESC_LOCALE_OBJ, 1);
                }
            }
            return this.get(MTJUIPluginImages.DESC_LOCALE_OBJ);
        }
        if (object instanceof L10nEntry) {
            L10nEntry entry = (L10nEntry)object;
            switch (entry.getStatus().getSeverity()) {
                case 2: {
                    return this.get(MTJUIPluginImages.DESC_LOCALE_ENTRY_OBJ, 2);
                }
                case 4: {
                    return this.get(MTJUIPluginImages.DESC_LOCALE_ENTRY_OBJ, 1);
                }
            }
            return this.get(MTJUIPluginImages.DESC_LOCALE_ENTRY_OBJ);
        }
        return this.get(MTJUIPluginImages.DESC_PAGE_OBJ);
    }
}

