/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mtj.internal.core.IBaseModel;
import org.eclipse.mtj.internal.core.IWritableDelimiter;
import org.eclipse.mtj.internal.core.text.IWritable;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.IMTJUIConstants;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.editor.FormOutlinePage;
import org.eclipse.mtj.internal.ui.editor.IModelUndoManager;
import org.eclipse.mtj.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditorContributor;
import org.eclipse.mtj.internal.ui.editor.MTJFormPage;
import org.eclipse.mtj.internal.ui.editor.MTJMultiPageContentOutline;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;
import org.eclipse.mtj.internal.ui.editor.MissingResourcePage;
import org.eclipse.mtj.internal.ui.editor.ModelDataTransfer;
import org.eclipse.mtj.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.mtj.internal.ui.editor.context.IInputContextListener;
import org.eclipse.mtj.internal.ui.editor.context.InputContext;
import org.eclipse.mtj.internal.ui.editor.context.InputContextManager;
import org.eclipse.mtj.internal.ui.editors.l10n.L10nSourceOutlinePage;
import org.eclipse.search.ui.text.ISearchEditorAccess;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class MTJFormEditor
extends FormEditor
implements IInputContextListener,
IGotoMarker,
ISearchEditorAccess {
    private static final String F_DIALOG_EDITOR_SECTION_KEY = "mtj-form-editor";
    private Clipboard clipboard;
    private MTJMultiPageContentOutline contentOutline;
    private Menu contextMenu;
    private MTJFormEditorChangeListener editorSelectionChangedListener;
    private boolean error;
    private ISortableContentOutlinePage formOutline;
    private String lastActivePageId;
    private boolean lastDirtyState;
    protected InputContextManager inputContextManager;

    public MTJFormEditor() {
        MTJUIPlugin.getDefault().getLabelProvider().connect(this);
        this.inputContextManager = this.createInputContextManager();
    }

    public boolean canCopy(ISelection selection) {
        if (selection == null) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            return !selection.isEmpty();
        }
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            return textSelection.getLength() > 0;
        }
        return false;
    }

    public boolean canCut(ISelection selection) {
        return this.canCopy(selection);
    }

    public boolean canPasteFromClipboard() {
        IFormPage page = this.getActivePageInstance();
        if (page instanceof MTJFormPage) {
            return ((MTJFormPage)page).canPaste(this.getClipboard());
        }
        return false;
    }

    public final void contextAdded(InputContext context) {
        if (this.error) {
            this.removePage(0);
            this.addPages();
        } else {
            this.editorContextAdded(context);
        }
    }

    public void contributeToToolbar(IToolBarManager manager) {
    }

    public void dispose() {
        this.storeDefaultPage();
        if (this.editorSelectionChangedListener != null) {
            this.editorSelectionChangedListener.uninstall(this.getSite().getSelectionProvider());
            this.editorSelectionChangedListener = null;
        }
        this.setSelection((ISelection)new StructuredSelection());
        MTJUIPlugin.getDefault().getLabelProvider().disconnect(this);
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
        this.inputContextManager.dispose();
        this.inputContextManager = null;
    }

    public void doRevert() {
        boolean reverted;
        IFormPage formPage = this.getActivePageInstance();
        if (formPage != null && formPage instanceof MTJFormPage) {
            formPage.getManagedForm().commit(true);
        }
        if (!(reverted = this.doRevertSourcePages())) {
            reverted = this.doRevertFormPage();
        }
        if (reverted) {
            this.editorDirtyStateChanged();
        }
    }

    public void doRevert(IEditorInput input) {
        InputContext context;
        IFormPage page;
        IFormPage currentPage = this.getActivePageInstance();
        if (currentPage != null && currentPage instanceof MTJFormPage) {
            ((MTJFormPage)currentPage).cancelEdit();
        }
        if ((page = this.findPage((context = this.inputContextManager.getContext(input)).getId())) != null && page instanceof MTJSourcePage) {
            MTJSourcePage spage = (MTJSourcePage)page;
            spage.doRevertToSaved();
        }
        this.editorDirtyStateChanged();
    }

    public void doSave(IProgressMonitor monitor) {
        this.commitPages(true);
        this.inputContextManager.save(monitor);
        this.editorDirtyStateChanged();
    }

    public void doSaveAs() {
        try {
            String contextID = this.getContextIDForSaveAs();
            this.getContextManager().saveAs(this.getProgressMonitor(), contextID);
            IEditorInput input = this.getContextManager().findContext(contextID).getInput();
            this.setInputWithNotify(input);
            this.setPartName(input.getName());
            this.firePropertyChange(257);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            String message = MTJUIMessages.MTJFormEditor_doSaveAs_failed;
            if (e.getMessage() != null) {
                message = String.valueOf(message) + ' ' + e.getMessage();
            }
            MTJLogger.log((int)4, (String)message, (Throwable)e);
        }
    }

    public abstract void editorContextAdded(InputContext var1);

    public void editorDirtyStateChanged() {
        super.editorDirtyStateChanged();
        MTJFormEditorContributor contributor = this.getContributor();
        if (contributor != null) {
            contributor.updateActions();
        }
    }

    public void fireSaveNeeded(IEditorInput input, boolean notify) {
        if (notify) {
            this.editorDirtyStateChanged();
        }
        if (this.isDirty()) {
            this.validateEdit(input);
        }
    }

    public void fireSaveNeeded(String contextId, boolean notify) {
        if (contextId == null) {
            return;
        }
        InputContext context = this.inputContextManager.findContext(contextId);
        if (context != null) {
            this.fireSaveNeeded(context.getInput(), notify);
        }
    }

    public void flushEdits() {
        IFormPage[] pages = this.getPages();
        IManagedForm mForm = pages[this.getActivePage()].getManagedForm();
        if (mForm != null) {
            mForm.commit(false);
        }
        IFormPage[] iFormPageArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage page = iFormPageArray[n2];
            if (page instanceof MTJSourcePage) {
                MTJSourcePage sourcePage = (MTJSourcePage)page;
                sourcePage.getInputContext().flushEditorInput();
            }
            ++n2;
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.getContentOutline();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        if (key.equals(ISearchEditorAccess.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public IBaseModel getAggregateModel() {
        if (this.inputContextManager != null) {
            return this.inputContextManager.getAggregateModel();
        }
        return null;
    }

    public IAnnotationModel getAnnotationModel(Match match) {
        InputContext context = this.getInputContext(match.getElement());
        return context == null ? null : context.getDocumentProvider().getAnnotationModel((Object)context.getInput());
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public IProject getCommonProject() {
        return this.inputContextManager.getCommonProject();
    }

    public MTJMultiPageContentOutline getContentOutline() {
        if (this.contentOutline == null || this.contentOutline.isDisposed()) {
            this.contentOutline = new MTJMultiPageContentOutline(this);
            this.updateContentOutline(this.getActivePageInstance());
        }
        return this.contentOutline;
    }

    public String getContextIDForSaveAs() {
        return null;
    }

    public InputContextManager getContextManager() {
        return this.inputContextManager;
    }

    public Menu getContextMenu() {
        return this.contextMenu;
    }

    public MTJFormEditorContributor getContributor() {
        return (MTJFormEditorContributor)this.getEditorSite().getActionBarContributor();
    }

    public IDocument getDocument(Match match) {
        InputContext context = this.getInputContext(match.getElement());
        return context == null ? null : context.getDocumentProvider().getDocument((Object)context.getInput());
    }

    public boolean getLastDirtyState() {
        return this.lastDirtyState;
    }

    public ISelection getSelection() {
        return this.getSite().getSelectionProvider().getSelection();
    }

    public String getTitle() {
        if (this.inputContextManager == null) {
            return super.getTitle();
        }
        InputContext context = this.inputContextManager.getPrimaryContext();
        if (context == null) {
            return super.getTitle();
        }
        return context.getInput().getName();
    }

    public String getTitleProperty() {
        return "";
    }

    public void gotoMarker(IMarker marker) {
        IResource resource = marker.getResource();
        InputContext context = this.inputContextManager.findContext(resource);
        if (context == null) {
            return;
        }
        IFormPage page = this.getActivePageInstance();
        if (!context.getId().equals(page.getId())) {
            page = this.setActivePage(context.getId());
        }
        IDE.gotoMarker((IEditorPart)page, (IMarker)marker);
    }

    public boolean hasInputContext(String contextId) {
        return this.inputContextManager.hasContext(contextId);
    }

    public boolean isDirty() {
        this.lastDirtyState = this.computeDirtyState();
        return this.lastDirtyState;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void openToSourcePage(Object object, int offset, int length) {
        MTJSourcePage page;
        InputContext context = null;
        context = object instanceof InputContext ? (InputContext)object : this.getInputContext(object);
        if (context != null && (page = (MTJSourcePage)this.setActivePage(context.getId())) != null) {
            page.selectAndReveal(offset, length);
        }
    }

    public IFormPage setActivePage(String pageId) {
        IFormPage page = super.setActivePage(pageId);
        if (page != null) {
            this.updateContentOutline(page);
        }
        return page;
    }

    public void setFocus() {
        super.setFocus();
        IFormPage page = this.getActivePageInstance();
        if (page != null && page instanceof MTJFormPage) {
            ((MTJFormPage)page).updateFormSelection();
        }
    }

    public void setSelection(ISelection selection) {
        this.getSite().getSelectionProvider().setSelection(selection);
        this.getContributor().updateSelectableActions(selection);
    }

    public void synchronizeOutlinePage() {
        IFormPage page = this.getActivePageInstance();
        if (page instanceof MTJSourcePage) {
            ((MTJSourcePage)page).synchronizeOutlinePage();
        } else if (this.getFormOutline() != null) {
            this.getFormOutline().setSelection(this.getSelection());
        }
    }

    public void updateTitle() {
        this.firePropertyChange(1);
    }

    private boolean computeDirtyState() {
        IFormPage page = this.getActivePageInstance();
        if (page != null && page.isDirty() || this.inputContextManager != null && this.inputContextManager.isDirty()) {
            return true;
        }
        return super.isDirty();
    }

    private void copyToClipboard(ISelection selection) {
        Object[] objects = null;
        String textVersion = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            if (ssel == null || ssel.size() == 0) {
                return;
            }
            objects = ssel.toArray();
            StringWriter writer = new StringWriter();
            PrintWriter pwriter = new PrintWriter(writer);
            Class<?> objClass = null;
            int i = 0;
            while (i < objects.length) {
                Object obj = objects[i];
                if (objClass == null) {
                    objClass = obj.getClass();
                } else if (!objClass.equals(obj.getClass())) {
                    return;
                }
                if (obj instanceof IWritable) {
                    if (i != 0 && obj instanceof IWritableDelimiter) {
                        ((IWritableDelimiter)obj).writeDelimeter(pwriter);
                    }
                    ((IWritable)obj).write("", pwriter);
                } else if (obj instanceof String) {
                    pwriter.println((String)obj);
                }
                ++i;
            }
            pwriter.flush();
            textVersion = writer.toString();
            try {
                pwriter.close();
                writer.close();
            }
            catch (IOException iOException) {}
        } else if (selection instanceof ITextSelection) {
            textVersion = ((ITextSelection)selection).getText();
        }
        if ((textVersion == null || textVersion.length() == 0) && objects == null) {
            return;
        }
        Object[] o = null;
        Transfer[] t = null;
        if (objects == null) {
            o = new Object[]{textVersion};
            t = new Transfer[]{TextTransfer.getInstance()};
        } else if (textVersion == null || textVersion.length() == 0) {
            o = new Object[]{objects};
            t = new Transfer[]{ModelDataTransfer.getInstance()};
        } else {
            o = new Object[]{objects, textVersion};
            t = new Transfer[]{ModelDataTransfer.getInstance(), TextTransfer.getInstance()};
        }
        this.clipboard.setContents(o, t);
    }

    private boolean doRevertFormPage() {
        return false;
    }

    private boolean doRevertSourcePages() {
        IFormPage[] pages;
        boolean reverted = false;
        IFormPage[] iFormPageArray = pages = this.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage page = iFormPageArray[n2];
            if (page instanceof MTJSourcePage) {
                MTJSourcePage sourcePage = (MTJSourcePage)page;
                sourcePage.getInputContext().flushEditorInput();
                sourcePage.doRevertToSaved();
                reverted = true;
            }
            ++n2;
        }
        return reverted;
    }

    private String getFirstInvalidContextId() {
        InputContext[] invalidContexts = this.inputContextManager.getInvalidContexts();
        if (invalidContexts.length == 0) {
            return null;
        }
        InputContext[] inputContextArray = invalidContexts;
        int n = invalidContexts.length;
        int n2 = 0;
        while (n2 < n) {
            InputContext invalidContext = inputContextArray[n2];
            if (invalidContext.isPrimary()) {
                return invalidContext.getId();
            }
            ++n2;
        }
        return invalidContexts[0].getId();
    }

    private IDialogSettings getSettingsSection() {
        IDialogSettings root = MTJUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = root.getSection(F_DIALOG_EDITOR_SECTION_KEY);
        if (section == null) {
            section = root.addNewSection(F_DIALOG_EDITOR_SECTION_KEY);
        }
        return section;
    }

    private String loadDefaultPage() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            return this.getPropertyEditorPageKey((IFileEditorInput)input);
        }
        if (input instanceof IStorageEditorInput) {
            return this.getDialogEditorPageKey();
        }
        return null;
    }

    private void storeDefaultPage() {
        IEditorInput input = this.getEditorInput();
        String pageId = this.lastActivePageId;
        if (pageId == null) {
            return;
        }
        if (input instanceof IFileEditorInput) {
            this.setPropertyEditorPageKey((IFileEditorInput)input, pageId);
        } else if (input instanceof IStorageEditorInput) {
            this.setDialogEditorPageKey(pageId);
        }
    }

    private void updateContentOutline(IFormPage page) {
        if (this.contentOutline == null) {
            return;
        }
        ISortableContentOutlinePage outline = null;
        if (page instanceof MTJSourcePage) {
            outline = ((MTJSourcePage)page).getContentOutline();
            if (outline != null && outline instanceof L10nSourceOutlinePage) {
                ((L10nSourceOutlinePage)outline).refresh();
            }
        } else {
            outline = this.getFormOutline();
            if (outline != null && outline instanceof FormOutlinePage) {
                ((FormOutlinePage)outline).refresh();
            }
        }
        this.contentOutline.setPageActive(outline);
    }

    private void validateEdit(IEditorInput input) {
        final InputContext context = this.inputContextManager.getContext(input);
        if (!context.validateEdit()) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MTJFormEditor.this.doRevert(context.getInput());
                    context.setValidated(false);
                }
            });
        }
    }

    protected abstract void addEditorPages();

    protected final void addPages() {
        boolean bl = this.error = this.getAggregateModel() == null;
        if (this.error) {
            try {
                this.addPage((IFormPage)new MissingResourcePage(this));
            }
            catch (PartInitException e) {
                MTJLogger.log((int)4, (Throwable)e);
            }
        } else {
            this.addEditorPages();
        }
    }

    protected String computeInitialPageId() {
        String invalidContextId;
        String firstPageId = null;
        String storedFirstPageId = this.loadDefaultPage();
        if (storedFirstPageId != null) {
            firstPageId = storedFirstPageId;
        }
        if ((invalidContextId = this.getFirstInvalidContextId()) != null) {
            return invalidContextId;
        }
        return firstPageId;
    }

    protected void contextMenuAboutToShow(IMenuManager manager) {
        MTJFormEditorContributor contributor = this.getContributor();
        IFormPage page = this.getActivePageInstance();
        if (page instanceof MTJFormPage) {
            ((MTJFormPage)page).contextMenuAboutToShow(manager);
        }
        if (contributor != null) {
            contributor.contextMenuAboutToShow(manager);
        }
    }

    protected abstract ISortableContentOutlinePage createContentOutline();

    protected abstract InputContextManager createInputContextManager();

    protected void createInputContexts(InputContextManager contextManager) {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            this.createResourceContexts(contextManager, (IFileEditorInput)input);
        } else if (input instanceof SystemFileEditorInput) {
            this.createSystemFileContexts(contextManager, (SystemFileEditorInput)input);
        } else if (input instanceof IStorageEditorInput) {
            this.createStorageContexts(contextManager, (IStorageEditorInput)input);
        } else if (input instanceof IURIEditorInput) {
            IURIEditorInput uriEditorInput = (IURIEditorInput)input;
            try {
                IFileStore store = EFS.getStore((URI)uriEditorInput.getURI());
                if (!"file".equals(store.getFileSystem().getScheme())) {
                    return;
                }
            }
            catch (CoreException coreException) {
                return;
            }
            File file = new File(uriEditorInput.getURI());
            SystemFileEditorInput sinput = new SystemFileEditorInput(file);
            this.createSystemFileContexts(contextManager, sinput);
        }
    }

    protected void createPages() {
        this.clipboard = new Clipboard(this.getContainer().getDisplay());
        MenuManager manager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MTJFormEditor.this.contextMenuAboutToShow(manager);
            }
        };
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(listener);
        this.contextMenu = manager.createContextMenu((Control)this.getContainer());
        this.getContainer().setMenu(this.contextMenu);
        this.createInputContexts(this.inputContextManager);
        super.createPages();
        this.inputContextManager.addInputContextListener(this);
        String pageToShow = this.computeInitialPageId();
        if (pageToShow != null) {
            this.setActivePage(pageToShow);
        }
        this.updateTitle();
    }

    protected abstract void createResourceContexts(InputContextManager var1, IFileEditorInput var2);

    protected IEditorSite createSite(IEditorPart editor) {
        return new MTJMultiPageEditorSite((MultiPageEditorPart)this, editor);
    }

    protected abstract void createStorageContexts(InputContextManager var1, IStorageEditorInput var2);

    protected abstract void createSystemFileContexts(InputContextManager var1, SystemFileEditorInput var2);

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(MTJUIPlugin.getDefault().getFormColors(display));
    }

    protected String getDialogEditorPageKey() {
        IDialogSettings section = this.getSettingsSection();
        return section.get(this.getEditorID());
    }

    protected abstract String getEditorID();

    protected ISortableContentOutlinePage getFormOutline() {
        if (this.formOutline == null) {
            this.formOutline = this.createContentOutline();
            if (this.formOutline != null) {
                this.editorSelectionChangedListener = new MTJFormEditorChangeListener();
                this.editorSelectionChangedListener.install(this.getSite().getSelectionProvider());
            }
        }
        return this.formOutline;
    }

    protected abstract InputContext getInputContext(Object var1);

    protected IProgressMonitor getProgressMonitor() {
        IProgressMonitor monitor = null;
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager != null) {
            monitor = manager.getProgressMonitor();
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return monitor;
    }

    protected String getPropertyEditorPageKey(IFileEditorInput input) {
        IFile file = input.getFile();
        try {
            return file.getPersistentProperty(IMTJUIConstants.PROPERTY_EDITOR_PAGE_KEY);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected IStatusLineManager getStatusLineManager() {
        return this.getEditorSite().getActionBars().getStatusLineManager();
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        IFormPage page = this.getActivePageInstance();
        this.updateContentOutline(page);
        if (page != null && page instanceof MTJSourcePage) {
            ((MTJSourcePage)page).refreshMarkStatus();
        }
        if (page != null) {
            this.lastActivePageId = page.getId();
        }
    }

    protected void performGlobalAction(String id) {
        IFormPage page;
        ISelection selection = this.getSelection();
        boolean handled = ((MTJFormPage)this.getActivePageInstance()).performGlobalAction(id);
        if (!handled && (page = this.getActivePageInstance()) instanceof MTJFormPage) {
            if (id.equals(ActionFactory.UNDO.getId())) {
                this.inputContextManager.undo();
                return;
            }
            if (id.equals(ActionFactory.REDO.getId())) {
                this.inputContextManager.redo();
                return;
            }
            if (id.equals(ActionFactory.CUT.getId()) || id.equals(ActionFactory.COPY.getId())) {
                this.copyToClipboard(selection);
                return;
            }
        }
    }

    protected void setDialogEditorPageKey(String pageID) {
        IDialogSettings section = this.getSettingsSection();
        section.put(this.getEditorID(), pageID);
    }

    protected void setPropertyEditorPageKey(IFileEditorInput input, String pageId) {
        IFile file = input.getFile();
        try {
            file.setPersistentProperty(IMTJUIConstants.PROPERTY_EDITOR_PAGE_KEY, pageId);
        }
        catch (CoreException coreException) {}
    }

    IFormPage[] getPages() {
        ArrayList<IFormPage> formPages = new ArrayList<IFormPage>();
        int i = 0;
        while (i < this.pages.size()) {
            Object page = this.pages.get(i);
            if (page instanceof IFormPage) {
                formPages.add((IFormPage)page);
            }
            ++i;
        }
        return formPages.toArray(new IFormPage[formPages.size()]);
    }

    void updateUndo(IAction undoAction, IAction redoAction) {
        IModelUndoManager undoManager = this.inputContextManager.getUndoManager();
        if (undoManager != null) {
            undoManager.setActions(undoAction, redoAction);
        }
    }

    public class MTJFormEditorChangeListener
    implements ISelectionChangedListener {
        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (MTJUIPlugin.getDefault().getPreferenceStore().getBoolean("ToggleLinkWithEditorAction.isChecked") && MTJFormEditor.this.getFormOutline() != null) {
                MTJFormEditor.this.getFormOutline().setSelection(event.getSelection());
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }

    private static class MTJMultiPageEditorSite
    extends MultiPageEditorSite {
        public MTJMultiPageEditorSite(MultiPageEditorPart multiPageEditor, IEditorPart editor) {
            super(multiPageEditor, editor);
        }

        public IEditorActionBarContributor getActionBarContributor() {
            MTJFormEditor editor = (MTJFormEditor)this.getMultiPageEditor();
            MTJFormEditorContributor contributor = editor.getContributor();
            return contributor.getSourceContributor();
        }

        public IWorkbenchPart getPart() {
            return this.getMultiPageEditor();
        }
    }
}

