/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor;

import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditorContributor;
import org.eclipse.mtj.internal.ui.editor.MTJProjectionSourcePage;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;
import org.eclipse.mtj.internal.ui.editor.actions.FormatAction;
import org.eclipse.mtj.internal.ui.editor.actions.HyperlinkAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;

public class MTJFormTextEditorContributor
extends MTJFormEditorContributor {
    private RetargetTextEditorAction fCorrectionAssist;
    private HyperlinkAction fHyperlinkAction;
    private FormatAction formatAction;
    private RetargetTextEditorAction fContentAssist;
    private TextEditorActionContributor fSourceContributor = this.createSourceContributor();
    private SubActionBars fSourceActionBars;

    public void setFormatAction(FormatAction formatAction) {
        this.formatAction = formatAction;
    }

    public MTJFormTextEditorContributor(String menuName) {
        super(menuName);
        if (this.supportsCorrectionAssist()) {
            this.fCorrectionAssist = new RetargetTextEditorAction(MTJSourcePage.getBundleForConstructedKeys(), "CorrectionAssistProposal.");
            this.fCorrectionAssist.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        }
        if (this.supportsHyperlinking()) {
            this.fHyperlinkAction = new HyperlinkAction();
            this.fHyperlinkAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.editor");
        }
        if (this.supportsFormatAction()) {
            // empty if block
        }
        if (this.supportsContentAssist()) {
            this.fContentAssist = new RetargetTextEditorAction(MTJSourcePage.getBundleForConstructedKeys(), "ContentAssistProposal.");
            this.fContentAssist.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        }
    }

    public boolean supportsCorrectionAssist() {
        return false;
    }

    public boolean supportsContentAssist() {
        return false;
    }

    public boolean supportsFormatAction() {
        return false;
    }

    public boolean supportsHyperlinking() {
        return false;
    }

    public IEditorActionBarContributor getSourceContributor() {
        return this.fSourceContributor;
    }

    public void init(IActionBars bars) {
        super.init(bars);
        this.fSourceActionBars = new SubActionBars(bars);
        this.fSourceContributor.init((IActionBars)this.fSourceActionBars);
    }

    public void dispose() {
        this.fSourceActionBars.dispose();
        this.fSourceContributor.dispose();
        super.dispose();
    }

    protected void setSourceActionBarsActive(boolean active) {
        IActionBars rootBars = this.getActionBars();
        rootBars.clearGlobalActionHandlers();
        rootBars.updateActionBars();
        if (active) {
            this.fSourceActionBars.activate();
            Map handlers = this.fSourceActionBars.getGlobalActionHandlers();
            if (handlers != null) {
                Set keys = handlers.keySet();
                for (String id : keys) {
                    rootBars.setGlobalActionHandler(id, (IAction)handlers.get(id));
                }
            }
        } else {
            this.fSourceActionBars.deactivate();
            this.registerGlobalActionHandlers();
        }
        rootBars.setGlobalActionHandler("org.eclipse.mtj.ui.actions.Open", (IAction)(active ? this.fHyperlinkAction : null));
        rootBars.setGlobalActionHandler("org.eclipse.mtj.ui.actions.Format", (IAction)(active ? this.formatAction : null));
        rootBars.setGlobalActionHandler(ActionFactory.REVERT.getId(), this.getRevertAction());
        rootBars.updateActionBars();
    }

    private void registerGlobalActionHandlers() {
        this.registerGlobalAction(ActionFactory.DELETE.getId());
        this.registerGlobalAction(ActionFactory.UNDO.getId());
        this.registerGlobalAction(ActionFactory.REDO.getId());
        this.registerGlobalAction(ActionFactory.CUT.getId());
        this.registerGlobalAction(ActionFactory.COPY.getId());
        this.registerGlobalAction(ActionFactory.PASTE.getId());
        this.registerGlobalAction(ActionFactory.SELECT_ALL.getId());
        this.registerGlobalAction(ActionFactory.FIND.getId());
    }

    private void registerGlobalAction(String id) {
        IAction action = this.getGlobalAction(id);
        this.getActionBars().setGlobalActionHandler(id, action);
    }

    public void setActivePage(IEditorPart newEditor) {
        if (this.mtjFormEditor == null) {
            return;
        }
        IFormPage oldPage = this.formPage;
        this.formPage = this.mtjFormEditor.getActivePageInstance();
        if (this.formPage == null) {
            return;
        }
        this.updateQuickOutlineMenuEntry();
        this.updateActions();
        if (oldPage != null && !oldPage.isEditor() && !this.formPage.isEditor()) {
            this.getActionBars().updateActionBars();
            return;
        }
        boolean isSourcePage = this.formPage instanceof MTJSourcePage;
        if (isSourcePage && this.formPage.equals(oldPage)) {
            return;
        }
        this.fSourceContributor.setActiveEditor((IEditorPart)this.formPage);
        this.setSourceActionBarsActive(isSourcePage);
    }

    private void updateQuickOutlineMenuEntry() {
        IActionBars actionBars = this.getActionBars();
        IMenuManager menuManager = actionBars.getMenuManager();
        IMenuManager navigateMenu = menuManager.findMenuUsingPath("navigate");
        if (navigateMenu == null) {
            return;
        }
        navigateMenu.remove("org.eclipse.mtj.ui.quickOutline");
        if (!(this.formPage instanceof MTJProjectionSourcePage)) {
            return;
        }
        MTJProjectionSourcePage page = (MTJProjectionSourcePage)this.formPage;
        if (!page.isQuickOutlineEnabled()) {
            return;
        }
        IAction quickOutlineAction = page.getAction("org.eclipse.mtj.ui.quickOutline");
        if (quickOutlineAction == null) {
            return;
        }
        try {
            navigateMenu.insertAfter("showIn", quickOutlineAction);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    protected TextEditorActionContributor createSourceContributor() {
        return new MTJTextEditorActionContributor();
    }

    protected HyperlinkAction getHyperlinkAction() {
        return this.fHyperlinkAction;
    }

    protected FormatAction getFormatAction() {
        return this.formatAction;
    }

    class MTJTextEditorActionContributor
    extends TextEditorActionContributor {
        MTJTextEditorActionContributor() {
        }

        public void contributeToMenu(IMenuManager mm) {
            super.contributeToMenu(mm);
            IMenuManager editMenu = mm.findMenuUsingPath("edit");
            if (editMenu != null) {
                editMenu.add((IContributionItem)new Separator("group.open"));
                editMenu.add((IContributionItem)new Separator("group.generate"));
                editMenu.add((IContributionItem)new Separator("additions"));
                if (MTJFormTextEditorContributor.this.fCorrectionAssist != null) {
                    editMenu.appendToGroup("group.generate", (IAction)MTJFormTextEditorContributor.this.fCorrectionAssist);
                }
                if (MTJFormTextEditorContributor.this.fContentAssist != null) {
                    editMenu.appendToGroup("group.generate", (IAction)MTJFormTextEditorContributor.this.fContentAssist);
                }
            }
        }

        public void contributeToToolBar(IToolBarManager toolBarManager) {
            super.contributeToToolBar(toolBarManager);
            if (MTJFormTextEditorContributor.this.fHyperlinkAction != null) {
                toolBarManager.add((IAction)MTJFormTextEditorContributor.this.fHyperlinkAction);
            }
        }

        public void setActiveEditor(IEditorPart part) {
            ITextEditor textEditor;
            super.setActiveEditor(part);
            IActionBars actionBars = this.getActionBars();
            IStatusLineManager manager = actionBars.getStatusLineManager();
            manager.setMessage(null);
            manager.setErrorMessage(null);
            ITextEditor iTextEditor = textEditor = part instanceof ITextEditor ? (ITextEditor)part : null;
            if (MTJFormTextEditorContributor.this.fCorrectionAssist != null) {
                MTJFormTextEditorContributor.this.fCorrectionAssist.setAction(this.getAction(textEditor, "QuickAssist"));
            }
            if (MTJFormTextEditorContributor.this.fHyperlinkAction != null) {
                MTJFormTextEditorContributor.this.fHyperlinkAction.setTextEditor(textEditor);
            }
            if (MTJFormTextEditorContributor.this.formatAction != null) {
                MTJFormTextEditorContributor.this.formatAction.setTextEditor(textEditor);
            }
            if (MTJFormTextEditorContributor.this.fContentAssist != null) {
                MTJFormTextEditorContributor.this.fContentAssist.setAction(this.getAction(textEditor, "ContentAssist"));
            }
        }
    }
}

