/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editor.text;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.editor.text.IColorManager;
import org.eclipse.mtj.internal.ui.editor.text.IMTJColorConstants;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager
implements IColorManager,
IMTJColorConstants {
    private static int counter = 0;
    private static ColorManager fColorManager;
    private Map<String, Color> fColorTable = new HashMap<String, Color>(5);

    public static IColorManager getDefault() {
        if (fColorManager == null) {
            fColorManager = new ColorManager();
        }
        ++counter;
        return fColorManager;
    }

    public static void initializeDefaults(final IPreferenceStore store) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                boolean highContrast = false;
                try {
                    highContrast = Display.getDefault().getHighContrast();
                }
                catch (SWTException sWTException) {}
                PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.default", (RGB)(highContrast ? DEFAULT_HIGH_CONTRAST : DEFAULT));
                PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.instr", (RGB)PROC_INSTR);
                PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.string", (RGB)STRING);
                PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.tag", (RGB)TAG);
                PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.xml_comment", (RGB)XML_COMMENT);
            }
        });
    }

    public ColorManager() {
        this.initialize();
    }

    public void dispose() {
        if (--counter == 0) {
            this.disposeColors(true);
        }
    }

    public void disposeColors(boolean resetSingleton) {
        Iterator<Color> e = this.fColorTable.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
        if (resetSingleton) {
            fColorManager = null;
        }
    }

    public Color getColor(String key) {
        Color color = this.fColorTable.get(key);
        if (color == null) {
            color = Display.getCurrent().getSystemColor(24);
        }
        return color;
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        Object color = event.getNewValue();
        if (color instanceof RGB) {
            this.putColor(event.getProperty(), (RGB)color);
        } else {
            this.putColor(event.getProperty(), StringConverter.asRGB((String)color.toString()));
        }
    }

    private void initialize() {
        IPreferenceStore pstore = MTJUIPlugin.getDefault().getPreferenceStore();
        this.putColor(pstore, "editor.color.default");
        this.putColor(pstore, "editor.color.instr");
        this.putColor(pstore, "editor.color.string");
        this.putColor(pstore, "editor.color.tag");
        this.putColor(pstore, "editor.color.xml_comment");
        pstore = PreferenceConstants.getPreferenceStore();
        String[] stringArray = IColorManager.PROPERTIES_COLORS;
        int n = IColorManager.PROPERTIES_COLORS.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            this.putColor(pstore, element);
            ++n2;
        }
    }

    private void putColor(IPreferenceStore pstore, String property) {
        this.putColor(property, PreferenceConverter.getColor((IPreferenceStore)pstore, (String)property));
    }

    private void putColor(String property, RGB setting) {
        Color oldColor = this.fColorTable.get(property);
        if (oldColor != null) {
            if (oldColor.getRGB().equals((Object)setting)) {
                return;
            }
            oldColor.dispose();
        }
        this.fColorTable.put(property, new Color((Device)Display.getCurrent(), setting));
    }
}

