/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.form.pages;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.editors.jad.form.pages.MidletType;
import org.eclipse.mtj.internal.ui.forms.parts.FormEntry;
import org.eclipse.mtj.internal.ui.forms.parts.IFormEntryListener;
import org.eclipse.mtj.internal.ui.util.ImageSelectionDialogCreator;
import org.eclipse.mtj.internal.ui.util.MidletSelectionDialogCreator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class MidletTypeDetailsPage
implements IDetailsPage {
    private FormEntry classEntry;
    private FormEntry iconEntry;
    private MidletType input;
    private IJavaProject javaProject;
    private IManagedForm mform;
    private FormEntry nameEntry;

    public MidletTypeDetailsPage(IJavaProject javaProject) {
        this.javaProject = javaProject;
    }

    public void commit(boolean onSave) {
    }

    public void createContents(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 5;
        layout.leftMargin = 5;
        layout.rightMargin = 2;
        layout.bottomMargin = 2;
        parent.setLayout((Layout)layout);
        FormToolkit toolkit = this.mform.getToolkit();
        Section s1 = toolkit.createSection(parent, 384);
        s1.marginWidth = 10;
        s1.setText(MTJUIMessages.MidletTypeDetailsPage_midlet_details_section_title);
        s1.setDescription(MTJUIMessages.MidletTypeDetailsPage_midlet_details_section_description);
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        s1.setLayoutData((Object)td);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = toolkit.getBorderStyle() == 2048 ? 0 : 2;
        glayout.marginWidth = glayout.marginHeight;
        glayout.numColumns = 3;
        Composite client = toolkit.createComposite((Composite)s1);
        this.createSpacer(client, toolkit, 3);
        client.setLayout((Layout)glayout);
        this.createNameEntry(client, toolkit, new MIDletsFormEntryAdapter());
        this.createIconEntry(client, toolkit, new MIDletsFormEntryAdapter());
        this.createClassEntry(client, toolkit, new MIDletsFormEntryAdapter());
        toolkit.paintBordersFor(client);
        s1.setClient((Control)client);
    }

    public void dispose() {
    }

    public void initialize(IManagedForm mform) {
        this.mform = mform;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
        this.update();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.input = ssel.size() == 1 ? (MidletType)ssel.getFirstElement() : null;
        this.update();
    }

    public void setFocus() {
        this.nameEntry.getText().setFocus();
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    private void createClassEntry(Composite parent, FormToolkit toolkit, IFormEntryListener listener) {
        this.classEntry = new FormEntry(parent, toolkit, MTJUIMessages.MidletTypeDetailsPage_midlet_class_label_text, MTJUIMessages.MidletTypeDetailsPage_brose_btn_label_text, false);
        this.classEntry.setFormEntryListener(listener);
        this.classEntry.setEditable(true);
    }

    private void createIconEntry(Composite parent, FormToolkit toolkit, IFormEntryListener listener) {
        this.iconEntry = new FormEntry(parent, toolkit, MTJUIMessages.MidletTypeDetailsPage_midlet_icon_label_text, MTJUIMessages.MidletTypeDetailsPage_brose_btn_label_text, false);
        this.iconEntry.setFormEntryListener(listener);
        this.iconEntry.setEditable(true);
    }

    private void createNameEntry(Composite parent, FormToolkit toolkit, IFormEntryListener listener) {
        this.nameEntry = new FormEntry(parent, toolkit, MTJUIMessages.MidletTypeDetailsPage_midlet_name_label_text, 4);
        this.nameEntry.setFormEntryListener(listener);
        this.nameEntry.setEditable(true);
    }

    private void createSpacer(Composite parent, FormToolkit toolkit, int span) {
        Label spacer = toolkit.createLabel(parent, "");
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        spacer.setLayoutData((Object)gd);
    }

    private void update() {
        if (this.nameEntry != null) {
            this.nameEntry.setValue(this.input != null && this.input.getMidletName() != null ? this.input.getMidletName() : "", true);
        }
        if (this.iconEntry != null) {
            this.iconEntry.setValue(this.input != null && this.input.getIcon() != null ? this.input.getIcon() : "", true);
        }
        if (this.classEntry != null) {
            this.classEntry.setValue(this.input != null && this.input.getClassName() != null ? this.input.getClassName() : "", true);
        }
    }

    class MIDletsFormEntryAdapter
    implements IFormEntryListener {
        MIDletsFormEntryAdapter() {
        }

        public void browseButtonSelected(FormEntry entry) {
            if (entry == MidletTypeDetailsPage.this.classEntry) {
                try {
                    IType type;
                    Object[] results;
                    SelectionDialog dialog = MidletSelectionDialogCreator.createMidletSelectionDialog(entry.getButton().getShell(), null, MidletTypeDetailsPage.this.javaProject, false);
                    if (dialog.open() == 0 && (results = dialog.getResult()) != null && results.length > 0 && (type = (IType)results[0]) != null) {
                        String className = type.getFullyQualifiedName();
                        MidletTypeDetailsPage.this.classEntry.setValue(className);
                        MidletTypeDetailsPage.this.input.setClassName(className);
                    }
                }
                catch (JavaModelException e) {
                    MTJLogger.log((int)4, (String)MTJUIMessages.MidletTypeDetailsPage_erro_browseButtonSelected_midlet, (Throwable)e);
                }
            } else if (entry == MidletTypeDetailsPage.this.iconEntry) {
                try {
                    IResource type;
                    Object[] results;
                    SelectionDialog dialog = ImageSelectionDialogCreator.createImageSelectionDialog(entry.getButton().getShell(), MidletTypeDetailsPage.this.javaProject);
                    if (dialog.open() == 0 && (results = dialog.getResult()) != null && results.length > 0 && (type = (IResource)results[0]) != null) {
                        IClasspathEntry[] classpathEntries;
                        String imagePath = "/";
                        IPath path = type.getProjectRelativePath();
                        IClasspathEntry[] iClasspathEntryArray = classpathEntries = MidletTypeDetailsPage.this.javaProject.getJavaProject().getResolvedClasspath(true);
                        int n = classpathEntries.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IPath srcFolderPath;
                            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                            if (classpathEntry.getContentKind() == 1 && (srcFolderPath = classpathEntry.getPath().removeFirstSegments(1)).isPrefixOf(path)) {
                                path = path.removeFirstSegments(1);
                                break;
                            }
                            ++n2;
                        }
                        imagePath = String.valueOf(imagePath) + path.toString();
                        MidletTypeDetailsPage.this.iconEntry.setValue(imagePath);
                        MidletTypeDetailsPage.this.input.setIcon(imagePath);
                    }
                }
                catch (Throwable e) {
                    MTJLogger.log((int)4, (String)MTJUIMessages.MidletTypeDetailsPage_error_browseButtonSelected_image, (Throwable)e);
                }
            }
        }

        public void focusGained(FormEntry entry) {
        }

        public void linkActivated(HyperlinkEvent e) {
        }

        public void linkEntered(HyperlinkEvent e) {
        }

        public void linkExited(HyperlinkEvent e) {
        }

        public void selectionChanged(FormEntry entry) {
        }

        public void textDirty(FormEntry entry) {
            this.textValueChanged(entry);
        }

        public void textValueChanged(FormEntry entry) {
            if (entry == MidletTypeDetailsPage.this.classEntry) {
                MidletTypeDetailsPage.this.input.setClassName(entry.getValue());
            } else if (entry == MidletTypeDetailsPage.this.iconEntry) {
                MidletTypeDetailsPage.this.input.setIcon(entry.getValue());
            } else if (entry == MidletTypeDetailsPage.this.nameEntry) {
                MidletTypeDetailsPage.this.input.setName(entry.getValue(), true);
                MidletTypeDetailsPage.this.input.setMidletName(entry.getValue());
            }
        }
    }
}

