/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.form.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.editors.IModelListener;
import org.eclipse.mtj.internal.ui.editors.jad.form.JADFormEditor;
import org.eclipse.mtj.internal.ui.editors.jad.form.pages.MidletType;
import org.eclipse.mtj.internal.ui.editors.jad.form.pages.MidletTypeDetailsPage;
import org.eclipse.mtj.internal.ui.editors.jad.form.pages.MidletsModel;
import org.eclipse.mtj.internal.ui.forms.blocks.DetailPage;
import org.eclipse.mtj.internal.ui.forms.blocks.MasterLabelProvider;
import org.eclipse.mtj.internal.ui.forms.blocks.NamedObject;
import org.eclipse.mtj.internal.ui.forms.blocks.ScrolledPropertiesBlock;
import org.eclipse.mtj.ui.editors.jad.AbstractJADEditorPage;
import org.eclipse.mtj.ui.editors.jad.IManifestPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class MidletsEditorPage
extends AbstractJADEditorPage
implements IModelListener {
    public static final String MIDLET_PREFIX = "MIDlet-";
    public static final String MIDLETS_PAGEID = "midlets";
    private Button add;
    private ScrolledPropertiesBlock block;
    private Button down;
    private int midletcount = 0;
    private MidletsModel model;
    private Button remove;
    private int storedMidletCount;
    private Button up;
    List<DetailPage> list = new ArrayList<DetailPage>();

    public MidletsEditorPage() {
        super(MIDLETS_PAGEID, MTJUIMessages.MidletsEditorPage_title);
        this.model = new MidletsModel(null);
        this.model.addModelListener(this);
    }

    public MidletsEditorPage(JADFormEditor editor, String title) {
        super(editor, MIDLETS_PAGEID, title);
        this.model = new MidletsModel(null);
        this.model.addModelListener(this);
    }

    public void doSave(IProgressMonitor monitor) {
        IManifestPreferenceStore store = this.getPreferenceStore();
        Object[] midlets = this.model.getContents();
        int currentMidletCount = midlets.length;
        int i = 0;
        while (i < currentMidletCount) {
            store.setValue(MIDLET_PREFIX + (i + 1), ((MidletType)midlets[i]).toString());
            ++i;
        }
        while (i < this.storedMidletCount) {
            store.setToDefault(MIDLET_PREFIX + (i + 1));
            ++i;
        }
        this.midletcount = currentMidletCount;
        this.storedMidletCount = currentMidletCount;
        this.setDirty(false);
    }

    public void editorInputChanged() {
        if (this.model != null) {
            this.model.clear();
        }
        this.updateMidletProperties();
        this.midletcount = 0;
        if (this.block != null) {
            this.block.refresh();
        }
        for (DetailPage page : this.list) {
            if (page.getObjectClass() != MidletType.class) continue;
            IDetailsPage detailsPage = page.getDetailsPage();
            detailsPage.selectionChanged(null, this.block.getCurrentSelectedItem());
        }
    }

    public String getTitle() {
        return MTJUIMessages.MidletsEditorPage_title;
    }

    public boolean isManagingProperty(String property) {
        boolean manages = property.startsWith(MIDLET_PREFIX);
        if (manages) {
            String value = property.substring(MIDLET_PREFIX.length());
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                manages = false;
            }
        }
        return manages;
    }

    public void modelChanged(Object[] objects, String type, String property) {
        this.block.refresh();
        this.setDirty(true);
    }

    public void setFocus() {
    }

    private void createButtonsListeners() {
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MidletsEditorPage.this.midletcount = MidletsEditorPage.this.model.getContents().length + 1;
                String midletName = MidletsEditorPage.MIDLET_PREFIX + String.valueOf(MidletsEditorPage.this.midletcount);
                MidletType midlet = new MidletType(midletName, midletName, "", "");
                MidletsEditorPage.this.model.add(new NamedObject[]{midlet}, true);
                MidletsEditorPage.this.block.setCurrentSelectedItem((ISelection)new StructuredSelection((Object)midlet));
                MidletsEditorPage.this.block.refresh();
                MidletsEditorPage.this.updateButtonsState();
            }
        });
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ssel = (IStructuredSelection)MidletsEditorPage.this.block.getCurrentSelectedItem();
                if (ssel.size() == 1) {
                    MidletType type = (MidletType)ssel.getFirstElement();
                    int indexToSelect = Math.min(Arrays.asList(MidletsEditorPage.this.model.getContents()).indexOf(type) + 1, MidletsEditorPage.this.midletcount - 1) - 1;
                    MidletsEditorPage.this.model.remove(new MidletType[]{type}, true);
                    Object[] contents = MidletsEditorPage.this.model.getContents();
                    MidletsEditorPage.this.midletcount = contents.length;
                    if (indexToSelect >= 0) {
                        MidletsEditorPage.this.block.setCurrentSelectedItem((ISelection)new StructuredSelection(contents[indexToSelect]));
                    }
                    MidletsEditorPage.this.updateButtonsState();
                }
            }
        });
        this.up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection seletion;
                if (MidletsEditorPage.this.up.isEnabled() && (seletion = (IStructuredSelection)MidletsEditorPage.this.block.getCurrentSelectedItem()).size() == 1) {
                    MidletType type = (MidletType)seletion.getFirstElement();
                    MidletsEditorPage.this.model.reorder(type, MidletsModel.Direction.UP);
                    MidletsEditorPage.this.updateButtonsState();
                }
            }
        });
        this.down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection seletion;
                if (MidletsEditorPage.this.down.isEnabled() && (seletion = (IStructuredSelection)MidletsEditorPage.this.block.getCurrentSelectedItem()).size() == 1) {
                    MidletType type = (MidletType)seletion.getFirstElement();
                    MidletsEditorPage.this.model.reorder(type, MidletsModel.Direction.DOWN);
                    MidletsEditorPage.this.updateButtonsState();
                }
            }
        });
    }

    private void updateButtonsState() {
        boolean enabled;
        ISelection selection = this.block.getCurrentSelectedItem();
        int selectionCount = 0;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            selectionCount = ((IStructuredSelection)selection).size();
        }
        this.remove.setEnabled(selectionCount > 0);
        Object[] contents = this.model.getContents();
        boolean bl = enabled = selectionCount == 1;
        if (enabled) {
            Object selectedItem = ((IStructuredSelection)selection).getFirstElement();
            this.up.setEnabled(contents[0] != selectedItem);
            this.down.setEnabled(contents[contents.length - 1] != selectedItem);
        } else {
            this.up.setEnabled(false);
            this.down.setEnabled(false);
        }
    }

    private void updateMidletProperties() {
        ArrayList<MidletType> midlets = new ArrayList<MidletType>();
        LinkedHashMap<String, String> midletsMap = this.collectAndNormalizePropertiesWithPrefix(MIDLET_PREFIX);
        for (Map.Entry<String, String> midletEntry : midletsMap.entrySet()) {
            String propName = midletEntry.getKey();
            String propValue = midletEntry.getValue();
            MidletType midletType = new MidletType(propName, propValue);
            midletType.setName(midletType.getMidletName(), false);
            midlets.add(midletType);
        }
        this.midletcount = this.storedMidletCount = midletsMap.size();
        if (!midlets.isEmpty()) {
            this.model.add(midlets.toArray(new NamedObject[0]), false);
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.list.add(new DetailPage(MidletType.class, new MidletTypeDetailsPage(this.getJavaProject())));
        this.block = new ScrolledPropertiesBlock(this, new MasterContentProvider(), new MidletMasterLabelProvider(), this.list);
        this.block.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MidletsEditorPage.this.updateButtonsState();
            }
        });
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(this.getTitle());
        toolkit.decorateFormHeading(form.getForm());
        this.createErrorMessageHandler(managedForm);
        final String href = this.getHelpResource();
        if (href != null) {
            IToolBarManager manager = form.getToolBarManager();
            Action helpAction = new Action(MTJUIMessages.MidletsEditorPage_help_action){

                public void run() {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(href);
                }
            };
            helpAction.setImageDescriptor(MTJUIPluginImages.DESC_LINKTOHELP);
            manager.add((IAction)helpAction);
        }
        form.updateToolBar();
        this.block.createContent(managedForm);
        this.add = this.block.getButtonBarBlock().getButton(0);
        this.add.setEnabled(true);
        this.remove = this.block.getButtonBarBlock().getButton(2);
        this.up = this.block.getButtonBarBlock().getButton(3);
        this.down = this.block.getButtonBarBlock().getButton(4);
        this.createButtonsListeners();
        this.updateButtonsState();
    }

    protected String getHelpResource() {
        return "/org.eclipse.mtj.doc.user/html/reference/editors/jad_editor/midlets.html";
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.setDirty(false);
        this.updateMidletProperties();
    }

    class MasterContentProvider
    implements IStructuredContentProvider {
        MasterContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return MidletsEditorPage.this.model.getContents();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class MidletMasterLabelProvider
    extends MasterLabelProvider {
        MidletMasterLabelProvider() {
        }

        public Image getColumnImage(Object obj, int index) {
            return MTJUIPluginImages.DESC_MIDLET_ICON.createImage();
        }

        public String getColumnText(Object obj, int index) {
            return ((MidletType)obj).getName();
        }
    }
}

