/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.form.pages;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mtj.core.build.sign.ISignatureProperties;
import org.eclipse.mtj.core.project.IMTJProjectListener;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProjectListener;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.core.sdk.ISDK;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.sdk.device.midp.PackagingModel;
import org.eclipse.mtj.internal.core.sdk.device.midp.Profile;
import org.eclipse.mtj.internal.core.security.meep.MEEPPermissionsProvider;
import org.eclipse.mtj.internal.core.sign.DefaultKeyStoreManager;
import org.eclipse.mtj.internal.core.sign.KeyStoreEntry;
import org.eclipse.mtj.internal.core.sign.KeyStoreManagerException;
import org.eclipse.mtj.internal.core.sign.SecurityPermissionsScanner;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.dialog.MEEPSecurityPermissionsDialog;
import org.eclipse.mtj.internal.ui.dialog.SecurityPermissionsDialog;
import org.eclipse.mtj.internal.ui.dialog.SigningPasswordDialog;
import org.eclipse.mtj.internal.ui.editors.jad.form.JADFormEditor;
import org.eclipse.mtj.internal.ui.editors.jad.form.pages.OverviewEditorPage;
import org.eclipse.mtj.internal.ui.forms.blocks.GenericListBlock;
import org.eclipse.mtj.internal.ui.forms.blocks.GenericListBlockItem;
import org.eclipse.mtj.internal.ui.forms.blocks.GenericListBlockListener;
import org.eclipse.mtj.ui.editors.jad.AbstractJADEditorPage;
import org.eclipse.mtj.ui.editors.jad.IManifestPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SigningJADEditorPage
extends AbstractJADEditorPage
implements OverviewEditorPage.ActiveDeviceChangeListener,
OverviewEditorPage.DeviceProfileChangeListener,
OverviewEditorPage.PackagingModelChangeListener {
    public static final String ID = "signing";
    private static final String COMMA = ",";
    private static final String TITLE = MTJUIMessages.PermissionsPage_title;
    private Combo combo;
    private Button enableButton;
    private GenericListBlock<SecurityPermissionListItem> optPermissionBlock;
    private List<SecurityPermissionListItem> optMIDPPermissions;
    private List<SecurityPermissionListItem> optMEEPPermissions;
    private IMidletSuiteProjectListener projectListener;
    private GenericListBlock<SecurityPermissionListItem> reqPermissionBlock;
    private List<SecurityPermissionListItem> reqMIDPPermissions;
    private List<SecurityPermissionListItem> reqMEEPPermissions;
    private MEEPPermissionsProvider meepPermissionsProvider;
    private PackagingModel packagingModel;
    private boolean useMEEPSecurity;

    public SigningJADEditorPage(JADFormEditor editor, OverviewEditorPage overviewEditorPage) {
        super(editor, ID, TITLE);
        IDevice device;
        MTJRuntime activeMTJRuntime;
        IMidletSuiteProject midletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.getJavaProject());
        ISDK sdk = null;
        MTJRuntimeList runtimeList = midletSuiteProject.getRuntimeList();
        if (runtimeList != null && (activeMTJRuntime = runtimeList.getActiveMTJRuntime()) != null && (device = activeMTJRuntime.getDevice()) != null) {
            sdk = device.getSDK();
        }
        this.meepPermissionsProvider = new MEEPPermissionsProvider(sdk);
        this.packagingModel = midletSuiteProject.getProjectPackagingModel();
        this.useMEEPSecurity = Profile.MEEP_80.toString().equals(midletSuiteProject.getApplicationDescriptor().getMicroEditionProfile());
        overviewEditorPage.addActiveDeviceChangeListener(this);
        overviewEditorPage.addDeviceProfileChangeListener(this);
        overviewEditorPage.addPackagingModelChangeListener(this);
        this.reqMIDPPermissions = new LinkedList<SecurityPermissionListItem>();
        this.reqMEEPPermissions = new LinkedList<SecurityPermissionListItem>();
        this.optMIDPPermissions = new LinkedList<SecurityPermissionListItem>();
        this.optMEEPPermissions = new LinkedList<SecurityPermissionListItem>();
        this.listenForProjectSignatureUpdates();
    }

    @Override
    public void dispose() {
        super.dispose();
        IMidletSuiteProject midletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.getJavaProject(), (boolean)false);
        if (midletSuiteProject != null) {
            midletSuiteProject.removeMTJProjectListener((IMTJProjectListener)this.projectListener);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        String permissionSpec;
        IManifestPreferenceStore store = this.getPreferenceStore();
        this.clearClassPermissionsFromStore((IPreferenceStore)store, this.collectAndNormalizePropertiesWithPrefix("MIDlet-Permission-").keySet());
        this.clearClassPermissionsFromStore((IPreferenceStore)store, this.collectAndNormalizePropertiesWithPrefix("MIDlet-Permission-Opt-").keySet());
        this.clearClassPermissionsFromStore((IPreferenceStore)store, this.collectAndNormalizePropertiesWithPrefix("LIBlet-Permission-").keySet());
        this.clearClassPermissionsFromStore((IPreferenceStore)store, this.collectAndNormalizePropertiesWithPrefix("LIBlet-Permission-Opt-").keySet());
        ArrayList<String> reqClassPermissionsSpecs = new ArrayList<String>();
        ArrayList<String> optClassPermissionsSpecs = new ArrayList<String>();
        ArrayList<String> reqNonClassPermissionsSpecs = new ArrayList<String>();
        ArrayList<String> optNonClassPermissionsSpecs = new ArrayList<String>();
        List<SecurityPermissionListItem> reqPermissions = this.useMEEPSecurity ? this.reqMEEPPermissions : this.reqMIDPPermissions;
        List<SecurityPermissionListItem> optPermissions = this.useMEEPSecurity ? this.optMEEPPermissions : this.optMIDPPermissions;
        for (SecurityPermissionListItem permission : reqPermissions) {
            permissionSpec = permission.getText().trim();
            if (permission.isPermissionClass()) {
                reqClassPermissionsSpecs.add(permissionSpec);
                continue;
            }
            reqNonClassPermissionsSpecs.add(permissionSpec);
        }
        for (SecurityPermissionListItem permission : optPermissions) {
            permissionSpec = permission.getText().trim();
            if (permission.isPermissionClass()) {
                optClassPermissionsSpecs.add(permissionSpec);
                continue;
            }
            optNonClassPermissionsSpecs.add(permissionSpec);
        }
        if (this.useMEEPSecurity) {
            this.saveClassPermissionsToStore((IPreferenceStore)store, this.packagingModel == PackagingModel.MIDLET ? "MIDlet-Permission-" : "LIBlet-Permission-", reqClassPermissionsSpecs);
            this.saveClassPermissionsToStore((IPreferenceStore)store, this.packagingModel == PackagingModel.MIDLET ? "MIDlet-Permission-Opt-" : "LIBlet-Permission-Opt-", optClassPermissionsSpecs);
        }
        this.saveNonClassPermissionsToStore((IPreferenceStore)store, this.packagingModel == PackagingModel.MIDLET ? "MIDlet-Permissions" : "LIBlet-Permissions", reqNonClassPermissionsSpecs);
        this.saveNonClassPermissionsToStore((IPreferenceStore)store, this.packagingModel == PackagingModel.MIDLET ? "MIDlet-Permissions-Opt" : "LIBlet-Permissions-Opt", optNonClassPermissionsSpecs);
        this.updateProjectSigningState();
        this.setDirty(false);
    }

    private void clearClassPermissionsFromStore(IPreferenceStore store, Set<String> permissionJADKeys) {
        for (String permissionJADKey : permissionJADKeys) {
            store.setToDefault(permissionJADKey);
        }
    }

    private void saveClassPermissionsToStore(IPreferenceStore store, String permissionsJADKeyPrefix, Collection<String> permissionSpecs) {
        int idx = 1;
        for (String permissionSpec : permissionSpecs) {
            store.setValue(String.valueOf(permissionsJADKeyPrefix) + idx, permissionSpec);
            ++idx;
        }
    }

    private List<String> collectNonClassPermissions(IPreferenceStore store, String permissionsJADKey) {
        String permissions;
        ArrayList<String> result = new ArrayList<String>();
        if (store.contains(permissionsJADKey) && (permissions = store.getString(permissionsJADKey)).length() > 0) {
            String[] permissionsSplit;
            String[] stringArray = permissionsSplit = permissions.split(COMMA);
            int n = permissionsSplit.length;
            int n2 = 0;
            while (n2 < n) {
                String permission = stringArray[n2];
                result.add(permission.trim());
                ++n2;
            }
        }
        return result;
    }

    private void saveNonClassPermissionsToStore(IPreferenceStore store, String permissionsJADKey, Collection<String> permissionSpecs) {
        StringBuilder toSave = new StringBuilder();
        for (String permissionSpec : permissionSpecs) {
            if (toSave.length() > 0) {
                toSave.append(COMMA);
            }
            toSave.append(permissionSpec);
        }
        store.setValue(permissionsJADKey, toSave.toString());
    }

    @Override
    public void editorInputChanged() {
        IManifestPreferenceStore store = this.getPreferenceStore();
        this.reqMEEPPermissions.clear();
        this.reqMIDPPermissions.clear();
        this.optMEEPPermissions.clear();
        this.optMIDPPermissions.clear();
        String reqPermissionJADKeyPrefix = this.packagingModel == PackagingModel.MIDLET ? "MIDlet-Permission-" : "LIBlet-Permission-";
        String notRelevantReqPermissionJADKeyPrefix = this.packagingModel == PackagingModel.MIDLET ? "LIBlet-Permission-" : "MIDlet-Permission-";
        String optPermissionJADKeyPrefix = this.packagingModel == PackagingModel.MIDLET ? "MIDlet-Permission-Opt-" : "LIBlet-Permission-Opt-";
        String notRelevantOptPermissionJADKeyPrefix = this.packagingModel == PackagingModel.MIDLET ? "LIBlet-Permission-Opt-" : "MIDlet-Permission-Opt-";
        LinkedHashMap<String, String> reqClassPermission = this.collectAndNormalizePropertiesWithPrefix(reqPermissionJADKeyPrefix);
        LinkedHashMap<String, String> notRelavantReqClassPermission = this.collectAndNormalizePropertiesWithPrefix(notRelevantReqPermissionJADKeyPrefix);
        LinkedHashMap<String, String> optClassPermission = this.collectAndNormalizePropertiesWithPrefix(optPermissionJADKeyPrefix);
        LinkedHashMap<String, String> notRelavantOptClassPermission = this.collectAndNormalizePropertiesWithPrefix(notRelevantOptPermissionJADKeyPrefix);
        LinkedHashSet<String> reqClassPermissionsSpecs = new LinkedHashSet<String>(reqClassPermission.values());
        if (!this.useMEEPSecurity || reqClassPermissionsSpecs.size() < reqClassPermission.size()) {
            this.clearClassPermissionsFromStore((IPreferenceStore)store, reqClassPermission.keySet());
        }
        LinkedHashSet<String> optClassPermissionsSpecs = new LinkedHashSet<String>();
        for (String permissionSpec : optClassPermission.values()) {
            if (reqClassPermissionsSpecs.contains(permissionSpec)) continue;
            optClassPermissionsSpecs.add(permissionSpec);
        }
        if (!this.useMEEPSecurity || optClassPermissionsSpecs.size() < optClassPermission.size()) {
            this.clearClassPermissionsFromStore((IPreferenceStore)store, optClassPermission.keySet());
        }
        if (notRelavantReqClassPermission.size() > 0) {
            for (String permissionSpec : notRelavantReqClassPermission.values()) {
                if (optClassPermissionsSpecs.contains(permissionSpec)) continue;
                reqClassPermissionsSpecs.add(permissionSpec);
            }
            this.clearClassPermissionsFromStore((IPreferenceStore)store, notRelavantReqClassPermission.keySet());
        }
        if (notRelavantOptClassPermission.size() > 0) {
            for (String permissionSpec : notRelavantOptClassPermission.values()) {
                if (reqClassPermissionsSpecs.contains(permissionSpec)) continue;
                optClassPermissionsSpecs.add(permissionSpec);
            }
            this.clearClassPermissionsFromStore((IPreferenceStore)store, notRelavantOptClassPermission.keySet());
        }
        String reqPermissionJADKey = this.packagingModel == PackagingModel.MIDLET ? "MIDlet-Permissions" : "LIBlet-Permissions";
        String notRelevantReqPermissionJADKey = this.packagingModel == PackagingModel.MIDLET ? "LIBlet-Permissions" : "MIDlet-Permissions";
        String optPermissionJADKey = this.packagingModel == PackagingModel.MIDLET ? "MIDlet-Permissions-Opt" : "LIBlet-Permissions-Opt";
        String notRelevantOptPermissionJADKey = this.packagingModel == PackagingModel.MIDLET ? "LIBlet-Permissions-Opt" : "MIDlet-Permissions-Opt";
        List<String> reqNonClassPermission = this.collectNonClassPermissions((IPreferenceStore)store, reqPermissionJADKey);
        List<String> notRelavantReqNonClassPermission = this.collectNonClassPermissions((IPreferenceStore)store, notRelevantReqPermissionJADKey);
        List<String> optNonClassPermission = this.collectNonClassPermissions((IPreferenceStore)store, optPermissionJADKey);
        List<String> notRelavantOptNonClassPermission = this.collectNonClassPermissions((IPreferenceStore)store, notRelevantOptPermissionJADKey);
        LinkedHashSet<String> reqNonClassPermissionsSpecs = new LinkedHashSet<String>(reqNonClassPermission);
        if (reqNonClassPermissionsSpecs.size() < reqNonClassPermission.size()) {
            store.setToDefault(reqPermissionJADKey);
        }
        LinkedHashSet<String> optNonClassPermissionsSpecs = new LinkedHashSet<String>();
        for (String permissionSpec : optNonClassPermission) {
            if (reqNonClassPermissionsSpecs.contains(permissionSpec)) continue;
            optNonClassPermissionsSpecs.add(permissionSpec);
        }
        if (optNonClassPermissionsSpecs.size() < optNonClassPermission.size()) {
            store.setToDefault(optPermissionJADKey);
        }
        if (notRelavantReqNonClassPermission.size() > 0) {
            for (String permissionSpec : notRelavantReqNonClassPermission) {
                if (optNonClassPermissionsSpecs.contains(permissionSpec)) continue;
                reqNonClassPermissionsSpecs.add(permissionSpec);
            }
            store.setToDefault(notRelevantReqPermissionJADKey);
        }
        if (notRelavantOptNonClassPermission.size() > 0) {
            for (String permissionSpec : notRelavantOptNonClassPermission) {
                if (reqNonClassPermissionsSpecs.contains(permissionSpec)) continue;
                optNonClassPermissionsSpecs.add(permissionSpec);
            }
            store.setToDefault(notRelevantOptPermissionJADKey);
        }
        for (String permissionSpec : reqClassPermissionsSpecs) {
            this.reqMEEPPermissions.add(new SecurityPermissionListItem(permissionSpec, true));
        }
        for (String permissionSpec : optClassPermissionsSpecs) {
            this.optMEEPPermissions.add(new SecurityPermissionListItem(permissionSpec, true));
        }
        if (store.needsSaving()) {
            if (this.useMEEPSecurity) {
                this.saveClassPermissionsToStore((IPreferenceStore)store, reqPermissionJADKeyPrefix, reqClassPermissionsSpecs);
                this.saveClassPermissionsToStore((IPreferenceStore)store, optPermissionJADKeyPrefix, optClassPermissionsSpecs);
            }
            this.saveNonClassPermissionsToStore((IPreferenceStore)store, reqPermissionJADKey, reqNonClassPermissionsSpecs);
            this.saveNonClassPermissionsToStore((IPreferenceStore)store, optPermissionJADKey, optNonClassPermissionsSpecs);
        }
        if (this.useMEEPSecurity) {
            for (String permissionSpec : reqNonClassPermissionsSpecs) {
                this.reqMEEPPermissions.add(new SecurityPermissionListItem(permissionSpec, false));
            }
            for (String permissionSpec : optNonClassPermissionsSpecs) {
                this.optMEEPPermissions.add(new SecurityPermissionListItem(permissionSpec, false));
            }
        } else {
            for (String permissionSpec : reqNonClassPermissionsSpecs) {
                this.reqMIDPPermissions.add(new SecurityPermissionListItem(permissionSpec, false));
            }
            for (String permissionSpec : optNonClassPermissionsSpecs) {
                this.optMIDPPermissions.add(new SecurityPermissionListItem(permissionSpec, false));
            }
        }
        if (this.reqPermissionBlock != null) {
            this.reqPermissionBlock.update(null);
        }
        if (this.optPermissionBlock != null) {
            this.optPermissionBlock.update(null);
        }
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public boolean isManagingProperty(String property) {
        if (property == null) {
            return false;
        }
        String[] managedProperties = new String[]{"MIDlet-Permissions", "MIDlet-Permissions-Opt", "LIBlet-Permissions", "LIBlet-Permissions-Opt"};
        String[] managedPropertyPrefixes = new String[]{"MIDlet-Permission-", "MIDlet-Permission-Opt-", "LIBlet-Permission-", "LIBlet-Permission-Opt-"};
        String[] stringArray = managedProperties;
        int n = managedProperties.length;
        int n2 = 0;
        while (n2 < n) {
            String managedProperty = stringArray[n2];
            if (managedProperty.equals(property)) {
                return true;
            }
            ++n2;
        }
        stringArray = managedPropertyPrefixes;
        n = managedPropertyPrefixes.length;
        n2 = 0;
        while (n2 < n) {
            String managedPropertyPrefix = stringArray[n2];
            if (property.startsWith(managedPropertyPrefix)) {
                String value = property.substring(managedPropertyPrefix.length());
                try {
                    if (Integer.parseInt(value) > 0) {
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++n2;
        }
        return false;
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.getErrorMessageManager().removeAllMessages();
        }
    }

    private void editMEEPPermission(ListId listId, SecurityPermissionListItem itemToEdit) {
        GenericListBlock<SecurityPermissionListItem> block = null;
        switch (listId) {
            case Required: {
                block = this.reqPermissionBlock;
                break;
            }
            case Optional: {
                block = this.optPermissionBlock;
                break;
            }
            default: {
                return;
            }
        }
        ArrayList<String> existingPermissions = new ArrayList<String>();
        for (SecurityPermissionListItem item : this.reqMEEPPermissions) {
            existingPermissions.add(item.getText());
        }
        for (SecurityPermissionListItem item : this.optMEEPPermissions) {
            existingPermissions.add(item.getText());
        }
        MEEPPermissionsProvider.PermissionDefinition permission = MEEPSecurityPermissionsDialog.getPermission(this.getPartControl().getShell(), this.meepPermissionsProvider, existingPermissions, itemToEdit.getText());
        if (permission == null) {
            return;
        }
        itemToEdit.setPermission(permission.toString());
        itemToEdit.setPermissionClass(permission.isPermissionClass());
        this.setDirty(true);
        block.update(null);
    }

    private void addPermissions(ListId listId) {
        Object[] result = null;
        Shell parentShell = this.getPartControl().getShell();
        GenericListBlock<SecurityPermissionListItem> block = null;
        List<SecurityPermissionListItem> list = null;
        switch (listId) {
            case Required: {
                block = this.reqPermissionBlock;
                list = this.useMEEPSecurity ? this.reqMEEPPermissions : this.reqMIDPPermissions;
                break;
            }
            case Optional: {
                block = this.optPermissionBlock;
                list = this.useMEEPSecurity ? this.optMEEPPermissions : this.optMIDPPermissions;
                break;
            }
            default: {
                return;
            }
        }
        if (this.useMEEPSecurity) {
            ArrayList<String> existingPermissions = new ArrayList<String>();
            for (SecurityPermissionListItem item : this.reqMEEPPermissions) {
                existingPermissions.add(item.getText());
            }
            for (SecurityPermissionListItem item : this.optMEEPPermissions) {
                existingPermissions.add(item.getText());
            }
            MEEPPermissionsProvider.PermissionDefinition permission = MEEPSecurityPermissionsDialog.getPermission(parentShell, this.meepPermissionsProvider, existingPermissions, null);
            if (permission != null) {
                result = new Object[]{permission};
            }
        } else {
            CheckedTreeSelectionDialog dialog = SecurityPermissionsDialog.createDialog(parentShell);
            if (dialog.open() == 0) {
                result = dialog.getResult();
            }
        }
        if (result != null) {
            this.addPermissionsToList(list, result, block);
        }
    }

    private void addPermissionsToList(List<SecurityPermissionListItem> permissionsList, Object[] result, GenericListBlock<SecurityPermissionListItem> block) {
        ArrayList<SecurityPermissionListItem> newPermissions = new ArrayList<SecurityPermissionListItem>();
        Object[] objectArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            MEEPPermissionsProvider.PermissionDefinition meepPermission;
            Object object = objectArray[n2];
            SecurityPermissionsDialog.PermissionNode midpPermission = object instanceof SecurityPermissionsDialog.PermissionNode ? (SecurityPermissionsDialog.PermissionNode)object : null;
            MEEPPermissionsProvider.PermissionDefinition permissionDefinition = meepPermission = object instanceof MEEPPermissionsProvider.PermissionDefinition ? (MEEPPermissionsProvider.PermissionDefinition)object : null;
            if (midpPermission != null || meepPermission != null) {
                boolean isNew = true;
                String permission = midpPermission == null ? meepPermission.toString() : midpPermission.getPermission();
                for (SecurityPermissionListItem item : this.useMEEPSecurity ? this.reqMEEPPermissions : this.reqMIDPPermissions) {
                    if (!item.getText().equals(permission)) continue;
                    isNew = false;
                }
                if (isNew) {
                    for (SecurityPermissionListItem item : this.useMEEPSecurity ? this.optMEEPPermissions : this.optMIDPPermissions) {
                        if (!item.getText().equals(permission)) continue;
                        isNew = false;
                    }
                }
                if (isNew) {
                    SecurityPermissionListItem newPermission = new SecurityPermissionListItem(permission, meepPermission == null ? false : meepPermission.isPermissionClass());
                    permissionsList.add(newPermission);
                    newPermissions.add(newPermission);
                }
            }
            ++n2;
        }
        if (!newPermissions.isEmpty()) {
            this.setDirty(true);
            block.update((IStructuredSelection)new StructuredSelection(newPermissions));
        }
    }

    private void createAliasSection(IManagedForm managedForm, Composite body) {
        FormToolkit toolkit = managedForm.getToolkit();
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        Composite sectionBody = this.createSection(managedForm, body, MTJUIMessages.PermissionsPage_signProperties, null, gridData);
        sectionBody.setLayout((Layout)new GridLayout(2, false));
        toolkit.createLabel(sectionBody, MTJUIMessages.PermissionsPage_keyAlias);
        this.combo = new Combo(sectionBody, 12);
        gridData = new GridData(4, 0x1000000, true, false);
        this.combo.setLayoutData((Object)gridData);
        this.combo.setFocus();
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SigningJADEditorPage.this.setDirty(true);
            }
        });
    }

    private void createListsSection(IManagedForm managedForm, Composite body) {
        Composite reqSectionBody = this.createSection(managedForm, body, MTJUIMessages.PermissionsPage_requiredPermissionsTitle, MTJUIMessages.PermissionsPage_requiredPermissionsMessage, new GridData(4, 4, true, true));
        reqSectionBody.setLayout((Layout)new GridLayout(1, false));
        this.reqPermissionBlock = new GenericListBlock<SecurityPermissionListItem>(reqSectionBody, 2050, 126, this.useMEEPSecurity ? this.reqMEEPPermissions : this.reqMIDPPermissions);
        this.reqPermissionBlock.setButtonVisible(1, this.useMEEPSecurity);
        this.reqPermissionBlock.setButtonVisible(5, !this.useMEEPSecurity);
        this.reqPermissionBlock.addGenericListBlockListener(new GenericListBlockListener<SecurityPermissionListItem>(){

            @Override
            public void addButtonPressed() {
                SigningJADEditorPage.this.addPermissions(ListId.Required);
            }

            @Override
            public void editButtonPressed(SecurityPermissionListItem item) {
                SigningJADEditorPage.this.editMEEPPermission(ListId.Required, item);
            }

            @Override
            public void downButtonPressed() {
                SigningJADEditorPage.this.setDirty(true);
            }

            @Override
            public void itemsRemoved(List<SecurityPermissionListItem> _items) {
                SigningJADEditorPage.this.setDirty(true);
            }

            @Override
            public void scan() {
                SigningJADEditorPage.this.scanProjectClasses(ListId.Required);
            }

            @Override
            public void upButtonPressed() {
                SigningJADEditorPage.this.setDirty(true);
            }
        });
        Composite optSectionBody = this.createSection(managedForm, body, MTJUIMessages.PermissionsPage_optionalPermissionsTitle, MTJUIMessages.PermissionsPage_optionalPermissionsMessage, new GridData(4, 4, true, true));
        optSectionBody.setLayout((Layout)new GridLayout(1, false));
        this.optPermissionBlock = new GenericListBlock<SecurityPermissionListItem>(optSectionBody, 2050, 126, this.useMEEPSecurity ? this.optMEEPPermissions : this.optMIDPPermissions);
        this.optPermissionBlock.setButtonVisible(1, this.useMEEPSecurity);
        this.optPermissionBlock.setButtonVisible(5, !this.useMEEPSecurity);
        this.optPermissionBlock.addGenericListBlockListener(new GenericListBlockListener<SecurityPermissionListItem>(){

            @Override
            public void addButtonPressed() {
                SigningJADEditorPage.this.addPermissions(ListId.Optional);
            }

            @Override
            public void editButtonPressed(SecurityPermissionListItem item) {
                SigningJADEditorPage.this.editMEEPPermission(ListId.Optional, item);
            }

            @Override
            public void downButtonPressed() {
                SigningJADEditorPage.this.setDirty(true);
            }

            @Override
            public void itemsRemoved(List<SecurityPermissionListItem> _items) {
                SigningJADEditorPage.this.setDirty(true);
            }

            @Override
            public void scan() {
                SigningJADEditorPage.this.scanProjectClasses(ListId.Optional);
            }

            @Override
            public void upButtonPressed() {
                SigningJADEditorPage.this.setDirty(true);
            }
        });
    }

    private Composite createSection(IManagedForm managedForm, Composite listsParent, String text, String description, GridData gridData) {
        FormToolkit toolkit = managedForm.getToolkit();
        Section section = toolkit.createSection(listsParent, 384);
        if (text != null) {
            section.setText(text);
        }
        if (description != null) {
            section.setDescription(description);
        }
        section.setLayoutData((Object)gridData);
        section.setLayout((Layout)new GridLayout(1, false));
        Composite client = toolkit.createComposite((Composite)section, 0);
        client.setLayoutData((Object)new GridData(4, 4, true, true));
        section.setClient((Control)client);
        return client;
    }

    private void createTopSection(IManagedForm managedForm, Composite body) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.enableButton = toolkit.createButton(body, MTJUIMessages.PermissionsPage_signPackage, 32);
        this.enableButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SigningJADEditorPage.this.updateWidgetsStates(SigningJADEditorPage.this.enableButton.getSelection());
                SigningJADEditorPage.this.setDirty(true);
            }
        });
        ISignatureProperties signProperties = this.getProjectSignatureProperties();
        if (signProperties != null) {
            this.enableButton.setSelection(signProperties.isSignProject());
        }
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        this.enableButton.setLayoutData((Object)gridData);
    }

    private ISignatureProperties getProjectSignatureProperties() {
        ISignatureProperties signProperties = null;
        IMidletSuiteProject midletProject = null;
        try {
            midletProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.getJavaProject());
            signProperties = midletProject.getSignatureProperties();
        }
        catch (CoreException e) {
            String message = NLS.bind((String)"Unable to get project signing properties: {0}", (Object)e.getMessage());
            MTJLogger.log((int)4, (String)message);
            this.getErrorMessageManager().addMessage((Object)message, message, null, 3);
        }
        return signProperties;
    }

    private void listAliases(final Combo combo) {
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                String message;
                ISignatureProperties properties = null;
                String password = null;
                String path = null;
                File file = null;
                combo.removeAll();
                properties = SigningJADEditorPage.this.getProjectSignatureProperties();
                if (properties == null) {
                    return;
                }
                try {
                    path = properties.getAbsoluteKeyStorePath(SigningJADEditorPage.this.getJavaProject().getProject());
                    if (path == null) {
                        return;
                    }
                }
                catch (CoreException e) {
                    MTJLogger.log((int)4, (String)NLS.bind((String)"Unable to get keystore path: {0}", (Object)e.getMessage()));
                }
                file = new File(path);
                if (!file.exists() || !file.isFile()) {
                    return;
                }
                if (properties.getPasswordStorageMethod() == 0) {
                    SigningPasswordDialog dialog = new SigningPasswordDialog(SigningJADEditorPage.this.getPartControl().getShell(), false);
                    dialog.setTitle("KeyStore Password");
                    if (dialog.open() != 0) return;
                    password = dialog.getPassword();
                } else {
                    password = properties.getKeyStorePassword();
                }
                try {
                    DefaultKeyStoreManager manager = new DefaultKeyStoreManager(file, password);
                    manager.setProvider(properties.getKeyStoreProvider());
                    manager.setKeystoreType(properties.getKeyStoreType());
                    List entries = manager.getEntries();
                    for (KeyStoreEntry entry : entries) {
                        if (entry.getType() != KeyStoreEntry.Type.KEY_PAIR) continue;
                        combo.add(entry.getAlias());
                    }
                }
                catch (KeyStoreManagerException e) {
                    message = NLS.bind((String)"Unable to get keystore aliases: {0}", (Object)e.getMessage());
                    MTJLogger.log((int)4, (String)message);
                    SigningJADEditorPage.this.getErrorMessageManager().addMessage((Object)message, message, null, 3);
                }
                catch (Exception e) {
                    message = e.getMessage();
                    MTJLogger.log((int)4, (String)message);
                    SigningJADEditorPage.this.getErrorMessageManager().addMessage((Object)message, message, null, 3);
                }
                String alias = properties.getKeyAlias();
                if (alias == null) {
                    return;
                }
                int i = 0;
                while (i < combo.getItemCount()) {
                    if (alias.equals(combo.getItem(i))) {
                        combo.select(i);
                    }
                    ++i;
                }
            }
        });
    }

    private void listenForProjectSignatureUpdates() {
        this.projectListener = new IMidletSuiteProjectListener(){

            public void classpathRefreshed() {
            }

            public void jadFileNameChanged() {
            }

            public void metaDataSaved() {
            }

            public void packageCreated() {
            }

            public void signaturePropertiesChanged() {
                if (SigningJADEditorPage.this.enableButton != null && !SigningJADEditorPage.this.enableButton.isDisposed() && SigningJADEditorPage.this.enableButton.getSelection()) {
                    SigningJADEditorPage.this.listAliases(SigningJADEditorPage.this.combo);
                }
            }

            public void tempKeyPasswordChanged() {
            }

            public void tempKeystorePasswordChanged() {
            }
        };
        IMidletSuiteProject midletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.getJavaProject());
        if (midletSuiteProject != null) {
            midletSuiteProject.addMTJProjectListener((IMTJProjectListener)this.projectListener);
        }
    }

    private void scanProjectClasses(ListId listId) {
        IMidletSuiteProject midletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.getJavaProject());
        if (midletSuiteProject == null) {
            return;
        }
        CheckedTreeSelectionDialog dialog = SecurityPermissionsDialog.createDialog(this.getPartControl().getShell());
        SecurityPermissionsScanner scanner = new SecurityPermissionsScanner(midletSuiteProject);
        List permissionsGroups = scanner.getRequiredPermissions();
        dialog.setInitialSelections(permissionsGroups.toArray());
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            GenericListBlock<SecurityPermissionListItem> block = null;
            List<SecurityPermissionListItem> list = null;
            switch (listId) {
                case Required: {
                    block = this.reqPermissionBlock;
                    list = this.reqMIDPPermissions;
                    break;
                }
                case Optional: {
                    block = this.optPermissionBlock;
                    list = this.optMIDPPermissions;
                }
            }
            if (list != null) {
                this.addPermissionsToList(list, result, block);
            }
        }
    }

    private void updateProjectSigningState() {
        ISignatureProperties signProperties = null;
        IMidletSuiteProject midletProject = null;
        midletProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)this.getJavaProject());
        signProperties = this.getProjectSignatureProperties();
        if (signProperties == null) {
            return;
        }
        try {
            signProperties.setSignProject(this.enableButton.getSelection());
            int selectedIndex = this.combo.getSelectionIndex();
            if (selectedIndex >= 0) {
                signProperties.setKeyAlias(this.combo.getItem(selectedIndex));
            }
            midletProject.setSignatureProperties(signProperties);
            midletProject.saveMetaData();
        }
        catch (CoreException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        form.setExpandHorizontal(true);
        form.setExpandVertical(true);
        toolkit.decorateFormHeading(form.getForm());
        this.createErrorMessageHandler(managedForm);
        form.setText(this.getTitle());
        Composite body = form.getBody();
        body.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, true);
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 20;
        body.setLayout((Layout)layout);
        this.createTopSection(managedForm, body);
        this.createAliasSection(managedForm, body);
        this.createListsSection(managedForm, body);
        this.updateWidgetsStates(this.enableButton.getSelection());
        form.reflow(true);
    }

    @Override
    protected String getHelpResource() {
        return null;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.editorInputChanged();
    }

    protected void updateWidgetsStates(boolean state) {
        this.combo.setEnabled(state);
        if (state) {
            this.listAliases(this.combo);
        }
    }

    @Override
    public void activeDeviceChanged(IDevice newActiveDevice) {
        ISDK sdk;
        ISDK iSDK = sdk = newActiveDevice == null ? null : newActiveDevice.getSDK();
        if (this.meepPermissionsProvider == null || this.meepPermissionsProvider.getSDK() != sdk) {
            this.meepPermissionsProvider = new MEEPPermissionsProvider(sdk);
        }
    }

    @Override
    public void deviceProfileChanged(String newProfile) {
        boolean useMEEPSecurityOld = this.useMEEPSecurity;
        this.useMEEPSecurity = Profile.MEEP_80.toString().equals(newProfile);
        if (useMEEPSecurityOld != this.useMEEPSecurity && this.getPartControl() != null) {
            this.reqPermissionBlock.setButtonVisible(1, this.useMEEPSecurity);
            this.optPermissionBlock.setButtonVisible(1, this.useMEEPSecurity);
            this.reqPermissionBlock.setButtonVisible(5, !this.useMEEPSecurity);
            this.optPermissionBlock.setButtonVisible(5, !this.useMEEPSecurity);
            this.reqPermissionBlock.setInput(this.useMEEPSecurity ? this.reqMEEPPermissions : this.reqMIDPPermissions);
            this.optPermissionBlock.setInput(this.useMEEPSecurity ? this.optMEEPPermissions : this.optMIDPPermissions);
        }
    }

    @Override
    public void packagingModelChanged(PackagingModel newPackagingModel) {
        this.packagingModel = newPackagingModel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ListId {
        Optional,
        Required;

    }

    private class SecurityPermissionListItem
    implements GenericListBlockItem {
        private String permission;
        private boolean permissionClass;

        public SecurityPermissionListItem(String permission, boolean permissionClass) {
            this.permission = permission;
            this.permissionClass = permissionClass;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SecurityPermissionListItem) {
                SecurityPermissionListItem other = (SecurityPermissionListItem)obj;
                return this.getText().equals(other.getText());
            }
            return super.equals(obj);
        }

        public Image getImage() {
            return MTJUIPluginImages.DESC_PERMISSION_OBJ.createImage();
        }

        public String getText() {
            return this.permission;
        }

        public void setPermission(String permission) {
            this.permission = permission;
        }

        public void setPermissionClass(boolean permissionClass) {
            this.permissionClass = permissionClass;
        }

        public boolean isPermissionClass() {
            return this.permissionClass;
        }

        public int hashCode() {
            String text = this.getText();
            int hash = 0;
            int i = 0;
            while (i < text.length()) {
                hash += text.charAt(i);
                ++i;
            }
            return hash;
        }
    }
}

