/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.source.contentassist;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.mtj.internal.core.sdk.device.midp.Configuration;
import org.eclipse.mtj.internal.core.sdk.device.midp.Profile;
import org.eclipse.mtj.internal.core.util.ColonDelimitedProperties;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.ui.MTJUIPluginImages;
import org.eclipse.mtj.internal.ui.editors.jad.source.JADSourceEditor;
import org.eclipse.mtj.internal.ui.editors.jad.source.contentassist.JADAttributeCompletionProposal;
import org.eclipse.mtj.internal.ui.editors.jad.source.contentassist.JADAttributeHeadersProvider;

public class CompletionProcessor
implements IContentAssistProcessor {
    private static final String MIDLET_PREFIX = "MIDlet-";
    private static final Pattern MIDLET_PATTERN = Pattern.compile("(MIDlet-\\d+:).*");
    private static final String[] PROPERTY_PREFIXES = new String[]{"MIDlet-", "MIDlet-Permission-", "MIDlet-Permission-Opt-", "LIBlet-Permission-", "LIBlet-Permission-Opt-"};
    private final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private final char[] PROPOSAL_ACTIVATION_CHARS = new char[]{'M', 'm', ' ', ','};
    private ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    private Map<String, String> propertyPrefixesHeaders = new HashMap<String, String>();
    private ColonDelimitedProperties existedPropertis;
    private JADSourceEditor sourcePage;

    static {
        Arrays.sort(PROPERTY_PREFIXES, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
    }

    public CompletionProcessor(JADSourceEditor editor) {
        this.sourcePage = editor;
    }

    protected ICompletionProposal[] computeCompletionProposals(IDocument doc, int startOffset, int offset) {
        try {
            String currentLineValue = doc.get(startOffset, offset - startOffset);
            if (!this.isHeader(currentLineValue)) {
                return this.computeValue(currentLineValue, startOffset, offset);
            }
            return this.computeHeader(currentLineValue, startOffset, offset);
        }
        catch (BadLocationException badLocationException) {
            return new ICompletionProposal[0];
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            IDocument doc = viewer.getDocument();
            this.parseDocument(doc);
            int lineNum = doc.getLineOfOffset(offset);
            int lineStart = doc.getLineOffset(lineNum);
            return this.computeCompletionProposals(doc, lineStart, offset);
        }
        catch (BadLocationException badLocationException) {
            return this.NO_COMPLETIONS;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return this.NO_CONTEXTS;
    }

    protected ICompletionProposal[] computeHeader(String currentValue, int startOffset, int offset) {
        String[] headers;
        ArrayList<JADAttributeCompletionProposal> completions = new ArrayList<JADAttributeCompletionProposal>();
        String[] stringArray = headers = JADAttributeHeadersProvider.getSupportJADAttrHeaders();
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element.regionMatches(true, 0, currentValue, 0, currentValue.length()) && this.emptyString(this.existedPropertis.getProperty(element))) {
                JADAttributeCompletionProposal proposal = new JADAttributeCompletionProposal(String.valueOf(element) + ":", null, element, startOffset, currentValue.length());
                completions.add(proposal);
            }
            ++n2;
        }
        stringArray = PROPERTY_PREFIXES;
        n = PROPERTY_PREFIXES.length;
        n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (prefix.regionMatches(true, 0, currentValue, 0, currentValue.length())) {
                String prefixHeader = this.propertyPrefixesHeaders.get(prefix);
                JADAttributeCompletionProposal proposal = new JADAttributeCompletionProposal(String.valueOf(prefixHeader) + ":", null, prefixHeader, startOffset, currentValue.length());
                completions.add(proposal);
            }
            ++n2;
        }
        return this.sortProposals(completions.toArray(new ICompletionProposal[completions.size()]));
    }

    protected ICompletionProposal[] computeValue(String currentValue, int startOffset, int offset) throws BadLocationException {
        int beginIndex;
        Matcher midletMacher = MIDLET_PATTERN.matcher(currentValue);
        if (midletMacher.matches() && (beginIndex = midletMacher.group(1).length() + 1) < currentValue.length()) {
            return this.handleMIDletCompletion(currentValue.substring(beginIndex), offset);
        }
        if (currentValue.regionMatches(true, 0, "MicroEdition-Configuration", 0, Math.min(currentValue.length(), "MicroEdition-Configuration".length()))) {
            return this.handleConfigurationCompletion(currentValue.substring("MicroEdition-Configuration".length() + 1), offset);
        }
        if (currentValue.regionMatches(true, 0, "MicroEdition-Profile", 0, Math.min(currentValue.length(), "MicroEdition-Profile".length()))) {
            return this.handleProfileCompletion(currentValue.substring("MicroEdition-Profile".length() + 1), offset);
        }
        return this.NO_COMPLETIONS;
    }

    private boolean emptyString(Object o) {
        return o == null || "".equals(o);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.PROPOSAL_ACTIVATION_CHARS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    private IJavaProject getJavaProject() {
        return this.sourcePage.getJavaProject();
    }

    private ICompletionProposal[] handleConfigurationCompletion(String value, int offset) {
        ArrayList<JADAttributeCompletionProposal> completions = new ArrayList<JADAttributeCompletionProposal>();
        Configuration[] specifications = Configuration.values();
        value = value.trim();
        Configuration[] configurationArray = specifications;
        int n = specifications.length;
        int n2 = 0;
        while (n2 < n) {
            Configuration spec = configurationArray[n2];
            String configID = spec.toString();
            if (configID.regionMatches(true, 0, value, 0, value.length())) {
                JADAttributeCompletionProposal proposal = new JADAttributeCompletionProposal(configID, null, configID, offset - value.length(), value.length());
                completions.add(proposal);
            }
            ++n2;
        }
        return completions.toArray(new ICompletionProposal[completions.size()]);
    }

    private ICompletionProposal[] handleMIDletCompletion(String value, int offset) {
        String[] tokens = value.split(",", -1);
        ArrayList<JADAttributeCompletionProposal> completions = new ArrayList<JADAttributeCompletionProposal>();
        if (tokens != null && tokens.length == 3) {
            IJavaProject jp = this.getJavaProject();
            List midlets = Utils.getMidletTypesInProject((IProgressMonitor)new NullProgressMonitor(), (IJavaProject)jp);
            for (IType midlet : midlets) {
                String elementName = midlet.getElementName();
                String fullName = midlet.getFullyQualifiedName();
                if (!elementName.regionMatches(true, 0, tokens[2], 0, tokens[2].length())) continue;
                JADAttributeCompletionProposal proposal = new JADAttributeCompletionProposal(fullName, MTJUIPluginImages.DESC_MIDLET_ICON.createImage(), String.valueOf(elementName) + " - " + fullName, offset - tokens[2].length(), tokens[2].length());
                completions.add(proposal);
            }
            return completions.toArray(new ICompletionProposal[completions.size()]);
        }
        return this.NO_COMPLETIONS;
    }

    private ICompletionProposal[] handleProfileCompletion(String value, int offset) {
        ArrayList<JADAttributeCompletionProposal> completions = new ArrayList<JADAttributeCompletionProposal>();
        Profile[] specifications = Profile.values();
        value = value.trim();
        Profile[] profileArray = specifications;
        int n = specifications.length;
        int n2 = 0;
        while (n2 < n) {
            Profile spec = profileArray[n2];
            String profileID = spec.toString();
            if (profileID.regionMatches(true, 0, value, 0, value.length())) {
                JADAttributeCompletionProposal proposal = new JADAttributeCompletionProposal(profileID, null, profileID, offset - value.length(), value.length());
                completions.add(proposal);
            }
            ++n2;
        }
        return completions.toArray(new ICompletionProposal[completions.size()]);
    }

    private boolean isHeader(String currentLineValue) {
        return currentLineValue.indexOf(58) == -1;
    }

    private String findPropertyPrefix(String propertyKey) {
        String[] stringArray = PROPERTY_PREFIXES;
        int n = PROPERTY_PREFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (propertyKey.startsWith(prefix)) {
                return prefix;
            }
            ++n2;
        }
        return null;
    }

    private void parseDocument(IDocument doc) {
        this.existedPropertis = new ColonDelimitedProperties();
        try {
            this.existedPropertis.load((Reader)new StringReader(doc.get()));
        }
        catch (IOException iOException) {}
        Iterator iter = this.existedPropertis.keySet().iterator();
        HashMap<String, Integer> maxNumbers = new HashMap<String, Integer>();
        String[] stringArray = PROPERTY_PREFIXES;
        int n = PROPERTY_PREFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            maxNumbers.put(prefix, 0);
            ++n2;
        }
        while (iter.hasNext()) {
            int number;
            String key = (String)iter.next();
            String prefix = this.findPropertyPrefix(key);
            if (prefix == null) continue;
            try {
                number = Integer.parseInt(key.substring(prefix.length()));
            }
            catch (NumberFormatException numberFormatException) {
                number = -1;
            }
            if (number == -1 || number <= (Integer)maxNumbers.get(prefix)) continue;
            maxNumbers.put(prefix, number);
        }
        this.propertyPrefixesHeaders.clear();
        for (Map.Entry maxNumberEntry : maxNumbers.entrySet()) {
            String prefix = (String)maxNumberEntry.getKey();
            this.propertyPrefixesHeaders.put(prefix, String.valueOf(prefix) + ((Integer)maxNumberEntry.getValue() + 1));
        }
    }

    private ICompletionProposal[] sortProposals(ICompletionProposal[] proposals) {
        Arrays.sort(proposals, new Comparator<ICompletionProposal>(){

            @Override
            public int compare(ICompletionProposal o1, ICompletionProposal o2) {
                return o1.getDisplayString().compareTo(o2.getDisplayString());
            }
        });
        return proposals;
    }
}

