/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.jad.source.contentassist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class JADAttributeCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension2 {
    protected String replacementString;
    protected Image image;
    protected String displayString;
    protected int startOffset;
    protected int length;

    public JADAttributeCompletionProposal(String replacementString, Image image, String displayString) {
        this(replacementString, image, displayString, 0, 0);
    }

    public JADAttributeCompletionProposal(String replacementString, Image image, String displayString, int startOffset, int length) {
        Assert.isNotNull((Object)replacementString);
        this.replacementString = replacementString;
        this.image = image;
        this.displayString = displayString;
        this.startOffset = startOffset;
        this.length = length;
    }

    public void apply(IDocument document) {
        if (this.length == -1) {
            String current = document.get();
            this.length = current.length();
        }
        try {
            document.replace(this.startOffset, this.length, this.replacementString);
        }
        catch (BadLocationException badLocationException) {}
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.apply(viewer.getDocument());
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public Image getImage() {
        return this.image;
    }

    public Point getSelection(IDocument document) {
        if (this.replacementString.equals("\"\"")) {
            return new Point(this.startOffset + 1, 0);
        }
        return new Point(this.startOffset + this.replacementString.length(), 0);
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            if (offset >= this.startOffset) {
                String content = document.get(this.startOffset, offset - this.startOffset);
                return this.getDisplayString().toLowerCase().startsWith(content.toLowerCase());
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }
}

