/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.IEditingModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.ui.editor.AbstractFoldingStructureProvider;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class L10nFoldingStructureProvider
extends AbstractFoldingStructureProvider {
    private Map<Position, IDocumentElementNode> fPositionToElement = new HashMap<Position, IDocumentElementNode>();

    public L10nFoldingStructureProvider(MTJSourcePage editor, IEditingModel model) {
        super(editor, model);
    }

    @Override
    public void addFoldingRegions(Set<Position> currentRegions, IEditingModel model) throws BadLocationException {
        L10nLocales locales = ((L10nModel)model).getLocales();
        List childList = locales.getChildren();
        IDocumentElementNode[] children = childList.toArray(new IDocumentElementNode[childList.size()]);
        this.addFoldingRegions(currentRegions, children, model.getDocument());
    }

    private void addFoldingRegions(Set<Position> regions, IDocumentElementNode[] nodes, IDocument document) throws BadLocationException {
        IDocumentElementNode[] iDocumentElementNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentElementNode[] children;
            int endLine;
            IDocumentElementNode element = iDocumentElementNodeArray[n2];
            int startLine = document.getLineOfOffset(element.getOffset());
            if (startLine < (endLine = document.getLineOfOffset(element.getOffset() + element.getLength()))) {
                int start = document.getLineOffset(startLine);
                int end = document.getLineOffset(endLine) + document.getLineLength(endLine);
                Position position = new Position(start, end - start);
                regions.add(position);
                this.fPositionToElement.put(position, element);
            }
            if ((children = element.getChildNodes()) != null) {
                this.addFoldingRegions(regions, children, document);
            }
            ++n2;
        }
    }
}

