/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.editors.l10n.pages;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mtj.internal.core.l10n.L10nApi;
import org.eclipse.mtj.internal.core.text.IDocumentAttributeNode;
import org.eclipse.mtj.internal.core.text.IDocumentElementNode;
import org.eclipse.mtj.internal.core.text.IDocumentRange;
import org.eclipse.mtj.internal.core.text.IEditingModel;
import org.eclipse.mtj.internal.core.text.l10n.L10nLocales;
import org.eclipse.mtj.internal.core.text.l10n.L10nModel;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.mtj.internal.ui.editor.MTJFormEditor;
import org.eclipse.mtj.internal.ui.editor.MTJSourcePage;
import org.eclipse.mtj.internal.ui.editor.XMLSourcePage;
import org.eclipse.mtj.internal.ui.editors.l10n.L10nInputContext;
import org.eclipse.mtj.internal.ui.editors.l10n.L10nSourceOutlinePage;
import org.eclipse.mtj.internal.ui.editors.l10n.pages.L10nContentProvider;

public class L10nSourcePage
extends XMLSourcePage {
    public L10nSourcePage(MTJFormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected ISortableContentOutlinePage createOutlinePage() {
        L10nSourceOutlinePage sourceOutlinePage = new L10nSourceOutlinePage((MTJFormEditor)this.getEditor(), (IEditingModel)this.getInputContext().getModel(), (IBaseLabelProvider)this.createOutlineLabelProvider(), (IContentProvider)this.createOutlineContentProvider(), this.createDefaultOutlineComparator(), this.createOutlineComparator());
        this.fOutlinePage = sourceOutlinePage;
        this.fOutlineSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                L10nSourcePage.this.updateSelection(event);
            }
        };
        this.fOutlinePage.addSelectionChangedListener(this.fOutlineSelectionChangedListener);
        this.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)sourceOutlinePage);
        this.fEditorSelectionChangedListener = new MTJSourcePage.MTJSourcePageChangedListener(this);
        this.fEditorSelectionChangedListener.install(this.getSelectionProvider());
        return this.fOutlinePage;
    }

    public ViewerComparator createOutlineComparator() {
        return null;
    }

    public ITreeContentProvider createOutlineContentProvider() {
        return new L10nContentProvider();
    }

    public ILabelProvider createOutlineLabelProvider() {
        return MTJUIPlugin.getDefault().getLabelProvider();
    }

    public IDocumentRange getRangeElement(int offset, boolean searchChildren) {
        L10nLocales locales = ((L10nModel)this.getInputContext().getModel()).getLocales();
        return this.findNode((IDocumentElementNode)locales, offset, searchChildren);
    }

    public boolean isQuickOutlineEnabled() {
        return true;
    }

    public void updateSelection(Object object) {
        if (object instanceof IDocumentElementNode && !((IDocumentElementNode)object).isErrorNode()) {
            this.setSelectedObject(object);
            this.setHighlightRange((IDocumentRange)((IDocumentElementNode)object), true);
            this.setSelectedRange((IDocumentRange)((IDocumentElementNode)object), false);
        }
    }

    protected IDocumentRange findRange() {
        Object selectedObject = this.getSelection();
        if (selectedObject instanceof IDocumentElementNode) {
            return (IDocumentElementNode)selectedObject;
        }
        return null;
    }

    protected void initializeEditor() {
        super.initializeEditor();
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected void setPartName(String partName) {
        super.setPartName(MTJUIMessages.L10nSourcePage_source_partName);
    }

    protected void synchronizeOutlinePage(int offset) {
        IDocumentRange rangeElement = this.getRangeElement(offset, true);
        this.updateHighlightRange(rangeElement);
        if (rangeElement instanceof IDocumentAttributeNode) {
            rangeElement = ((IDocumentAttributeNode)rangeElement).getEnclosingElement();
        }
        this.updateOutlinePageSelection(rangeElement);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        try {
            L10nModel model = (L10nModel)this.getInputContext().getModel();
            model.validate();
            L10nApi.syncronizeApi((L10nModel)model);
        }
        catch (CoreException e) {
            MTJLogger.log((int)4, (Throwable)e);
        }
    }

    public void refreshMarkStatus() {
        L10nInputContext context;
        if (this.getInputContext() != null && this.getInputContext() instanceof L10nInputContext && (context = (L10nInputContext)this.getInputContext()) != null) {
            L10nModel model = (L10nModel)context.getModel();
            model.validate();
            context.validateModel(model);
        }
    }
}

