/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.forms.blocks;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ButtonBarBlock {
    public static final int BUTTON_ADD = 2;
    public static final int BUTTON_ADD_INDEX = 0;
    public static final int BUTTON_EDIT = 4;
    public static final int BUTTON_EDIT_INDEX = 1;
    public static final int BUTTON_DOWN = 32;
    public static final int BUTTON_DOWN_INDEX = 4;
    public static final int BUTTON_REMOVE = 8;
    public static final int BUTTON_REMOVE_INDEX = 2;
    public static final int BUTTON_UP = 16;
    public static final int BUTTON_UP_INDEX = 3;
    public static final int BUTTON_SCAN = 64;
    public static final int BUTTON_SCAN_INDEX = 5;
    public static final int BUTTON_ALL = 126;
    private Map<Integer, Button> buttons;

    public ButtonBarBlock(Composite parent, FormToolkit toolkit, int buttons) {
        this.initialize(parent, toolkit, buttons);
    }

    public ButtonBarBlock(Composite parent, int buttons) {
        this.initialize(parent, buttons);
    }

    public void addButtonListener(int button, int eventType, Listener listener) {
        this.buttons.get(button).addListener(eventType, listener);
    }

    public Button getButton(int index) {
        return this.buttons.get(index);
    }

    public boolean isButtonEnabled(int index) {
        return this.buttons.get(index).isEnabled();
    }

    public void setButtonMouseListener(int index, MouseListener listener) {
        this.buttons.get(index).addMouseListener(listener);
    }

    public void setEnabled(int index, boolean enabled) {
        this.buttons.get(index).setEnabled(enabled);
    }

    public void setButtonVisible(int index, boolean visible) {
        Button button = this.getButton(index);
        Object layoutData = button.getLayoutData();
        Composite buttonsPanel = button.getParent();
        Layout parentLayout = buttonsPanel.getLayout();
        if (parentLayout instanceof GridLayout && layoutData instanceof GridData) {
            button.setVisible(visible);
            ((GridData)layoutData).exclude = !visible;
            Composite buttonsPanelOwner = buttonsPanel.getParent();
            if (buttonsPanelOwner == null) {
                buttonsPanel.layout();
            } else {
                buttonsPanelOwner.layout();
            }
        }
    }

    private void createButton(Composite parent, FormToolkit toolkit, int buttonIndex, String buttonTitle) {
        Button button;
        if (toolkit == null) {
            button = new Button(parent, 8);
            button.setText(buttonTitle);
        } else {
            button = toolkit.createButton(parent, buttonTitle, 8);
        }
        button.setEnabled(false);
        if (parent.getLayout() instanceof GridLayout) {
            GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)button);
        }
        this.buttons.put(buttonIndex, button);
    }

    private void initialize(Composite parent, FormToolkit toolkit, int _buttons) {
        this.buttons = new HashMap<Integer, Button>();
        int[] buttonMasks = new int[]{2, 4, 8, 16, 32, 64};
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        int[] buttonIndices = nArray;
        String[] buttonTitles = new String[]{MTJUIMessages.buttonBarBlock_button_add, MTJUIMessages.buttonBarBlock_button_edit, MTJUIMessages.buttonBarBlock_button_remove, MTJUIMessages.buttonBarBlock_button_up, MTJUIMessages.buttonBarBlock_button_down, MTJUIMessages.ButtonBarBlock_Scan};
        int i = 0;
        while (i < buttonMasks.length) {
            if ((_buttons & buttonMasks[i]) != 0) {
                this.createButton(parent, toolkit, buttonIndices[i], buttonTitles[i]);
            }
            ++i;
        }
    }

    private void initialize(Composite parent, int _buttons) {
        this.initialize(parent, null, _buttons);
    }

    public void setEnabled(boolean state) {
        for (Button button : this.buttons.values()) {
            button.setEnabled(state);
        }
    }
}

