/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.forms.blocks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.internal.ui.forms.blocks.ButtonBarBlock;
import org.eclipse.mtj.internal.ui.forms.blocks.GenericListBlockItem;
import org.eclipse.mtj.internal.ui.forms.blocks.GenericListBlockListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericListBlock<T extends GenericListBlockItem> {
    private List<GenericListBlockListener<T>> listeners;
    private ButtonBarBlock buttonBar;
    private int buttons;
    private TableViewer viewer;
    private List<T> input;

    public GenericListBlock(Composite _parent, int _tableStyle, int _buttons, List<T> _input) {
        if (_input == null) {
            throw new IllegalArgumentException("Input can not be null.");
        }
        this.listeners = new ArrayList<GenericListBlockListener<T>>();
        this.input = _input;
        this.createControl(_parent, _tableStyle, _buttons);
    }

    public void addGenericListBlockListener(GenericListBlockListener<T> _listener) {
        this.listeners.add(_listener);
    }

    public void removeGenericListBlockListener(GenericListBlockListener<T> _listener) {
        this.listeners.remove(_listener);
    }

    private void createControl(Composite parent, int _style, int _buttons) {
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setBackground(new Color((Device)Display.getDefault(), 255, 255, 255));
        GridLayout layout = new GridLayout(2, false);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Table table = new Table(mainComposite, _style);
        GridData data = new GridData(4, 4, true, true);
        table.setLayoutData((Object)data);
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new AdvancedListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AdvancedListLabelProvider());
        this.viewer.setInput(this.input);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GenericListBlock.this.updateButtonsStates();
            }
        });
        this.createButtons(mainComposite, _buttons);
    }

    public void setButtonVisible(int index, boolean visible) {
        this.buttonBar.setButtonVisible(index, visible);
    }

    private void createButtons(Composite mainComposite, int _buttons) {
        Composite buttonsComposite = new Composite(mainComposite, 0);
        buttonsComposite.setBackground(new Color((Device)Display.getDefault(), 255, 255, 255));
        GridData data = new GridData(4, 0x1000000, false, false);
        buttonsComposite.setLayoutData((Object)data);
        GridLayoutFactory.fillDefaults().equalWidth(true).numColumns(1).margins(0, 0).spacing(0, 3).applyTo(buttonsComposite);
        this.buttons = _buttons | 0x10 | 0x20;
        this.buttonBar = new ButtonBarBlock(buttonsComposite, this.buttons);
        if ((_buttons & 2) != 0) {
            this.buttonBar.setEnabled(0, true);
            this.buttonBar.getButton(0).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    for (GenericListBlockListener listener : GenericListBlock.this.listeners) {
                        listener.addButtonPressed();
                    }
                }
            });
        }
        if ((_buttons & 4) != 0) {
            this.buttonBar.getButton(1).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = GenericListBlock.this.viewer.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    if (structuredSelection.size() != 1) {
                        return;
                    }
                    GenericListBlockItem itemToEdit = (GenericListBlockItem)structuredSelection.getFirstElement();
                    for (GenericListBlockListener listener : GenericListBlock.this.listeners) {
                        listener.editButtonPressed(itemToEdit);
                    }
                }
            });
        }
        if ((_buttons & 0x40) != 0) {
            this.buttonBar.setEnabled(5, true);
            this.buttonBar.getButton(5).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    for (GenericListBlockListener listener : GenericListBlock.this.listeners) {
                        listener.scan();
                    }
                }
            });
        }
        if ((_buttons & 8) != 0) {
            this.buttonBar.getButton(2).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = GenericListBlock.this.viewer.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    List items = structuredSelection.toList();
                    if (items.size() == 0) {
                        return;
                    }
                    int indexToSelect = -1;
                    for (GenericListBlockItem item : items) {
                        indexToSelect = Math.max(indexToSelect, GenericListBlock.this.input.indexOf(item));
                    }
                    indexToSelect = Math.min(indexToSelect + 1, GenericListBlock.this.input.size() - 1) - items.size();
                    GenericListBlock.this.input.removeAll(items);
                    GenericListBlock.this.update((IStructuredSelection)(indexToSelect < 0 ? null : new StructuredSelection(GenericListBlock.this.input.get(indexToSelect))));
                    for (GenericListBlockListener listener : GenericListBlock.this.listeners) {
                        listener.itemsRemoved(items);
                    }
                }
            });
        }
        this.buttonBar.getButton(3).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = GenericListBlock.this.viewer.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                if (structuredSelection.size() != 1) {
                    return;
                }
                GenericListBlockItem item = (GenericListBlockItem)((IStructuredSelection)selection).getFirstElement();
                int index = GenericListBlock.this.input.indexOf(item);
                if (index > 0) {
                    GenericListBlock.this.input.remove(index);
                    GenericListBlock.this.input.add(--index, item);
                    GenericListBlock.this.viewer.refresh();
                }
                GenericListBlock.this.updateButtonsStates();
                for (GenericListBlockListener listener : GenericListBlock.this.listeners) {
                    listener.upButtonPressed();
                }
            }
        });
        this.buttonBar.getButton(4).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = GenericListBlock.this.viewer.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                if (structuredSelection.size() != 1) {
                    return;
                }
                GenericListBlockItem item = (GenericListBlockItem)((IStructuredSelection)selection).getFirstElement();
                int index = GenericListBlock.this.input.indexOf(item);
                if (index < GenericListBlock.this.input.size() - 1) {
                    GenericListBlock.this.input.remove(index);
                    GenericListBlock.this.input.add(++index, item);
                    GenericListBlock.this.viewer.refresh();
                }
                GenericListBlock.this.updateButtonsStates();
                for (GenericListBlockListener listener : GenericListBlock.this.listeners) {
                    listener.downButtonPressed();
                }
            }
        });
        this.updateButtonsStates();
    }

    private void updateButtonsStates() {
        if (this.viewer.getControl().isEnabled()) {
            boolean enabled;
            int selectionCount = 0;
            ISelection selection = this.viewer.getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                selectionCount = ((IStructuredSelection)selection).size();
            }
            if ((this.buttons & 8) != 0) {
                this.buttonBar.setEnabled(2, selectionCount > 0);
            }
            if ((this.buttons & 4) != 0) {
                this.buttonBar.setEnabled(1, selectionCount == 1);
            }
            if ((this.buttons & 0x10) != 0) {
                boolean bl = enabled = selectionCount == 1;
                if (enabled) {
                    enabled = this.input.indexOf(((IStructuredSelection)selection).getFirstElement()) > 0;
                }
                this.buttonBar.setEnabled(3, enabled);
            }
            if ((this.buttons & 0x20) != 0) {
                boolean bl = enabled = selectionCount == 1;
                if (enabled) {
                    enabled = this.input.indexOf(((IStructuredSelection)selection).getFirstElement()) < this.input.size() - 1;
                }
                this.buttonBar.setEnabled(4, enabled);
            }
        }
    }

    public void update(IStructuredSelection newSelection) {
        this.viewer.refresh();
        if (newSelection != null) {
            this.viewer.setSelection((ISelection)newSelection, true);
        }
        this.updateButtonsStates();
    }

    public void setEnabled(boolean state) {
        this.viewer.getControl().setEnabled(state);
        this.buttonBar.setEnabled(state);
        this.updateButtonsStates();
    }

    public void setInput(List<T> input) {
        if (input == null) {
            throw new IllegalArgumentException("Input can not be null.");
        }
        this.input = input;
        this.viewer.setInput(input);
        this.viewer.refresh();
        this.viewer.setSelection(null);
        this.updateButtonsStates();
    }

    private class AdvancedListContentProvider
    implements IStructuredContentProvider {
        private AdvancedListContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            viewer.refresh();
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                List items = (List)inputElement;
                return items.toArray(new GenericListBlockItem[items.size()]);
            }
            return null;
        }

        public void dispose() {
        }
    }

    private class AdvancedListLabelProvider
    extends LabelProvider {
        private AdvancedListLabelProvider() {
        }

        public Image getImage(Object element) {
            Image image = null;
            if (element instanceof GenericListBlockItem) {
                image = ((GenericListBlockItem)element).getImage();
            }
            return image;
        }

        public String getText(Object element) {
            String text = null;
            if (element instanceof GenericListBlockItem) {
                text = ((GenericListBlockItem)element).getText();
            }
            return text;
        }
    }
}

