/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.forms.blocks;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.internal.core.sign.IKeyStoreManager;
import org.eclipse.mtj.internal.core.sign.KeyStoreEntry;
import org.eclipse.mtj.internal.core.sign.KeyStoreManagerException;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.mtj.internal.ui.dialog.KeystoreEntryDialog;
import org.eclipse.mtj.internal.ui.dialog.NewKeyPairDialog;
import org.eclipse.mtj.internal.ui.dialog.SigningPasswordDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class SigningBlock {
    private TableViewer viewer;
    private Table table;
    private Button aliasGroupBtn1;
    private Button aliasGroupBtn2;
    private Button aliasGroupBtn3;
    private Button aliasGroupBtn4;
    private Button aliasGroupBtn5;
    private Text keyDataText;
    private Text providerText;
    private Text ksTypeText;

    public void createBlock(Composite parent) {
        this.createKeyAliasSection(parent);
        this.createAdvancedSection(parent);
    }

    public void setInput(IKeyStoreManager _keyStoreManager) {
        this.viewer.setInput((Object)_keyStoreManager);
        this.updateButtonsAvailability();
        this.keyDataText.setText("");
    }

    public void setEnabled(boolean enabled) {
        this.providerText.setEnabled(enabled);
        this.keyDataText.setEnabled(enabled);
        this.ksTypeText.setEnabled(enabled);
        this.table.setEnabled(enabled);
        this.updateButtonsAvailability();
    }

    public void clearFields() {
        this.providerText.setText("");
        this.keyDataText.setText("");
        this.ksTypeText.setText("");
    }

    private void updateButtonsAvailability() {
        if (this.viewer.getInput() != null) {
            this.aliasGroupBtn1.setEnabled(true);
            this.aliasGroupBtn4.setEnabled(true);
            if (this.viewer.getSelection().isEmpty()) {
                this.aliasGroupBtn2.setEnabled(false);
                this.aliasGroupBtn3.setEnabled(false);
                this.aliasGroupBtn5.setEnabled(false);
            } else {
                this.aliasGroupBtn2.setEnabled(true);
                this.aliasGroupBtn3.setEnabled(true);
                this.aliasGroupBtn5.setEnabled(true);
            }
        } else {
            this.aliasGroupBtn1.setEnabled(false);
            this.aliasGroupBtn2.setEnabled(false);
            this.aliasGroupBtn3.setEnabled(false);
            this.aliasGroupBtn4.setEnabled(false);
            this.aliasGroupBtn5.setEnabled(false);
        }
    }

    private void createKeyAliasSection(final Composite parent) {
        Group aliasGroup = new Group(parent, 0);
        aliasGroup.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 0;
        aliasGroup.setLayout((Layout)layout);
        aliasGroup.setText(MTJUIMessages.SigningBlock_keyAliases);
        this.table = new Table((Composite)aliasGroup, 2052);
        GridData gridData = MTJUIPlugin.buildGridData(4, 4, true, true);
        gridData.verticalSpan = 5;
        this.table.setLayoutData((Object)gridData);
        this.viewer = new TableViewer(this.table);
        this.viewer.setContentProvider((IContentProvider)new SigningBlockContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SigningBlockLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                SigningBlock.this.updateButtonsAvailability();
                if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
                    return;
                }
                Object selectedObj = ((IStructuredSelection)selection).getFirstElement();
                if (!(selectedObj instanceof KeyStoreEntry)) {
                    return;
                }
                KeyStoreEntry entry = (KeyStoreEntry)selectedObj;
                SigningBlock.this.displayKeyData(entry);
            }
        });
        this.aliasGroupBtn1 = new Button((Composite)aliasGroup, 0);
        this.aliasGroupBtn1.setText(MTJUIMessages.SigningBlock_createNewKeypair);
        this.aliasGroupBtn1.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, false, false));
        this.aliasGroupBtn1.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                NewKeyPairDialog dialog = new NewKeyPairDialog(parent.getShell());
                dialog.setTitle(MTJUIMessages.SigningBlock_generateKeyPair);
                if (dialog.open() != 0) {
                    return;
                }
                Object input = SigningBlock.this.viewer.getInput();
                if (!(input instanceof IKeyStoreManager)) {
                    return;
                }
                IKeyStoreManager keyStoreManager = (IKeyStoreManager)input;
                try {
                    keyStoreManager.generateKeyPair(dialog.getKeyPairInfo());
                    SigningBlock.this.viewer.refresh();
                }
                catch (KeyStoreManagerException exc) {
                    MessageDialog.openError((Shell)parent.getShell(), (String)MTJUIMessages.SigningBlock_keystoreManagerError, (String)exc.getMessage());
                    MTJLogger.log((int)4, (String)exc.getMessage());
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        this.aliasGroupBtn2 = new Button((Composite)aliasGroup, 0);
        this.aliasGroupBtn2.setText(MTJUIMessages.SigningBlock_deleteKeyPair);
        this.aliasGroupBtn2.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, false, false));
        this.aliasGroupBtn2.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                Object input = SigningBlock.this.viewer.getInput();
                if (!(input instanceof IKeyStoreManager)) {
                    return;
                }
                ISelection selection = SigningBlock.this.viewer.getSelection();
                if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                    return;
                }
                IKeyStoreManager keyStoreManager = (IKeyStoreManager)input;
                try {
                    keyStoreManager.deleteEntry((KeyStoreEntry)((IStructuredSelection)selection).getFirstElement());
                    SigningBlock.this.keyDataText.setText("");
                    SigningBlock.this.viewer.refresh();
                }
                catch (KeyStoreManagerException exc) {
                    MessageDialog.openError((Shell)parent.getShell(), (String)MTJUIMessages.SigningBlock_keystoreManagerError, (String)exc.getMessage());
                    MTJLogger.log((int)4, (String)exc.getMessage());
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        this.aliasGroupBtn3 = new Button((Composite)aliasGroup, 0);
        this.aliasGroupBtn3.setText(MTJUIMessages.SigningBlock_generateCSR);
        this.aliasGroupBtn3.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, false, false));
        this.aliasGroupBtn3.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                Object input = SigningBlock.this.viewer.getInput();
                if (!(input instanceof IKeyStoreManager)) {
                    return;
                }
                ISelection selection = SigningBlock.this.viewer.getSelection();
                if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                    return;
                }
                DirectoryDialog folderDialog = new DirectoryDialog(parent.getShell(), 8192);
                folderDialog.setMessage(MTJUIMessages.SigningBlock_selectCSRFolder);
                String path = folderDialog.open();
                if (path == null) {
                    return;
                }
                IKeyStoreManager keyStoreManager = (IKeyStoreManager)input;
                try {
                    String alias = (String)((IStructuredSelection)selection).getFirstElement();
                    SigningPasswordDialog dialog = new SigningPasswordDialog(parent.getShell(), false);
                    dialog.setTitle(MTJUIMessages.SigningBlock_enterKeyPassword);
                    dialog.setDescription(NLS.bind((String)MTJUIMessages.SigningBlock_enterKeyPasswordForAlias, (Object)alias));
                    if (dialog.open() != 0) {
                        return;
                    }
                    path = NLS.bind((String)"{0}{1}{2}.csr", (Object[])new String[]{path, File.separator, alias});
                    keyStoreManager.generateCSR(alias, dialog.getPassword(), path);
                }
                catch (KeyStoreManagerException exc) {
                    MessageDialog.openError((Shell)parent.getShell(), (String)MTJUIMessages.SigningBlock_keystoreManagerError, (String)exc.getMessage());
                    MTJLogger.log((int)4, (String)exc.getMessage());
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        this.aliasGroupBtn4 = new Button((Composite)aliasGroup, 0);
        this.aliasGroupBtn4.setText(MTJUIMessages.SigningBlock_importCertificate);
        this.aliasGroupBtn4.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, false, false));
        this.aliasGroupBtn4.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                Object input = SigningBlock.this.viewer.getInput();
                if (!(input instanceof IKeyStoreManager)) {
                    return;
                }
                FileDialog fileDialog = new FileDialog(parent.getShell(), 4096);
                fileDialog.setFilterExtensions(new String[]{"*.*"});
                fileDialog.setText(MTJUIMessages.SigningBlock_importCertificate);
                String path = fileDialog.open();
                if (path == null) {
                    return;
                }
                IKeyStoreManager keyStoreManager = (IKeyStoreManager)input;
                try {
                    KeystoreEntryDialog dialog = new KeystoreEntryDialog(parent.getShell());
                    dialog.setTitle(MTJUIMessages.SigningBlock_selectCertificateFile);
                    if (dialog.open() != 0) {
                        return;
                    }
                    keyStoreManager.importCertificate(dialog.getAlias(), dialog.getPassword(), path);
                    SigningBlock.this.viewer.refresh();
                }
                catch (KeyStoreManagerException exc) {
                    MessageDialog.openError((Shell)parent.getShell(), (String)MTJUIMessages.SigningBlock_keystoreManagerError, (String)exc.getMessage());
                    MTJLogger.log((int)4, (String)exc.getMessage());
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        this.aliasGroupBtn5 = new Button((Composite)aliasGroup, 0);
        this.aliasGroupBtn5.setText(MTJUIMessages.SigningBlock_importCSRResponse);
        this.aliasGroupBtn5.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, false, false));
        this.aliasGroupBtn5.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                Object input = SigningBlock.this.viewer.getInput();
                if (!(input instanceof IKeyStoreManager)) {
                    return;
                }
                String alias = null;
                ISelection selection = SigningBlock.this.viewer.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                    alias = (String)((IStructuredSelection)selection).getFirstElement();
                }
                FileDialog fileDialog = new FileDialog(parent.getShell(), 4096);
                fileDialog.setFilterExtensions(new String[]{"*.*"});
                fileDialog.setText(MTJUIMessages.SigningBlock_importCertificateReply);
                String path = fileDialog.open();
                if (path == null) {
                    return;
                }
                IKeyStoreManager keyStoreManager = (IKeyStoreManager)input;
                try {
                    KeystoreEntryDialog dialog = new KeystoreEntryDialog(parent.getShell(), alias);
                    dialog.setTitle(MTJUIMessages.SigningBlock_selectCertificateFile);
                    if (dialog.open() != 0) {
                        return;
                    }
                    alias = dialog.getAlias();
                    keyStoreManager.importCertificate(alias, dialog.getPassword(), path);
                }
                catch (KeyStoreManagerException exc) {
                    MessageDialog.openError((Shell)parent.getShell(), (String)MTJUIMessages.SigningBlock_keystoreManagerError, (String)exc.getMessage());
                    MTJLogger.log((int)4, (String)exc.getMessage());
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        Label keyDataLabel = new Label((Composite)aliasGroup, 0);
        keyDataLabel.setText(MTJUIMessages.SigningBlock_keyData);
        gridData = MTJUIPlugin.buildGridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        keyDataLabel.setLayoutData((Object)gridData);
        this.keyDataText = new Text((Composite)aliasGroup, 2122);
        gridData = MTJUIPlugin.buildGridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 50;
        this.keyDataText.setLayoutData((Object)gridData);
        this.updateButtonsAvailability();
    }

    protected void displayKeyData(KeyStoreEntry keyStoreEntry) {
        Object input = this.viewer.getInput();
        if (input == null || !(input instanceof IKeyStoreManager)) {
            return;
        }
        IKeyStoreManager keyStoreManager = (IKeyStoreManager)input;
        String data = null;
        try {
            data = keyStoreManager.getCertificateInformation(keyStoreEntry);
            if (data == null) {
                data = MTJUIMessages.SigningBlock_infoNotAvailable;
            }
        }
        catch (KeyStoreManagerException e) {
            data = MTJUIMessages.SigningBlock_unableToReadCertInfo;
            MTJLogger.log((int)4, (Throwable)e);
        }
        this.keyDataText.setText(data);
    }

    private void createAdvancedSection(Composite parent) {
        Group advancedGroup = new Group(parent, 0);
        advancedGroup.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 4, true, false));
        advancedGroup.setLayout((Layout)new GridLayout(1, false));
        advancedGroup.setText(MTJUIMessages.SigningBlock_advancedSettings);
        Label descriptionLabel = new Label((Composite)advancedGroup, 0);
        descriptionLabel.setText(MTJUIMessages.SigningBlock_useJavaSystemDefaults);
        descriptionLabel.setLayoutData((Object)MTJUIPlugin.buildGridData(true, false));
        Label providerLabel = new Label((Composite)advancedGroup, 0);
        providerLabel.setText(MTJUIMessages.SigningBlock_cryptoProvider);
        providerLabel.setLayoutData((Object)MTJUIPlugin.buildGridData(true, false));
        this.providerText = new Text((Composite)advancedGroup, 2048);
        this.providerText.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, true, false));
        Label ksTypeLabel = new Label((Composite)advancedGroup, 0);
        ksTypeLabel.setText(MTJUIMessages.SigningBlock_ksType);
        ksTypeLabel.setLayoutData((Object)MTJUIPlugin.buildGridData(true, false));
        this.ksTypeText = new Text((Composite)advancedGroup, 2048);
        this.ksTypeText.setLayoutData((Object)MTJUIPlugin.buildGridData(4, 0x1000000, true, false));
    }

    public String getCurrentAlias() {
        Object selectedObj;
        String alias = null;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (selectedObj = ((IStructuredSelection)selection).getFirstElement()) instanceof String) {
            alias = (String)selectedObj;
        }
        return alias;
    }

    public void setCurrentAlias(String keyAlias) {
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)keyAlias));
    }

    public String getProvider() {
        String result = this.providerText.getText();
        if (result.length() == 0) {
            result = null;
        }
        return result;
    }

    public void setProvider(String provider) {
        if (provider != null) {
            this.providerText.setText(provider);
        } else {
            this.providerText.setText("");
        }
    }

    public String getKeystoreType() {
        String result = this.ksTypeText.getText();
        if (result.length() == 0) {
            result = null;
        }
        return result;
    }

    public void setKeystoreType(String type) {
        if (type != null) {
            this.ksTypeText.setText(type);
        } else {
            this.ksTypeText.setText("");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PasswordType {
        Prompt,
        Project,
        Workspace;

    }

    private class SigningBlockContentProvider
    implements IStructuredContentProvider {
        private Viewer viewer;

        private SigningBlockContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList elements = new ArrayList();
            if (inputElement instanceof IKeyStoreManager) {
                try {
                    elements.addAll(((IKeyStoreManager)inputElement).getEntries());
                }
                catch (KeyStoreManagerException e) {
                    String message = NLS.bind((String)MTJUIMessages.SigningBlock_unableToGetKsAliases, (Object)e.getMessage());
                    MessageDialog.openError((Shell)this.viewer.getControl().getShell(), (String)MTJUIMessages.SigningBlock_keystoreManagerError, (String)message);
                    MTJLogger.log((int)4, (Throwable)e);
                }
            }
            return elements.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = viewer;
        }
    }

    private class SigningBlockLabelProvider
    extends LabelProvider {
        private SigningBlockLabelProvider() {
        }

        public String getText(Object element) {
            String text = null;
            if (element instanceof KeyStoreEntry) {
                KeyStoreEntry entry = (KeyStoreEntry)element;
                text = entry.getAlias();
            }
            return text;
        }
    }
}

