/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.launching;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.launching.DebugTypeSelectionDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaLaunchShortcut
implements ILaunchShortcut {
    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IJavaElement je = (IJavaElement)input.getAdapter(IJavaElement.class);
        if (je != null) {
            this.searchAndLaunch(new Object[]{je}, mode, this.getTypeSelectionTitle(), this.getEditorEmptyMessage());
        }
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode, this.getTypeSelectionTitle(), this.getSelectionEmptyMessage());
        }
    }

    public void searchAndLaunch(Object[] search, String mode, String selectMessage, String emptyMessage) {
        IType[] types = null;
        try {
            types = this.findTypes(search, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)MTJUIMessages.JavaLaunchShortcut_0, (String)e.getMessage());
            return;
        }
        IType type = null;
        if (types.length == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)MTJUIMessages.JavaLaunchShortcut_1, (String)emptyMessage);
        } else {
            type = types.length > 1 ? this.chooseType(types, selectMessage) : types[0];
        }
        if (type != null) {
            this.launch(type, mode);
        }
    }

    private Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(this.getTypeSelectionTitle());
        dialog.setMessage(MTJUIMessages.JavaLaunchShortcut_2);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected IType chooseType(IType[] types, String title) {
        DebugTypeSelectionDialog mmsd = new DebugTypeSelectionDialog(this.getShell(), types, title);
        if (mmsd.open() == 0) {
            return (IType)mmsd.getResult()[0];
        }
        return null;
    }

    protected abstract ILaunchConfiguration createConfiguration(IType var1);

    protected ILaunchConfiguration findLaunchConfiguration(IType type, ILaunchConfigurationType configType) {
        List<ILaunchConfiguration> candidateConfigs = this.getCandidateConfigs(type, configType);
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return this.createConfiguration(type);
        }
        if (candidateCount == 1) {
            return candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected abstract IType[] findTypes(Object[] var1, IRunnableContext var2) throws InterruptedException, CoreException;

    protected abstract List<ILaunchConfiguration> getCandidateConfigs(IType var1, ILaunchConfigurationType var2);

    protected abstract ILaunchConfigurationType getConfigurationType();

    protected abstract String getEditorEmptyMessage();

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected abstract String getSelectionEmptyMessage();

    protected abstract String getTypeSelectionTitle();

    protected void launch(IType type, String mode) {
        ILaunchConfiguration config = this.findLaunchConfiguration(type, this.getConfigurationType());
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected void reportErorr(CoreException exception) {
        MessageDialog.openError((Shell)this.getShell(), (String)MTJUIMessages.JavaLaunchShortcut_3, (String)exception.getStatus().getMessage());
    }
}

