/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.preferences;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.sdk.device.IAPI;
import org.eclipse.mtj.internal.core.sdk.device.midp.Configuration;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.IEmbeddableWorkbenchPreferencePage;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.MTJUIPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class PreverificationPreferencePage
extends FieldEditorPreferencePage
implements IEmbeddableWorkbenchPreferencePage {
    private static final String PREVERIFIER_TYPE_EMULATOR = "preverify_emulator";
    private static final String PREVERIFIER_TYPE_PROGUARD = "preverify_proguard";
    private static final String PREVERIFIER_TYPE_DEFAULT = "default_preverifier";
    private static final String[] BUTTON_TEXTS = new String[]{MTJUIMessages.PreverificationPreferencePage_use_jad_settings_label_text, MTJUIMessages.PreverificationPreferencePage_use_project_settings_label_text, MTJUIMessages.PreverificationPreferencePage_use_specific_config_label_text};
    private static final String[] CONFIG_FILE_LOCATIONS = new String[]{"jad", "platform", "specified"};
    private Combo configCombo;
    private IAPI[] configSpecs;
    private FileFieldEditor defaultPreverifierField;
    private boolean embeddedInProperties;
    private Group defaultPreverifierGroup;
    private IJavaProject javaProject;
    private Button[] preverificationRadios;
    private RadioGroupFieldEditor radioGroupFieldEditor;
    private String currentRadioSelected;

    public PreverificationPreferencePage() {
        this(false, MTJUIPlugin.getDefault().getCorePreferenceStore());
    }

    public PreverificationPreferencePage(boolean embeddedInProperties, IPreferenceStore preferenceStore) {
        this.embeddedInProperties = embeddedInProperties;
        this.setPreferenceStore(preferenceStore);
        this.configSpecs = Configuration.values();
    }

    public void doBuild(final IProject[] toBuild) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                IProject[] iProjectArray = toBuild;
                int n = toBuild.length;
                int n2 = 0;
                while (n2 < n) {
                    block6: {
                        IProject element = iProjectArray[n2];
                        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, -1);
                        try {
                            try {
                                element.build(6, (IProgressMonitor)subMonitor);
                            }
                            catch (CoreException e) {
                                MTJLogger.log((int)2, (String)MTJUIMessages.PreverificationPreferencePage_error_build_suite, (Throwable)e);
                                subMonitor.done();
                                break block6;
                            }
                        }
                        catch (Throwable throwable) {
                            subMonitor.done();
                            throw throwable;
                        }
                        subMonitor.done();
                    }
                    ++n2;
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (Throwable t) {
            MTJLogger.log((int)2, (String)MTJUIMessages.PreverificationPreferencePage_error_build_suite, (Throwable)t);
        }
    }

    public IProject getProject() {
        return this.javaProject.getProject();
    }

    public void init(IWorkbench workbench) {
    }

    public void performApply() {
        super.performApply();
    }

    public void performDefaults() {
        this.setControlsFromDefaults();
        super.performDefaults();
    }

    public boolean performOk() {
        this.setPreferencesFromControls();
        if (!this.embeddedInProperties) {
            this.buildSuites();
        }
        return super.performOk();
    }

    private void addConfigurationControls(Composite composite) {
        Group preverifyConfigGroup = new Group(composite, 0);
        preverifyConfigGroup.setText(MTJUIMessages.PreverificationPreferencePage_preverifyConfigGroup_label_text);
        preverifyConfigGroup.setLayout((Layout)new GridLayout(1, false));
        preverifyConfigGroup.setLayoutData((Object)new GridData(768));
        this.preverificationRadios = new Button[BUTTON_TEXTS.length];
        int i = 0;
        while (i < BUTTON_TEXTS.length) {
            this.preverificationRadios[i] = new Button((Composite)preverifyConfigGroup, 16);
            this.preverificationRadios[i].setText(BUTTON_TEXTS[i]);
            this.preverificationRadios[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Button selectedButton = (Button)event.getSource();
                    PreverificationPreferencePage.this.configCombo.setEnabled(selectedButton.getText().equals(MTJUIMessages.PreverificationPreferencePage_use_specific_config_label_text));
                }
            });
            if (CONFIG_FILE_LOCATIONS[i].equals("specified")) {
                this.addSpecificConfigurationControls(preverifyConfigGroup);
            }
            ++i;
        }
    }

    private void addDefaultPreverifierControls(Composite composite) {
        this.defaultPreverifierGroup = new Group(composite, 0);
        this.defaultPreverifierGroup.setText(MTJUIMessages.PreverificationPreferencePage_defaultPreverifierGroup_label_text);
        this.defaultPreverifierGroup.setLayout((Layout)new GridLayout(3, false));
        this.defaultPreverifierGroup.setLayoutData((Object)new GridData(768));
        Label tip = new Label((Composite)this.defaultPreverifierGroup, 0);
        tip.setText(MTJUIMessages.PreverificationPreferencePage_defaultPreverifierTip_label_text);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        gd.verticalIndent = 10;
        tip.setLayoutData((Object)gd);
        this.defaultPreverifierField = new FileFieldEditor(PREVERIFIER_TYPE_DEFAULT, MTJUIMessages.PreverificationPreferencePage_defaultPreverifierField_label_text, (Composite)this.defaultPreverifierGroup);
        String[] extensions = null;
        if (Platform.getOS().equals("win32")) {
            extensions = new String[]{"*.exe"};
        }
        Text defaultPreverifierFieldControl = this.defaultPreverifierField.getTextControl((Composite)this.defaultPreverifierGroup);
        defaultPreverifierFieldControl.setEnabled(false);
        this.defaultPreverifierField.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                PreverificationPreferencePage.this.isDefaultPreverifierValid();
            }
        });
        this.defaultPreverifierField.setFileExtensions(extensions);
        this.defaultPreverifierField.setPreferenceStore(this.getPreferenceStore());
    }

    private void addSpecificConfigurationControls(Group preverifyConfigGroup) {
        this.configCombo = new Combo((Composite)preverifyConfigGroup, 8);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 15;
        this.configCombo.setLayoutData((Object)gridData);
        String[] displayValues = new String[this.configSpecs.length];
        int i = 0;
        while (i < displayValues.length) {
            displayValues[i] = this.configSpecs[i].getName();
            ++i;
        }
        this.configCombo.setItems(displayValues);
        this.configCombo.setEnabled(false);
    }

    private void addTypeOfPreverifier(Composite composite) {
        this.radioGroupFieldEditor = new RadioGroupFieldEditor("preverify_type", MTJUIMessages.PreverificationPreferencePage_PreverifierType, 1, (String[][])new String[][]{{MTJUIMessages.PreverificationPreferencePage_PreverifierTypeDefault, PREVERIFIER_TYPE_DEFAULT}, {MTJUIMessages.PreverificationPreferencePage_PreverifierTypeEmulator, PREVERIFIER_TYPE_EMULATOR}, {MTJUIMessages.PreverificationPreferencePage_PreverifierTypeProguard, PREVERIFIER_TYPE_PROGUARD}}, composite, true);
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.setDefault("preverify_type", PREVERIFIER_TYPE_EMULATOR);
        this.radioGroupFieldEditor.setPreferenceStore(preferenceStore);
        this.radioGroupFieldEditor.load();
        this.radioGroupFieldEditor.fillIntoGrid(composite, 1);
        this.currentRadioSelected = preferenceStore.getString("preverify_type");
        this.radioGroupFieldEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                PreverificationPreferencePage.this.currentRadioSelected = (String)event.getNewValue();
                if (!PreverificationPreferencePage.this.currentRadioSelected.equals(event.getOldValue())) {
                    if (PreverificationPreferencePage.this.defaultPreverifierField != null) {
                        if (PreverificationPreferencePage.this.currentRadioSelected.equals(PreverificationPreferencePage.PREVERIFIER_TYPE_DEFAULT)) {
                            PreverificationPreferencePage.this.defaultPreverifierField.setEnabled(true, (Composite)PreverificationPreferencePage.this.defaultPreverifierGroup);
                        } else if (PreverificationPreferencePage.this.currentRadioSelected.equals(PreverificationPreferencePage.PREVERIFIER_TYPE_PROGUARD) || PreverificationPreferencePage.this.currentRadioSelected.equals(PreverificationPreferencePage.PREVERIFIER_TYPE_EMULATOR)) {
                            PreverificationPreferencePage.this.defaultPreverifierField.setEnabled(false, (Composite)PreverificationPreferencePage.this.defaultPreverifierGroup);
                        }
                    }
                    PreverificationPreferencePage.this.isDefaultPreverifierValid();
                }
            }
        });
        this.addField((FieldEditor)this.radioGroupFieldEditor);
    }

    private void buildSuites() {
        IWorkspaceRoot root = MTJCore.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        ArrayList<IProject> toBuild = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project2;
            IProject project = project2 = iProjectArray[n2];
            try {
                if (project.isOpen() && project.hasNature("org.eclipse.mtj.core.nature") && !this.usesProjectSpecificPreverification(project)) {
                    toBuild.add(project);
                }
            }
            catch (CoreException e) {
                MTJLogger.log((int)4, (String)MTJUIMessages.PreverificationPreferencePage_error_build_midlet_suite, (Throwable)e);
            }
            ++n2;
        }
        IProject[] projectArray = toBuild.toArray(new IProject[toBuild.size()]);
        if (projectArray.length > 0) {
            this.doBuild(projectArray);
        }
    }

    private boolean isDefaultPreverifierValid() {
        boolean result = false;
        if ((this.currentRadioSelected.equals(PREVERIFIER_TYPE_DEFAULT) || this.currentRadioSelected.equals("")) && this.defaultPreverifierField != null) {
            String preverifierExecutablePath = this.defaultPreverifierField.getStringValue().trim();
            IPreverifier preverifier = null;
            if (preverifierExecutablePath.length() > 0) {
                File preverifierExecutable = new File(preverifierExecutablePath);
                try {
                    preverifier = MTJCore.createPreverifier((String)"org.eclipse.mtj.preverifier.standard", (Object)preverifierExecutable);
                }
                catch (CoreException e) {
                    MTJLogger.log((int)4, (Throwable)e);
                }
            }
            if (preverifier != null) {
                result = true;
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(MTJUIMessages.PreverificationPreferencePage_error_invalid_preverifier_file);
            }
        } else {
            result = true;
            this.setErrorMessage(null);
        }
        return result;
    }

    private void setControlsFromDefaults() {
        if (this.preverificationRadios != null) {
            IPreferenceStore store = this.getPreferenceStore();
            String location = store.getDefaultString("preverify_config_location");
            int i = 0;
            while (i < this.preverificationRadios.length) {
                String fieldValue = CONFIG_FILE_LOCATIONS[i];
                this.preverificationRadios[i].setSelection(fieldValue.equals(location));
                ++i;
            }
            IPreferenceStore preverifierTypestore = this.radioGroupFieldEditor.getPreferenceStore();
            String preverifyType = preverifierTypestore.getDefaultString("preverify_type");
            if (this.defaultPreverifierField != null) {
                if (preverifyType.equals(PREVERIFIER_TYPE_DEFAULT) || preverifyType.equals("")) {
                    this.defaultPreverifierField.setEnabled(true, (Composite)this.defaultPreverifierGroup);
                } else {
                    this.defaultPreverifierField.setEnabled(false, (Composite)this.defaultPreverifierGroup);
                }
            }
            this.currentRadioSelected = preverifyType;
            int specIndex = 0;
            String config = store.getDefaultString("preverify_config_value");
            int i2 = 0;
            while (i2 < this.configSpecs.length) {
                IAPI spec = this.configSpecs[i2];
                if (spec.toString().equals(config)) {
                    specIndex = i2;
                    break;
                }
                ++i2;
            }
            this.configCombo.select(specIndex);
        }
        if (this.defaultPreverifierField != null) {
            this.defaultPreverifierField.loadDefault();
        }
        this.isDefaultPreverifierValid();
    }

    private void setControlsFromPreferences() {
        if (this.preverificationRadios != null) {
            IPreferenceStore store = this.getPreferenceStore();
            String location = store.getString("preverify_config_location");
            int i = 0;
            while (i < this.preverificationRadios.length) {
                String fieldValue = CONFIG_FILE_LOCATIONS[i];
                this.preverificationRadios[i].setSelection(fieldValue.equals(location));
                ++i;
            }
            IPreferenceStore preverifierTypestore = this.radioGroupFieldEditor.getPreferenceStore();
            String preverifierTypeString = preverifierTypestore.getString("preverify_type");
            if (this.defaultPreverifierField != null) {
                if (preverifierTypeString.equals(PREVERIFIER_TYPE_DEFAULT) || preverifierTypeString.equals("")) {
                    this.defaultPreverifierField.setEnabled(true, (Composite)this.defaultPreverifierGroup);
                } else {
                    this.defaultPreverifierField.setEnabled(false, (Composite)this.defaultPreverifierGroup);
                }
            }
            this.currentRadioSelected = preverifierTypeString;
            int specIndex = 0;
            String config = store.getString("preverify_config_value");
            int i2 = 0;
            while (i2 < this.configSpecs.length) {
                IAPI spec = this.configSpecs[i2];
                if (spec.toString().equals(config)) {
                    specIndex = i2;
                    break;
                }
                ++i2;
            }
            this.configCombo.select(specIndex);
        }
        if (this.defaultPreverifierField != null) {
            this.defaultPreverifierField.load();
        }
        this.isDefaultPreverifierValid();
    }

    private void setDefaultPreverifier(boolean reset) {
        boolean store = false;
        IPreverifier preverifier = null;
        if (reset) {
            store = true;
        } else if (!this.defaultPreverifierField.getStringValue().equals(this.getPreferenceStore().getString(PREVERIFIER_TYPE_DEFAULT))) {
            String errorMessage = null;
            File preverifierExecutable = new File(this.defaultPreverifierField.getStringValue().trim());
            try {
                preverifier = MTJCore.createPreverifier((String)"org.eclipse.mtj.preverifier.standard", (Object)preverifierExecutable);
            }
            catch (CoreException e) {
                MTJUIPlugin.displayError(this.getShell(), 4, -999, MTJUIMessages.PreverificationPreferencePage_invalid_preverifier_dialog_title, MTJUIMessages.PreverificationPreferencePage_invalid_preverifier_dialog_message, e);
                MTJLogger.log((int)4, (String)NLS.bind((String)MTJUIMessages.PreverificationPreferencePage_device_store_error, (Object[])new String[]{((Object)((Object)e)).getClass().getName(), e.getMessage()}), (Throwable)e);
            }
            if (preverifier == null) {
                errorMessage = MTJUIMessages.PreverificationPreferencePage_error_invalid_preverifier_file;
            } else {
                store = true;
            }
            this.setErrorMessage(errorMessage);
        }
        if (store) {
            MTJCore.getDeviceRegistry().setDefaultPreverifer(preverifier);
            try {
                MTJCore.getDeviceRegistry().store();
            }
            catch (Exception e) {
                MTJUIPlugin.displayError(this.getShell(), 4, -999, MTJUIMessages.PreverificationPreferencePage_error_store_preverifier_dialog_title, MTJUIMessages.PreverificationPreferencePage_error_store_preverifier_dialog_message, e);
                MTJLogger.log((int)4, (String)NLS.bind((String)MTJUIMessages.PreverificationPreferencePage_device_store_error, (Object[])new String[]{e.getClass().getName(), e.getMessage()}), (Throwable)e);
            }
        }
    }

    private void setPreferencesFromControls() {
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.preverificationRadios.length) {
            if (this.preverificationRadios[i].getSelection()) {
                store.setValue("preverify_config_location", CONFIG_FILE_LOCATIONS[i]);
                break;
            }
            ++i;
        }
        int index = this.configCombo.getSelectionIndex();
        store.setValue("preverify_config_value", this.configSpecs[index].toString());
        if (this.defaultPreverifierField != null && (this.currentRadioSelected.equals(PREVERIFIER_TYPE_DEFAULT) || this.currentRadioSelected.equals(""))) {
            this.setDefaultPreverifier(false);
            this.defaultPreverifierField.store();
        } else {
            this.setDefaultPreverifier(true);
        }
    }

    private boolean usesProjectSpecificPreverification(IProject project) {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences prefNode = projectScope.getNode("org.eclipse.mtj.core");
        return prefNode.getBoolean("pkg_use_project", false);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.addConfigurationControls(composite);
        this.addTypeOfPreverifier(composite);
        if (!this.embeddedInProperties) {
            this.addDefaultPreverifierControls(composite);
        } else {
            this.noDefaultAndApplyButton();
        }
        this.setControlsFromPreferences();
        return composite;
    }

    protected void createFieldEditors() {
    }
}

