/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.midp.IApplicationDescriptor;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.midp.J2MENature;
import org.eclipse.mtj.internal.core.project.midp.LibletProperties;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.sdk.device.midp.PackagingModel;
import org.eclipse.mtj.internal.core.util.ClasspathChangeMonitor;
import org.eclipse.mtj.internal.core.util.ColonDelimitedProperties;
import org.eclipse.mtj.internal.core.util.IClasspathChangeListener;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class LIBletPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private List<LibletProperties> liblets = new ArrayList<LibletProperties>();
    private ComboViewer comboViewer;
    private boolean dirty = false;
    private Text jadUrlText;
    private Text libletNameText;
    private Text libletVendorText;
    private Text libletVersionText;
    private Button libletRadioButton;
    private Button proprietaryRadioButton;
    private Button serviceRadioButton;
    private Button standardRadioButton;
    private Button optionalRadioButton;
    private Button requiredRadioButton;
    private Button relativeUrlButton;
    private Label jadUrlLabel;
    private Button removeButton;
    private Label notificationLabel;
    private Label libletVendorLabel;
    private Label libletVersionLabel;
    private Composite contentComposite;
    private Composite noLibletComposite;
    private Composite mainComposite;
    private Composite jadURLComposite;

    protected Control createContents(Composite parent) {
        int maxButtonWidth;
        this.noDefaultAndApplyButton();
        this.initLIBletList();
        this.contentComposite = new Composite(parent, 0);
        this.contentComposite.setLayout((Layout)new StackLayout());
        this.noLibletComposite = new Composite(this.contentComposite, 0);
        this.noLibletComposite.setLayout((Layout)new GridLayout());
        this.mainComposite = new Composite(this.contentComposite, 0);
        Label noLibletLabel = new Label(this.noLibletComposite, 0);
        noLibletLabel.setText(MTJUIMessages.LIBletPropertyPage_no_liblet_message);
        Button noLibletButton = new Button(this.noLibletComposite, 0);
        noLibletButton.setText(MTJUIMessages.LIBletPropertyPage_no_liblet_add_button);
        Listener addButtonListener = new Listener(){

            public void handleEvent(Event event) {
                LibletProperties newItem = new LibletProperties(MTJUIMessages.LIBletPropertyPage_default_liblet_name, LibletProperties.Level.OPTIONAL, LibletProperties.Type.STANDARD, "", MTJUIMessages.LIBletPropertyPage_default_liblet_vendor, MTJUIMessages.LIBletPropertyPage_default_liblet_version, "");
                LIBletPropertyPage.this.liblets.add(newItem);
                LIBletPropertyPage.this.dirty = true;
                LIBletPropertyPage.this.refreshComboViewer();
                LIBletPropertyPage.this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)newItem));
            }
        };
        noLibletButton.addListener(13, addButtonListener);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        this.mainComposite.setLayout((Layout)gridLayout);
        Label label = new Label(this.mainComposite, 0);
        label.setText(MTJUIMessages.LIBletPropertyPage_liblet_label);
        this.comboViewer = new ComboViewer(this.mainComposite, 8);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.comboViewer.getCombo().setLayoutData((Object)gridData);
        this.comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof LibletProperties) {
                    LibletProperties item = (LibletProperties)element;
                    return String.valueOf(item.getName()) + " (" + LIBletPropertyPage.getTypeName(item.getType()) + ")";
                }
                return super.getText(element);
            }
        });
        this.comboViewer.setInput(this.liblets);
        Button addButton = new Button(this.mainComposite, 0);
        addButton.setText(MTJUIMessages.LIBletPropertyPage_add_button);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        addButton.setLayoutData((Object)gridData);
        addButton.addListener(13, addButtonListener);
        this.removeButton = new Button(this.mainComposite, 0);
        this.removeButton.setText(MTJUIMessages.LIBletPropertyPage_remove_button);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection selection = (IStructuredSelection)LIBletPropertyPage.this.comboViewer.getSelection();
                LibletProperties listItem = (LibletProperties)selection.getFirstElement();
                int selectionIndex = LIBletPropertyPage.this.comboViewer.getCombo().getSelectionIndex();
                LIBletPropertyPage.this.liblets.remove(listItem);
                LIBletPropertyPage.this.dirty = true;
                LIBletPropertyPage.this.refreshComboViewer();
                if (LIBletPropertyPage.this.liblets.size() != 0) {
                    selectionIndex = selectionIndex < LIBletPropertyPage.this.liblets.size() ? selectionIndex : LIBletPropertyPage.this.liblets.size() - 1;
                    StructuredSelection newSelection = new StructuredSelection(LIBletPropertyPage.this.liblets.get(selectionIndex));
                    LIBletPropertyPage.this.comboViewer.setSelection((ISelection)newSelection);
                }
            }
        });
        ((GridData)addButton.getLayoutData()).widthHint = maxButtonWidth = Math.max(addButton.computeSize((int)-1, (int)-1).x, this.removeButton.computeSize((int)-1, (int)-1).x);
        gridData = new GridData();
        gridData.widthHint = maxButtonWidth;
        this.removeButton.setLayoutData((Object)gridData);
        Label levelLabel = new Label(this.mainComposite, 0);
        levelLabel.setText(MTJUIMessages.LIBletPropertyPage_level_label);
        Composite levelGroup = new Composite(this.mainComposite, 0);
        levelGroup.setLayout((Layout)new RowLayout(256));
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        levelGroup.setLayoutData((Object)gridData);
        this.optionalRadioButton = new Button(levelGroup, 16);
        this.optionalRadioButton.setText(MTJUIMessages.LIBletPropertyPage_optional_button);
        this.optionalRadioButton.setSelection(true);
        this.requiredRadioButton = new Button(levelGroup, 16);
        this.requiredRadioButton.setText(MTJUIMessages.LIBletPropertyPage_required_button);
        Label typeLabel = new Label(this.mainComposite, 0);
        typeLabel.setText(MTJUIMessages.LIBletPropertyPage_type_label);
        Composite typeGroup = new Composite(this.mainComposite, 0);
        typeGroup.setLayout((Layout)new RowLayout(256));
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        typeGroup.setLayoutData((Object)gridData);
        this.libletRadioButton = new Button(typeGroup, 16);
        this.libletRadioButton.setText(MTJUIMessages.LIBletPropertyPage_liblet_button);
        this.libletRadioButton.setSelection(true);
        this.standardRadioButton = new Button(typeGroup, 16);
        this.standardRadioButton.setText(MTJUIMessages.LIBletPropertyPage_standard_button);
        this.serviceRadioButton = new Button(typeGroup, 16);
        this.serviceRadioButton.setText(MTJUIMessages.LIBletPropertyPage_service_button);
        this.proprietaryRadioButton = new Button(typeGroup, 16);
        this.proprietaryRadioButton.setText(MTJUIMessages.LIBletPropertyPage_proprietary_button);
        this.jadURLComposite = new Composite(this.mainComposite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.jadURLComposite.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalIndent = 15;
        this.jadURLComposite.setLayoutData((Object)gridData);
        this.jadUrlLabel = new Label(this.jadURLComposite, 0);
        this.jadUrlLabel.setText(MTJUIMessages.LIBletPropertyPage_jad_url_label);
        this.jadUrlText = new Text(this.jadURLComposite, 2048);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.jadUrlText.setLayoutData((Object)gridData);
        this.relativeUrlButton = new Button(this.jadURLComposite, 0);
        this.relativeUrlButton.setText(MTJUIMessages.LIBletPropertyPage_relative_url_label);
        this.relativeUrlButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IStructuredSelection selection = (IStructuredSelection)LIBletPropertyPage.this.comboViewer.getSelection();
                LibletProperties listItem = (LibletProperties)selection.getFirstElement();
                String jadURL = "lib/" + listItem.getJadFileName();
                LIBletPropertyPage.this.jadUrlText.setText(jadURL);
                LIBletPropertyPage.this.updateLIBletListItem(listItem);
            }
        });
        new Label(this.jadURLComposite, 0);
        this.notificationLabel = new Label(this.jadURLComposite, 0);
        this.notificationLabel.setText(MTJUIMessages.LIBletPropertyPage_liblet_notification_label);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.notificationLabel.setLayoutData((Object)gridData);
        Label libletInformationLabel = new Label(this.mainComposite, 0);
        libletInformationLabel.setText(MTJUIMessages.LIBletPropertyPage_liblet_information_label);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.verticalIndent = 15;
        libletInformationLabel.setLayoutData((Object)gridData);
        Label libletNameLabel = new Label(this.mainComposite, 0);
        libletNameLabel.setText(MTJUIMessages.LIBletPropertyPage_liblet_name_label);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 10;
        libletNameLabel.setLayoutData((Object)gridData);
        this.libletNameText = new Text(this.mainComposite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.widthHint = 200;
        this.libletNameText.setLayoutData((Object)gridData);
        this.libletVendorLabel = new Label(this.mainComposite, 0);
        this.libletVendorLabel.setText(MTJUIMessages.LIBletPropertyPage_liblet_vendor_label);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 10;
        this.libletVendorLabel.setLayoutData((Object)gridData);
        this.libletVendorText = new Text(this.mainComposite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.widthHint = 200;
        this.libletVendorText.setLayoutData((Object)gridData);
        this.libletVersionLabel = new Label(this.mainComposite, 0);
        this.libletVersionLabel.setText(MTJUIMessages.LIBletPropertyPage_liblet_version_label);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 10;
        this.libletVersionLabel.setLayoutData((Object)gridData);
        this.libletVersionText = new Text(this.mainComposite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.widthHint = 200;
        this.libletVersionText.setLayoutData((Object)gridData);
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){
            private LibletProperties previousSelection;
            private Button[] radioButtons;
            {
                this.radioButtons = new Button[]{LIBletPropertyPage.this.libletRadioButton, LIBletPropertyPage.this.proprietaryRadioButton, LIBletPropertyPage.this.serviceRadioButton, LIBletPropertyPage.this.standardRadioButton, LIBletPropertyPage.this.optionalRadioButton, LIBletPropertyPage.this.requiredRadioButton};
            }

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() > 0) {
                    LibletProperties item = (LibletProperties)selection.getFirstElement();
                    if (this.previousSelection != null && this.previousSelection != item) {
                        LIBletPropertyPage.this.updateLIBletListItem(this.previousSelection);
                    }
                    LIBletPropertyPage.this.jadUrlText.setText(item.getJadURL());
                    LIBletPropertyPage.this.libletNameText.setText(item.getName());
                    LIBletPropertyPage.this.libletVendorText.setText(item.getVendor());
                    LIBletPropertyPage.this.libletVersionText.setText(item.getVersion());
                    Button[] buttonArray = this.radioButtons;
                    int n = this.radioButtons.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Button b = buttonArray[n2];
                        b.setSelection(false);
                        ++n2;
                    }
                    switch (item.getType()) {
                        case LIBLET: {
                            LIBletPropertyPage.this.libletRadioButton.setSelection(true);
                            break;
                        }
                        case PROPRIETARY: {
                            LIBletPropertyPage.this.proprietaryRadioButton.setSelection(true);
                            break;
                        }
                        case SERVICE: {
                            LIBletPropertyPage.this.serviceRadioButton.setSelection(true);
                            break;
                        }
                        case STANDARD: {
                            LIBletPropertyPage.this.standardRadioButton.setSelection(true);
                        }
                    }
                    switch (item.getLevel()) {
                        case OPTIONAL: {
                            LIBletPropertyPage.this.optionalRadioButton.setSelection(true);
                            break;
                        }
                        case REQUIRED: {
                            LIBletPropertyPage.this.requiredRadioButton.setSelection(true);
                        }
                    }
                    this.previousSelection = item;
                    LIBletPropertyPage.this.setComponentsAvailability();
                }
            }
        });
        SelectionAdapter typeSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    LIBletPropertyPage.this.setComponentsAvailability();
                }
            }
        };
        this.libletRadioButton.addSelectionListener((SelectionListener)typeSelectionAdapter);
        this.proprietaryRadioButton.addSelectionListener((SelectionListener)typeSelectionAdapter);
        this.serviceRadioButton.addSelectionListener((SelectionListener)typeSelectionAdapter);
        this.standardRadioButton.addSelectionListener((SelectionListener)typeSelectionAdapter);
        ClasspathChangeMonitor.getInstance().addClasspathChangeListener((IMTJProject)this.getMidletSuiteProject(), new IClasspathChangeListener(){

            public void classpathChanged() {
                LIBletPropertyPage.this.updateLIBletProjectItems();
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        LIBletPropertyPage.this.refreshComboViewer();
                        LIBletPropertyPage.this.performOk();
                    }
                });
            }
        });
        this.updateLIBletProjectItems();
        this.refreshComboViewer();
        this.setComponentsAvailability();
        return this.contentComposite;
    }

    private void refreshComboViewer() {
        this.comboViewer.refresh();
        if (this.liblets.size() == 0) {
            ((StackLayout)this.contentComposite.getLayout()).topControl = this.noLibletComposite;
        } else {
            ((StackLayout)this.contentComposite.getLayout()).topControl = this.mainComposite;
            StructuredSelection selection = new StructuredSelection((Object)this.liblets.get(0));
            this.comboViewer.setSelection((ISelection)selection);
        }
        this.contentComposite.layout();
    }

    private void updateLIBletProjectItems() {
        IMidletSuiteProject midletProject = this.getMidletSuiteProject();
        String[] requiredProjectNames = null;
        try {
            requiredProjectNames = midletProject.getJavaProject().getRequiredProjectNames();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ArrayList<IMidletSuiteProject> libletProjects = new ArrayList<IMidletSuiteProject>();
        String[] stringArray = requiredProjectNames;
        int n = requiredProjectNames.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = stringArray[n2];
            IProject project = workspace.getRoot().getProject(projectName);
            IMidletSuiteProject midletSuiteProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)JavaCore.create((IProject)project));
            if (midletSuiteProject.getProjectPackagingModel() == PackagingModel.LIBLET) {
                libletProjects.add(midletSuiteProject);
            }
            ++n2;
        }
        HashMap<String, LibletProperties.Level> libletProjectsLevel = new HashMap<String, LibletProperties.Level>();
        Iterator<LibletProperties> iterator = this.liblets.iterator();
        while (iterator.hasNext()) {
            LibletProperties libletProp = iterator.next();
            if (libletProp.getType() != LibletProperties.Type.LIBLET) continue;
            libletProjectsLevel.put(libletProp.getProjectName(), libletProp.getLevel());
            iterator.remove();
        }
        for (IMidletSuiteProject project : libletProjects) {
            IApplicationDescriptor descriptor = project.getApplicationDescriptor();
            ColonDelimitedProperties properties = (ColonDelimitedProperties)descriptor.getManifestProperties();
            String libletName = properties.getProperty("LIBlet-Name");
            String libletVendor = properties.getProperty("LIBlet-Vendor");
            String libletVersion = properties.getProperty("LIBlet-Version");
            String jadURL = "lib/" + project.getJadFileName();
            LibletProperties.Level level = (LibletProperties.Level)libletProjectsLevel.get(project.getProject().getName());
            LibletProperties newItem = new LibletProperties(libletName, level != null ? level : LibletProperties.Level.OPTIONAL, LibletProperties.Type.LIBLET, jadURL, libletVendor, libletVersion, project.getProject().getName());
            newItem.setJadFileName(project.getJadFileName());
            this.liblets.add(newItem);
        }
    }

    private void updateLIBletListItem(LibletProperties item) {
        if (!item.getJadURL().equals(this.jadUrlText.getText())) {
            item.setJadURL(this.jadUrlText.getText());
            this.dirty = true;
        }
        if (!item.getName().equals(this.libletNameText.getText())) {
            item.setName(this.libletNameText.getText());
            this.dirty = true;
        }
        if (!item.getVendor().equals(this.libletVendorText.getText())) {
            item.setVendor(this.libletVendorText.getText());
            this.dirty = true;
        }
        if (!item.getVersion().equals(this.libletVersionText.getText())) {
            item.setVersion(this.libletVersionText.getText());
            this.dirty = true;
        }
        LibletProperties.Type type = null;
        if (this.libletRadioButton.getSelection()) {
            type = LibletProperties.Type.LIBLET;
        } else if (this.proprietaryRadioButton.getSelection()) {
            type = LibletProperties.Type.PROPRIETARY;
        } else if (this.serviceRadioButton.getSelection()) {
            type = LibletProperties.Type.SERVICE;
        } else if (this.standardRadioButton.getSelection()) {
            type = LibletProperties.Type.STANDARD;
        }
        if (type != item.getType()) {
            item.setType(type);
            this.dirty = true;
        }
        LibletProperties.Level level = null;
        if (this.optionalRadioButton.getSelection()) {
            level = LibletProperties.Level.OPTIONAL;
        } else if (this.requiredRadioButton.getSelection()) {
            level = LibletProperties.Level.REQUIRED;
        }
        if (level != item.getLevel()) {
            item.setLevel(level);
            this.dirty = true;
        }
        this.comboViewer.refresh();
    }

    private void setComponentsAvailability() {
        boolean islibletRadioButtonSelected = this.libletRadioButton.getSelection();
        boolean isServiceRadioButtonSelected = this.serviceRadioButton.getSelection();
        this.proprietaryRadioButton.setEnabled(!islibletRadioButtonSelected);
        this.serviceRadioButton.setEnabled(!islibletRadioButtonSelected);
        this.standardRadioButton.setEnabled(!islibletRadioButtonSelected);
        this.libletNameText.setEnabled(!islibletRadioButtonSelected);
        this.libletRadioButton.setEnabled(islibletRadioButtonSelected);
        this.removeButton.setEnabled(!islibletRadioButtonSelected);
        this.libletVendorText.setEnabled(!islibletRadioButtonSelected);
        this.setComponentExclude((Control)this.jadURLComposite, !islibletRadioButtonSelected);
        this.setComponentExclude((Control)this.libletVendorLabel, isServiceRadioButtonSelected);
        this.setComponentExclude((Control)this.libletVendorText, isServiceRadioButtonSelected);
        this.setComponentExclude((Control)this.libletVersionLabel, isServiceRadioButtonSelected);
        this.setComponentExclude((Control)this.libletVersionText, isServiceRadioButtonSelected);
        this.mainComposite.layout();
    }

    private void setComponentExclude(Control component, boolean exclude) {
        component.setVisible(!exclude);
        Object layoutData = component.getLayoutData();
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).exclude = exclude;
        }
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            IStructuredSelection selection = (IStructuredSelection)this.comboViewer.getSelection();
            LibletProperties item = (LibletProperties)selection.getFirstElement();
            if (item != null) {
                this.updateLIBletListItem(item);
            }
            if (this.dirty) {
                String title = MTJUIMessages.LIBletPropertyPage_unsavedchanges_title;
                String message = MTJUIMessages.LIBletPropertyPage_unsavedchanges_message;
                String[] buttonLabels = new String[]{MTJUIMessages.LIBletPropertyPage_unsavedchanges_button_save, MTJUIMessages.LIBletPropertyPage_unsavedchanges_button_discard, MTJUIMessages.LIBletPropertyPage_unsavedchanges_button_ignore};
                MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 3, buttonLabels, 0);
                int res = dialog.open();
                if (res == 0) {
                    this.performOk();
                } else if (res == 1) {
                    this.initLIBletList();
                }
            }
        }
        super.setVisible(visible);
    }

    private void initLIBletList() {
        this.liblets.clear();
        this.dirty = false;
        IProject project = this.getCurrentProject();
        boolean isJ2meProject = false;
        try {
            isJ2meProject = J2MENature.hasMtjCoreNature((IProject)project);
        }
        catch (CoreException coreException) {}
        if (!isJ2meProject) {
            return;
        }
        List<LibletProperties> properties = null;
        try {
            LibletProperties[] libletProperties = this.getMidletSuiteProject().getLibletProperties();
            if (libletProperties != null) {
                properties = Arrays.asList(libletProperties);
            }
        }
        catch (CoreException coreException) {}
        if (properties != null) {
            this.liblets.addAll(properties);
        }
    }

    private IProject getCurrentProject() {
        IProject project = null;
        IAdaptable adaptable = this.getElement();
        if (adaptable instanceof IProject) {
            project = (IProject)adaptable;
        } else if (adaptable instanceof IJavaProject) {
            project = ((IJavaProject)adaptable).getProject();
        }
        return project;
    }

    private IMidletSuiteProject getMidletSuiteProject() {
        IJavaProject javaProject = JavaCore.create((IProject)this.getCurrentProject());
        IMidletSuiteProject midletProject = MidletSuiteFactory.getMidletSuiteProject((IJavaProject)javaProject);
        return midletProject;
    }

    public boolean performOk() {
        IStructuredSelection selection = (IStructuredSelection)this.comboViewer.getSelection();
        LibletProperties item = (LibletProperties)selection.getFirstElement();
        if (item != null) {
            this.updateLIBletListItem(item);
        }
        IProject project = this.getCurrentProject();
        boolean isJ2meProject = false;
        try {
            isJ2meProject = J2MENature.hasMtjCoreNature((IProject)project);
        }
        catch (CoreException coreException) {}
        if (!isJ2meProject) {
            return true;
        }
        IMidletSuiteProject midletProject = this.getMidletSuiteProject();
        try {
            midletProject.setLibletProperties(this.liblets.toArray(new LibletProperties[0]));
            midletProject.saveMetaData();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.dirty = false;
        return true;
    }

    private static String getTypeName(LibletProperties.Type type) {
        switch (type) {
            case LIBLET: {
                return MTJUIMessages.LIBletPropertyPage_liblet_button;
            }
            case PROPRIETARY: {
                return MTJUIMessages.LIBletPropertyPage_proprietary_button;
            }
            case SERVICE: {
                return MTJUIMessages.LIBletPropertyPage_service_button;
            }
            case STANDARD: {
                return MTJUIMessages.LIBletPropertyPage_standard_button;
            }
        }
        return null;
    }
}

