/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.templates.midlets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.mtj.internal.ui.MTJUIMessages;
import org.eclipse.mtj.internal.ui.templates.midlets.MIDletTemplate;
import org.eclipse.mtj.internal.ui.templates.midlets.MIDletTemplateBuffer;
import org.eclipse.mtj.internal.ui.templates.midlets.MIDletTemplateBuilderException;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidletTemplateBuilder {
    private MIDletTemplate template;
    private Map<String, String> dictionary;

    public MidletTemplateBuilder(MIDletTemplate template, Map<String, String> dictionary) {
        Assert.isNotNull((Object)template);
        Assert.isNotNull(dictionary);
        this.template = template;
        this.dictionary = dictionary;
    }

    public IType build(IPackageFragmentRoot root, IPackageFragment pack, String midletName, IProgressMonitor monitor) throws MIDletTemplateBuilderException {
        IType createdType = null;
        try {
            monitor.beginTask("Creating MIDlet package", 4);
            if (pack == null) {
                pack = root.getPackageFragment("");
            }
            if (!pack.exists()) {
                String packName = pack.getElementName();
                pack = root.createPackageFragment(packName, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
            MIDletTemplateBuffer buffer = MIDletTemplateBuffer.createTemplateBuffer(this.template, this.dictionary, pack.getElementName(), midletName);
            if (buffer == null) {
                throw new MIDletTemplateBuilderException(MTJUIMessages.MidletTemplateBuilder_UnableToGenerateClasses);
            }
            Map<String, String> conflictingJavaClassMap = this.createConflictingJavaClassMap(this.getConflictingFileNames(root, pack, midletName, monitor), pack);
            HashMap<String, String> conflictingResourcesMap = new HashMap<String, String>();
            this.createConflictingResourcesMap(root, conflictingResourcesMap);
            for (String name : buffer.getTemplateBuffers().keySet()) {
                String newClazzName;
                boolean isMidlet = false;
                String code = buffer.getTemplateBuffers().get(name);
                String clazzName = NLS.bind((String)"{0}.java", (Object)name.replace(".template", ""));
                if (clazzName.equalsIgnoreCase("$class_name$.java")) {
                    clazzName = NLS.bind((String)"{0}.java", (Object)midletName);
                    isMidlet = true;
                }
                if (conflictingJavaClassMap.containsKey(clazzName) && (newClazzName = conflictingJavaClassMap.get(clazzName)) != null && !newClazzName.isEmpty()) {
                    clazzName = newClazzName;
                }
                for (String currentClazzName : conflictingJavaClassMap.keySet()) {
                    String newClazzReference;
                    String existingClazzReference = currentClazzName.replace(".java", "");
                    if (!code.contains(existingClazzReference) || (newClazzReference = conflictingJavaClassMap.get(currentClazzName).replace(".java", "")) == null || newClazzReference.isEmpty()) continue;
                    code = code.replaceAll(existingClazzReference, newClazzReference);
                }
                for (String currentResourceName : conflictingResourcesMap.keySet()) {
                    String newResourceName;
                    if (!code.contains(currentResourceName) || (newResourceName = (String)conflictingResourcesMap.get(currentResourceName)) == null || newResourceName.isEmpty()) continue;
                    code = code.replaceAll(currentResourceName, newResourceName);
                }
                ICompilationUnit cu = pack.createCompilationUnit(clazzName, code, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (!isMidlet) continue;
                createdType = cu.getType(midletName);
            }
            IProject project = root.getJavaProject().getProject();
            File folder = new File(project.getLocation().toOSString());
            File bundleFile = FileLocator.getBundleFile((Bundle)this.template.getBundle());
            if (!bundleFile.isDirectory()) {
                this.copyResources(new ZipFile(bundleFile), folder);
            } else {
                this.copyResources(bundleFile, folder);
            }
            monitor.worked(1);
            project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            return createdType;
        }
        catch (Exception e) {
            throw new MIDletTemplateBuilderException(String.valueOf(MTJUIMessages.MidletTemplateBuilder_UnableToGenerateClasses) + e.getMessage());
        }
    }

    public String[] getConflictingFileNames(IPackageFragmentRoot root, IPackageFragment pack, String midletName, IProgressMonitor monitor) {
        ArrayList<String> conflicts = new ArrayList<String>();
        if (pack.exists()) {
            MIDletTemplateBuffer buffer = MIDletTemplateBuffer.createTemplateBuffer(this.template, this.dictionary, pack.getElementName(), midletName);
            for (String name : buffer.getTemplateBuffers().keySet()) {
                ICompilationUnit compilationUnit;
                String clazzName = NLS.bind((String)"{0}.java", (Object)name.replace(".template", ""));
                if (clazzName.equalsIgnoreCase("$class_name$.java")) {
                    clazzName = NLS.bind((String)"{0}.java", (Object)midletName);
                }
                if (!(compilationUnit = pack.getCompilationUnit(clazzName)).exists()) continue;
                conflicts.add(compilationUnit.getElementName());
            }
        }
        return conflicts.toArray(new String[conflicts.size()]);
    }

    private void copyFile(File source, File target) throws IOException {
        File file = null;
        if (source.isDirectory()) {
            File[] children;
            file = new File(target, source.getName());
            if (!file.exists() && !file.mkdir()) {
                return;
            }
            File[] fileArray = children = source.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.copyFile(child, file);
                ++n2;
            }
        } else {
            file = new File(this.resolveFileName(target, source.getName()));
            FileOutputStream out = null;
            FileInputStream in = null;
            try {
                out = new FileOutputStream(file);
                in = new FileInputStream(source);
                this.copyStreams(in, out);
            }
            finally {
                out.close();
                in.close();
            }
        }
    }

    private void copyResources(File bundleFolder, File projectFolder) throws IOException {
        String path = NLS.bind((String)"templates/{0}/resources", (Object)this.template.getId());
        File resources = new File(bundleFolder, path);
        if (resources.exists() && resources.isDirectory()) {
            File[] children;
            File[] fileArray = children = resources.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.copyFile(child, projectFolder);
                ++n2;
            }
        }
    }

    private void copyResources(ZipFile zipFile, File projectFolder) throws IOException {
        String expression = NLS.bind((String)"templates/{0}/resources/.+", (Object)this.template.getId());
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            if (!Pattern.matches(expression, zipEntry.getName())) continue;
            IPath path = new Path(zipEntry.getName()).removeFirstSegments(3);
            File file = new File(projectFolder, path.toString());
            if (!zipEntry.isDirectory()) {
                this.createFileFromZipFile(file, zipFile, zipEntry);
                continue;
            }
            this.createFolderFromZipFile(file);
        }
    }

    private void createFolderFromZipFile(File folder) {
        if (!folder.exists()) {
            folder.mkdir();
        }
    }

    private void copyStreams(InputStream in, OutputStream out) throws IOException {
        int _byte = -1;
        while ((_byte = in.read()) != -1) {
            out.write(_byte);
        }
    }

    private void createFileFromZipFile(File file, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        InputStream in = zipFile.getInputStream(zipEntry);
        this.copyStreams(in, out);
        ((OutputStream)out).close();
        in.close();
    }

    private Map<String, String> createConflictingJavaClassMap(String[] conflictingFileNames, IPackageFragment pack) {
        HashMap<String, String> replacingFileNamesMap = new HashMap<String, String>();
        int i = 0;
        while (i < conflictingFileNames.length) {
            String clazzName = conflictingFileNames[i];
            String originalClazzName = conflictingFileNames[i];
            int index = 1;
            String newClazzName = null;
            while (pack.getCompilationUnit(clazzName).exists()) {
                newClazzName = NLS.bind((String)"{0}.java", (Object)(String.valueOf(originalClazzName.replace(".java", "")) + index));
                ++index;
                clazzName = newClazzName;
            }
            replacingFileNamesMap.put(originalClazzName, newClazzName);
            ++i;
        }
        return replacingFileNamesMap;
    }

    private void createConflictingResourcesMap(IPackageFragmentRoot root, Map<String, String> conflictingResourcesMap) throws IOException {
        String path;
        File resources;
        IProject project = root.getJavaProject().getProject();
        File folder = new File(project.getLocation().toOSString());
        File bundleFile = FileLocator.getBundleFile((Bundle)this.template.getBundle());
        if (bundleFile.isDirectory() && (resources = new File(bundleFile, path = NLS.bind((String)"templates/{0}/resources", (Object)this.template.getId()))).exists() && resources.isDirectory()) {
            File[] children;
            File[] fileArray = children = resources.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.replaceResourceName(child, folder, conflictingResourcesMap);
                ++n2;
            }
        }
    }

    private void replaceResourceName(File source, File target, Map<String, String> conflictingResourcesMap) {
        File file = null;
        if (source.isDirectory()) {
            File[] children;
            file = new File(target, source.getName());
            if (!file.exists() && !file.mkdir()) {
                return;
            }
            File[] fileArray = children = source.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.replaceResourceName(child, file, conflictingResourcesMap);
                ++n2;
            }
        } else {
            String newFilePath = this.resolveFileName(target, source.getName());
            if (!newFilePath.equals(target.getAbsolutePath().concat(File.separator).concat(source.getName()))) {
                String newFileName = newFilePath.substring(newFilePath.lastIndexOf(File.separator) + 1);
                conflictingResourcesMap.put(source.getName(), newFileName);
            }
        }
    }

    private String resolveFileName(File target, String fileName) {
        File newFile = new File(target, fileName);
        File[] fileArray = target.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (fileName.equals(file.getName())) {
                int index = 1;
                while (newFile.exists()) {
                    String fileFirstPart = "";
                    String fileExtension = "";
                    int extensionIndex = fileName.lastIndexOf(".");
                    if (extensionIndex > 0) {
                        fileExtension = fileName.substring(extensionIndex);
                        fileFirstPart = String.valueOf(fileName.substring(0, extensionIndex).concat("_")) + index;
                    } else {
                        fileFirstPart = String.valueOf(fileName.concat("_")) + index;
                    }
                    newFile = new File(target, fileFirstPart.concat(fileExtension));
                    ++index;
                }
                break;
            }
            ++n2;
        }
        return newFile.getAbsolutePath();
    }
}

