/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.util;

import java.io.IOException;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.osgi.service.prefs.BackingStoreException;

public class PluginPreferenceStore
implements IPersistentPreferenceStore {
    private String ownerPlugingId;
    private IEclipsePreferences instancePreferences;
    private IEclipsePreferences defaultPreferences;
    private ListenerList listeners = new ListenerList();
    private boolean silentRunning = false;

    public PluginPreferenceStore(String pluginId) {
        this.ownerPlugingId = pluginId;
        this.instancePreferences = new InstanceScope().getNode(this.ownerPlugingId);
        this.defaultPreferences = new DefaultScope().getNode(this.ownerPlugingId);
        this.instancePreferences.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (!PluginPreferenceStore.this.silentRunning) {
                    PluginPreferenceStore.this.firePropertyChangeEvent(event.getKey(), event.getOldValue(), event.getNewValue());
                }
            }
        });
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        if (this.listeners.isEmpty()) {
            return;
        }
        Object[] list = this.listeners.getListeners();
        final PropertyChangeEvent event = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
        int i = 0;
        while (i < list.length) {
            final IPropertyChangeListener listener = (IPropertyChangeListener)list[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable("Preference Change Error"){

                public void run() {
                    listener.propertyChange(event);
                }
            });
            ++i;
        }
    }

    public boolean contains(String name) {
        return this.containsKey(this.instancePreferences, name);
    }

    private boolean containsKey(IEclipsePreferences prefs, String key) {
        String[] keys;
        if (key == null) {
            return false;
        }
        try {
            keys = prefs.keys();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            return false;
        }
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (key.equals(str)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean getBoolean(String name) {
        if (this.containsKey(this.instancePreferences, name)) {
            return this.instancePreferences.getBoolean(name, false);
        }
        return this.getDefaultBoolean(name);
    }

    public boolean getDefaultBoolean(String name) {
        return this.defaultPreferences.getBoolean(name, false);
    }

    public double getDefaultDouble(String name) {
        return this.defaultPreferences.getDouble(name, 0.0);
    }

    public float getDefaultFloat(String name) {
        return this.defaultPreferences.getFloat(name, 0.0f);
    }

    public int getDefaultInt(String name) {
        return this.defaultPreferences.getInt(name, 0);
    }

    public long getDefaultLong(String name) {
        return this.defaultPreferences.getLong(name, 0L);
    }

    public String getDefaultString(String name) {
        return this.defaultPreferences.get(name, "");
    }

    public double getDouble(String name) {
        if (this.containsKey(this.instancePreferences, name)) {
            return this.instancePreferences.getDouble(name, 0.0);
        }
        return this.getDefaultDouble(name);
    }

    public float getFloat(String name) {
        if (this.containsKey(this.instancePreferences, name)) {
            return this.instancePreferences.getFloat(name, 0.0f);
        }
        return this.getDefaultFloat(name);
    }

    public int getInt(String name) {
        if (this.containsKey(this.instancePreferences, name)) {
            return this.instancePreferences.getInt(name, 0);
        }
        return this.getDefaultInt(name);
    }

    public long getLong(String name) {
        if (this.containsKey(this.instancePreferences, name)) {
            return this.instancePreferences.getLong(name, 0L);
        }
        return this.getDefaultLong(name);
    }

    public String getString(String name) {
        if (this.containsKey(this.instancePreferences, name)) {
            return this.instancePreferences.get(name, "");
        }
        return this.getDefaultString(name);
    }

    public boolean isDefault(String name) {
        return !this.containsKey(this.instancePreferences, name);
    }

    public boolean needsSaving() {
        if (this.instancePreferences instanceof EclipsePreferences) {
            return ((EclipsePreferences)this.instancePreferences).isDirty();
        }
        return false;
    }

    public void putValue(String name, String value) {
        try {
            this.silentRunning = true;
            this.instancePreferences.put(name, value);
        }
        finally {
            this.silentRunning = false;
        }
    }

    public void setDefault(String name, double value) {
        this.defaultPreferences.putDouble(name, value);
    }

    public void setDefault(String name, float value) {
        this.defaultPreferences.putFloat(name, value);
    }

    public void setDefault(String name, int value) {
        this.defaultPreferences.putInt(name, value);
    }

    public void setDefault(String name, long value) {
        this.defaultPreferences.putLong(name, value);
    }

    public void setDefault(String name, String value) {
        this.defaultPreferences.put(name, value);
    }

    public void setDefault(String name, boolean value) {
        this.defaultPreferences.putBoolean(name, value);
    }

    public void setToDefault(String name) {
        this.instancePreferences.remove(name);
    }

    public void setValue(String name, double value) {
        this.instancePreferences.putDouble(name, value);
    }

    public void setValue(String name, float value) {
        this.instancePreferences.putFloat(name, value);
    }

    public void setValue(String name, int value) {
        this.instancePreferences.putInt(name, value);
    }

    public void setValue(String name, long value) {
        this.instancePreferences.putLong(name, value);
    }

    public void setValue(String name, String value) {
        this.instancePreferences.put(name, value);
    }

    public void setValue(String name, boolean value) {
        this.instancePreferences.putBoolean(name, value);
    }

    public void save() throws IOException {
        try {
            this.instancePreferences.flush();
        }
        catch (BackingStoreException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            ioe.initCause(e.getCause());
            throw ioe;
        }
    }
}

