/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.util;

import java.util.Vector;

public class StringMatcher {
    protected static final char singleWildCard = '\u0000';
    protected int bound = 0;
    protected boolean hasLeadingStar;
    protected boolean hasTrailingStar;
    protected boolean ignoreCase;
    protected boolean ignoreWildCards;
    protected int length;
    protected String pattern;
    protected String[] segments;

    public StringMatcher(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        this.ignoreCase = ignoreCase;
        this.ignoreWildCards = ignoreWildCards;
        this.pattern = pattern;
        this.length = pattern.length();
        if (ignoreWildCards) {
            this.parseNoWildCards();
        } else {
            this.parseWildCards();
        }
    }

    public Position find(String text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        int tlen = text.length();
        if (start < 0) {
            start = 0;
        }
        if (end > tlen) {
            end = tlen;
        }
        if (end < 0 || start >= end) {
            return null;
        }
        if (this.length == 0) {
            return new Position(start, start);
        }
        if (this.ignoreWildCards) {
            int x = this.posIn(text, start, end);
            if (x < 0) {
                return null;
            }
            return new Position(x, x + this.length);
        }
        int segCount = this.segments.length;
        if (segCount == 0) {
            return new Position(start, end);
        }
        int curPos = start;
        int matchStart = -1;
        int i = 0;
        while (i < segCount && curPos < end) {
            String current = this.segments[i];
            int nextMatch = this.regExpPosIn(text, curPos, end, current);
            if (nextMatch < 0) {
                return null;
            }
            if (i == 0) {
                matchStart = nextMatch;
            }
            curPos = nextMatch + current.length();
            ++i;
        }
        if (i < segCount) {
            return null;
        }
        return new Position(matchStart, curPos);
    }

    public boolean match(String text) {
        return this.match(text, 0, text.length());
    }

    /*
     * Unable to fully structure code
     */
    public boolean match(String text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        if (start > end) {
            return false;
        }
        if (this.ignoreWildCards) {
            return end - start == this.length && this.pattern.regionMatches(this.ignoreCase, 0, text, start, this.length) != false;
        }
        segCount = this.segments.length;
        if (segCount == 0 && (this.hasLeadingStar || this.hasTrailingStar)) {
            return true;
        }
        if (start == end) {
            return this.length == 0;
        }
        if (this.length == 0) {
            return start == end;
        }
        tlen = text.length();
        if (start < 0) {
            start = 0;
        }
        if (end > tlen) {
            end = tlen;
        }
        tCurPos = start;
        bound = end - this.bound;
        if (bound < 0) {
            return false;
        }
        i = 0;
        current = this.segments[i];
        segLength = current.length();
        if (!this.hasLeadingStar) {
            if (!this.regExpRegionMatches(text, start, current, 0, segLength)) {
                return false;
            }
            ++i;
            tCurPos += segLength;
        }
        if (this.segments.length != 1 || this.hasLeadingStar || this.hasTrailingStar) ** GOTO lbl39
        return tCurPos == end;
lbl-1000:
        // 1 sources

        {
            current = this.segments[i];
            k = current.indexOf(0);
            if (k < 0 ? (currentMatch = this.textPosIn(text, tCurPos, end, current)) < 0 : (currentMatch = this.regExpPosIn(text, tCurPos, end, current)) < 0) {
                return false;
            }
            tCurPos = currentMatch + current.length();
            ++i;
lbl39:
            // 2 sources

            ** while (i < segCount)
        }
lbl40:
        // 1 sources

        if (!this.hasTrailingStar && tCurPos != end) {
            clen = current.length();
            return this.regExpRegionMatches(text, end - clen, current, 0, clen);
        }
        return i == segCount;
    }

    private void parseNoWildCards() {
        this.segments = new String[1];
        this.segments[0] = this.pattern;
        this.bound = this.length;
    }

    private void parseWildCards() {
        if (this.pattern.startsWith("*")) {
            this.hasLeadingStar = true;
        }
        if (this.pattern.endsWith("*") && this.length > 1 && this.pattern.charAt(this.length - 2) != '\\') {
            this.hasTrailingStar = true;
        }
        Vector<String> temp = new Vector<String>();
        int pos = 0;
        StringBuffer buf = new StringBuffer();
        block5: while (pos < this.length) {
            char c = this.pattern.charAt(pos++);
            switch (c) {
                case '\\': {
                    char next;
                    if (pos >= this.length) {
                        buf.append(c);
                        break;
                    }
                    if ((next = this.pattern.charAt(pos++)) == '*' || next == '?' || next == '\\') {
                        buf.append(next);
                        break;
                    }
                    buf.append(c);
                    buf.append(next);
                    break;
                }
                case '*': {
                    if (buf.length() <= 0) continue block5;
                    temp.addElement(buf.toString());
                    this.bound += buf.length();
                    buf.setLength(0);
                    break;
                }
                case '?': {
                    buf.append('\u0000');
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        if (buf.length() > 0) {
            temp.addElement(buf.toString());
            this.bound += buf.length();
        }
        this.segments = new String[temp.size()];
        temp.copyInto(this.segments);
    }

    protected int posIn(String text, int start, int end) {
        int max = end - this.length;
        if (!this.ignoreCase) {
            int i = text.indexOf(this.pattern, start);
            if (i == -1 || i > max) {
                return -1;
            }
            return i;
        }
        int i = start;
        while (i <= max) {
            if (text.regionMatches(true, i, this.pattern, 0, this.length)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int regExpPosIn(String text, int start, int end, String p) {
        int plen = p.length();
        int max = end - plen;
        int i = start;
        while (i <= max) {
            if (this.regExpRegionMatches(text, i, p, 0, plen)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected boolean regExpRegionMatches(String text, int tStart, String p, int pStart, int plen) {
        while (plen-- > 0) {
            char tchar = text.charAt(tStart++);
            char pchar = p.charAt(pStart++);
            if (!this.ignoreWildCards && pchar == '\u0000' || pchar == tchar || this.ignoreCase && (Character.toUpperCase(tchar) == Character.toUpperCase(pchar) || Character.toLowerCase(tchar) == Character.toLowerCase(pchar))) continue;
            return false;
        }
        return true;
    }

    protected int textPosIn(String text, int start, int end, String p) {
        int plen = p.length();
        int max = end - plen;
        if (!this.ignoreCase) {
            int i = text.indexOf(p, start);
            if (i == -1 || i > max) {
                return -1;
            }
            return i;
        }
        int i = start;
        while (i <= max) {
            if (text.regionMatches(true, i, p, 0, plen)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static class Position {
        int end;
        int start;

        public Position(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getEnd() {
            return this.end;
        }

        public int getStart() {
            return this.start;
        }
    }
}

