/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.ui.wizards.importer.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ILeveledImportStructureProvider;
import org.eclipse.mtj.internal.ui.wizards.importer.common.ProjectImporterMessage;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarEntry;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarException;
import org.eclipse.mtj.internal.ui.wizards.importer.common.TarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarLeveledStructureProvider
implements ILeveledImportStructureProvider {
    private TarFile tarFile;
    private TarEntry root = new TarEntry("/");
    private Map<TarEntry, List<TarEntry>> children;
    private Map<IPath, TarEntry> directoryEntryCache = new HashMap<IPath, TarEntry>();
    private int stripLevel;

    public TarLeveledStructureProvider(TarFile sourceFile) {
        this.tarFile = sourceFile;
        this.root.setFileType(53);
    }

    protected TarEntry createContainer(IPath pathname) {
        TarEntry existingEntry = this.directoryEntryCache.get(pathname);
        if (existingEntry != null) {
            return existingEntry;
        }
        TarEntry parent = pathname.segmentCount() == 1 ? this.root : this.createContainer(pathname.removeLastSegments(1));
        TarEntry newEntry = new TarEntry(pathname.toString());
        newEntry.setFileType(53);
        this.directoryEntryCache.put(pathname, newEntry);
        ArrayList childList = new ArrayList();
        this.children.put(newEntry, childList);
        List<TarEntry> parentChildList = this.children.get(parent);
        parentChildList.add(newEntry);
        return newEntry;
    }

    protected void createFile(TarEntry entry) {
        Path pathname = new Path(entry.getName());
        TarEntry parent = pathname.segmentCount() == 1 ? this.root : this.directoryEntryCache.get(pathname.removeLastSegments(1));
        List<TarEntry> childList = this.children.get(parent);
        childList.add(entry);
    }

    public List<TarEntry> getChildren(Object element) {
        if (this.children == null) {
            this.initialize();
        }
        return this.children.get(element);
    }

    public InputStream getContents(Object element) {
        try {
            return this.tarFile.getInputStream((TarEntry)element);
        }
        catch (TarException e) {
            MTJLogger.log((int)4, (String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            MTJLogger.log((int)4, (String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public ResourceAttributes getResourceAttributes(Object element) {
        ResourceAttributes attributes = new ResourceAttributes();
        TarEntry entry = (TarEntry)element;
        attributes.setExecutable((entry.getMode() & 0x40L) != 0L);
        attributes.setReadOnly((entry.getMode() & 0x80L) == 0L);
        return attributes;
    }

    public String getFullPath(Object element) {
        return this.stripPath(((TarEntry)element).getName());
    }

    public String getLabel(Object element) {
        if (element.equals(this.root)) {
            return ((TarEntry)element).getName();
        }
        return this.stripPath(new Path(((TarEntry)element).getName()).lastSegment());
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    public TarFile getTarFile() {
        return this.tarFile;
    }

    @Override
    public boolean closeArchive() {
        try {
            this.getTarFile().close();
        }
        catch (IOException e) {
            MTJLogger.log((int)2, (String)(String.valueOf(ProjectImporterMessage.ZipImport_couldNotClose) + this.getTarFile().getName()), (Throwable)e);
            return false;
        }
        return true;
    }

    protected void initialize() {
        this.children = new HashMap<TarEntry, List<TarEntry>>(1000);
        this.children.put(this.root, new ArrayList());
        Enumeration<TarEntry> entries = this.tarFile.entries();
        while (entries.hasMoreElements()) {
            TarEntry entry = entries.nextElement();
            IPath path = new Path(entry.getName()).addTrailingSeparator();
            if (entry.getFileType() == 53) {
                this.createContainer(path);
                continue;
            }
            int pathSegmentCount = path.segmentCount();
            if (pathSegmentCount > 1) {
                this.createContainer(path.uptoSegment(pathSegmentCount - 1));
            }
            this.createFile(entry);
        }
    }

    public boolean isFolder(Object element) {
        return ((TarEntry)element).getFileType() == 53;
    }

    private String stripPath(String path) {
        String pathOrig = new String(path);
        int i = 0;
        while (i < this.stripLevel) {
            int firstSep = path.indexOf(47);
            if (firstSep == 0) {
                path = path.substring(1);
                firstSep = path.indexOf(47);
            }
            if (firstSep == -1) {
                return pathOrig;
            }
            path = path.substring(firstSep);
            ++i;
        }
        return path;
    }

    @Override
    public void setStrip(int level) {
        this.stripLevel = level;
    }

    @Override
    public int getStrip() {
        return this.stripLevel;
    }
}

