/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.ui.editors.jad;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.mtj.ui.editors.jad.IFilteredJADPropertyEditor;
import org.eclipse.mtj.ui.editors.jad.ListDescriptorPropertyDescription;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ComboJADPropertyEditor
extends FieldEditor
implements IFilteredJADPropertyEditor {
    private static final String UPDATE_FILTER_NOTIFICATION = "mtj_update_jad_filter";
    private Combo combo;
    private String currentValue;
    private String[][] namesAndValues;
    private ListDescriptorPropertyDescription.IListDescriptorPropertyFilter filter;
    private Map<String, Object> filterProperties = new HashMap<String, Object>();

    public ComboJADPropertyEditor(String name, String labelText, String[][] namesAndValues, ListDescriptorPropertyDescription.IListDescriptorPropertyFilter filter, Composite parent) {
        this.init(name, labelText);
        Assert.isTrue((boolean)this.checkArray(namesAndValues));
        this.namesAndValues = namesAndValues;
        this.filter = filter;
        this.createControl(parent);
    }

    private boolean checkArray(String[][] table) {
        if (table == null) {
            return false;
        }
        int i = 0;
        while (i < table.length) {
            String[] array = table[i];
            if (array == null || array.length != 2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void adjustForNumColumns(int numColumns) {
        if (numColumns > 1) {
            Label control = this.getLabelControl();
            int left = numColumns;
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
                --left;
            }
            ((GridData)this.combo.getLayoutData()).horizontalSpan = left;
        } else {
            Label control = this.getLabelControl();
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
            }
            ((GridData)this.combo.getLayoutData()).horizontalSpan = 1;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        int comboC = 1;
        if (numColumns > 1) {
            comboC = numColumns - 1;
        }
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getComboBoxControl(parent);
        gd = new GridData();
        gd.horizontalSpan = comboC;
        gd.horizontalAlignment = 4;
        control.setLayoutData((Object)gd);
        control.setFont(parent.getFont());
    }

    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()), false);
    }

    protected void doLoadDefault() {
        this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()), false);
    }

    public void updateDependencies() {
        this.fireValueChanged(UPDATE_FILTER_NOTIFICATION, null, this.currentValue);
    }

    protected void doStore() {
        if (this.currentValue == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.currentValue);
    }

    public int getNumberOfControls() {
        return 2;
    }

    private Combo getComboBoxControl(Composite parent) {
        if (this.combo == null) {
            this.combo = new Combo(parent, 8);
            this.combo.setFont(parent.getFont());
            String[][] filteredNamesAndValues = this.getFilteredNamesAndValues();
            int i = 0;
            while (i < filteredNamesAndValues.length) {
                this.combo.add(filteredNamesAndValues[i][0], i);
                ++i;
            }
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    String oldValue = ComboJADPropertyEditor.this.currentValue;
                    String name = ComboJADPropertyEditor.this.combo.getText();
                    ComboJADPropertyEditor.this.currentValue = ComboJADPropertyEditor.this.getValueForName(name);
                    ComboJADPropertyEditor.this.setPresentsDefaultValue(false);
                    ComboJADPropertyEditor.this.fireValueChanged("field_editor_value", oldValue, ComboJADPropertyEditor.this.currentValue);
                    ComboJADPropertyEditor.this.fireValueChanged(ComboJADPropertyEditor.UPDATE_FILTER_NOTIFICATION, oldValue, ComboJADPropertyEditor.this.currentValue);
                }
            });
        }
        return this.combo;
    }

    private String getValueForName(String name) {
        int i = 0;
        while (i < this.namesAndValues.length) {
            String[] entry = this.namesAndValues[i];
            if (name.equals(entry[0])) {
                return entry[1];
            }
            ++i;
        }
        return this.namesAndValues[0][1];
    }

    private void updateComboForValue(String value, boolean considerFiltration) {
        String oldValue = this.currentValue;
        this.currentValue = value;
        String[][] filteredNamesAndValues = considerFiltration ? this.getFilteredNamesAndValues() : this.namesAndValues;
        int i = 0;
        while (i < filteredNamesAndValues.length) {
            if (value.equals(filteredNamesAndValues[i][1])) {
                this.combo.setText(filteredNamesAndValues[i][0]);
                return;
            }
            ++i;
        }
        if (filteredNamesAndValues.length > 0) {
            this.currentValue = filteredNamesAndValues[0][1];
            this.combo.setText(filteredNamesAndValues[0][0]);
            this.fireValueChanged("field_editor_value", oldValue, this.currentValue);
            if (considerFiltration) {
                this.fireValueChanged(UPDATE_FILTER_NOTIFICATION, oldValue, this.currentValue);
            }
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getComboBoxControl(parent).setEnabled(enabled);
    }

    public void setFilter(ListDescriptorPropertyDescription.IListDescriptorPropertyFilter filter) {
        this.filter = filter;
    }

    public String[] getFilterPropertyNames() {
        return this.filter == null ? null : this.filter.getFilterPropertyNames();
    }

    public void performFiltering(String filterPropertyName, Object filterPropertyValue) {
        if (this.filter == null) {
            return;
        }
        this.filterProperties.put(filterPropertyName, filterPropertyValue);
        String[][] filteredNamesAndValues = this.getFilteredNamesAndValues();
        this.combo.removeAll();
        int i = 0;
        while (i < filteredNamesAndValues.length) {
            this.combo.add(filteredNamesAndValues[i][0], i);
            ++i;
        }
        this.updateComboForValue(this.currentValue, true);
    }

    private String[][] getFilteredNamesAndValues() {
        if (this.filter == null) {
            return this.namesAndValues;
        }
        return this.filter.filterNamesAndValues(this.filterProperties, this.namesAndValues);
    }
}

