/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.uei;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.mtj.core.launching.LaunchEnvironment;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.sdk.device.AbstractMIDPDevice;
import org.eclipse.mtj.internal.core.sdk.device.LaunchTemplateProperties;
import org.eclipse.mtj.internal.core.util.ReplaceableParametersProcessor;

public class UEIDevice
extends AbstractMIDPDevice
implements IMIDPDevice {
    private static final String EXE_EXT = ".exe";

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof UEIDevice) {
            equals = this.equals((UEIDevice)((Object)obj));
        }
        return equals;
    }

    public boolean equals(UEIDevice device) {
        return super.equals((AbstractMIDPDevice)device) && this.launchCommandTemplate.equals(device.launchCommandTemplate);
    }

    public String getLaunchCommand(LaunchEnvironment launchEnvironment, IProgressMonitor monitor) throws CoreException {
        boolean useCmdShell;
        boolean isWin32 = Platform.getOS().equals("win32");
        String baseCommand = "";
        ILaunchConfiguration launchConfiguration = launchEnvironment.getLaunchConfiguration();
        boolean launchFromJAD = this.shouldDirectLaunchJAD(launchConfiguration);
        HashMap<String, String> executionProperties = new HashMap<String, String>();
        String command = this.executable.getAbsolutePath();
        boolean bl = useCmdShell = isWin32 && !command.toLowerCase().endsWith(EXE_EXT);
        if (useCmdShell) {
            command = this.executable.getName();
        }
        command = "\"" + command + "\"";
        executionProperties.put(LaunchTemplateProperties.EXECUTABLE.toString(), command);
        executionProperties.put(LaunchTemplateProperties.DEVICE.toString(), this.getName());
        if (launchEnvironment.isDebugLaunch()) {
            executionProperties.put(LaunchTemplateProperties.DEBUGPORT.toString(), Integer.toString(launchEnvironment.getDebugListenerPort()));
        }
        this.addLaunchConfigurationValue(executionProperties, LaunchTemplateProperties.VERBOSE.toString(), launchConfiguration, "mtj.verbosity_options");
        this.addLaunchConfigurationValue(executionProperties, LaunchTemplateProperties.HEAPSIZE.toString(), launchConfiguration, "mtj.heap_size");
        String securityDomainName = launchConfiguration.getAttribute("mtj.security_domain", "None");
        if (!securityDomainName.equals("None")) {
            executionProperties.put(LaunchTemplateProperties.SECURITYDOMAIN.toString(), securityDomainName);
        }
        String extraArguments = launchConfiguration.getAttribute("mtj.launch_params", "");
        executionProperties.put(LaunchTemplateProperties.USERSPECIFIEDARGUMENTS.toString(), extraArguments);
        if (launchFromJAD) {
            executionProperties.put(LaunchTemplateProperties.JADFILE.toString(), this.getSpecifiedJadURL(launchConfiguration));
        } else if (launchEnvironment.getProject() instanceof IMidletSuiteProject) {
            IMidletSuiteProject midletSuite = (IMidletSuiteProject)launchEnvironment.getProject();
            File deployedTemp = this.copyForLaunch(midletSuite, monitor, launchFromJAD);
            String classpathString = this.getProjectClasspathString(launchEnvironment.getProject(), deployedTemp, monitor);
            executionProperties.put(LaunchTemplateProperties.CLASSPATH.toString(), classpathString);
            if (this.shouldDoOTA(launchConfiguration)) {
                String url = this.getOTAURL(launchConfiguration, midletSuite);
                executionProperties.put(LaunchTemplateProperties.OTAURL.toString(), url);
            } else {
                File jadFile = this.getJadForLaunch(midletSuite, deployedTemp, monitor);
                if (jadFile.exists()) {
                    executionProperties.put(LaunchTemplateProperties.JADFILE.toString(), jadFile.toString());
                }
                this.addLaunchConfigurationValue(executionProperties, LaunchTemplateProperties.TARGET.toString(), launchConfiguration, IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME);
            }
        }
        baseCommand = ReplaceableParametersProcessor.processReplaceableValues((String)this.launchCommandTemplate, executionProperties);
        return useCmdShell ? "cmd /c " + baseCommand : baseCommand;
    }

    public File getWorkingDirectory() {
        return this.executable.getParentFile();
    }

    public int hashCode() {
        return this.deviceClasspath.hashCode() ^ this.executable.hashCode() ^ this.name.hashCode() ^ this.launchCommandTemplate.hashCode() ^ this.groupName.hashCode();
    }
}

