/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.uei;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.internal.core.util.ColonDelimitedProperties;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.toolkit.uei.EmulatorInfoArgs;

public class UEIPropertiesReader {
    private static UEIPropertiesReader instance = null;
    private static final Pattern VALID_VERSION_PATTERN = Pattern.compile("^Profile:\\s.*|^Configuration:\\s.*", 8);

    public static synchronized UEIPropertiesReader getInstance() {
        if (instance == null) {
            instance = new UEIPropertiesReader();
        }
        return instance;
    }

    public Properties getUEIProperties(File emulatorExecutable) throws CoreException {
        Properties properties = null;
        try {
            properties = this.getUEIPropertiesFromEmulator(emulatorExecutable);
        }
        catch (IOException e) {
            MTJStatusHandler.throwCoreException((int)4, (int)-9999, (Throwable)e);
        }
        return properties;
    }

    private String getStandardOutput(String name, File executable, String[] arguments) throws CoreException {
        boolean isWin32 = Platform.getOS().equals("win32");
        File workingDirectory = executable.getParentFile();
        String exeName = isWin32 ? executable.getName() : executable.getAbsolutePath();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(arguments));
        list.add(0, exeName);
        if (isWin32) {
            list.add(0, "/c");
            list.add(0, "cmd");
        }
        String[] commandLine = list.toArray(new String[list.size()]);
        return Utils.getStandardOutput((String)name, (String[])commandLine, (File)workingDirectory);
    }

    private String getToolkitName(String versionInformation) throws IOException {
        String toolkitName = null;
        BufferedReader reader = new BufferedReader(new StringReader(versionInformation));
        toolkitName = reader.readLine();
        if (toolkitName == null) {
            toolkitName = "Generic UEI Toolkit";
        }
        return toolkitName;
    }

    private Properties getUEIPropertiesFromEmulator(File emulatorExecutable) throws CoreException, IOException {
        Properties ueiProperties = null;
        if (Utils.executableExists((File)emulatorExecutable)) {
            String versionString = this.getUEIVersionInformation(emulatorExecutable);
            Matcher matcher = VALID_VERSION_PATTERN.matcher(versionString);
            if (matcher.find()) {
                String output = this.getStandardOutput("UEI Emulator Query", emulatorExecutable, new String[]{EmulatorInfoArgs.XQUERY.toString()});
                ueiProperties = this.parseUEIPropertiesString(output);
                String toolkitName = this.getToolkitName(versionString);
                if (toolkitName != null && toolkitName.length() > 0) {
                    ueiProperties.setProperty("org.eclipse.mtj.toolkit.name", toolkitName);
                }
            }
        } else {
            ueiProperties = new Properties();
        }
        return ueiProperties;
    }

    private String getUEIVersionInformation(File executable) throws CoreException {
        return this.getStandardOutput("UEI Emulator Version", executable, new String[]{EmulatorInfoArgs.VERSION.toString()});
    }

    private Properties parseUEIPropertiesString(String contents) throws IOException {
        ColonDelimitedProperties props = new ColonDelimitedProperties();
        StringReader reader = new StringReader(contents);
        try {
            props.load((Reader)reader);
        }
        catch (Exception e) {
            MTJLogger.log((int)2, (String)"Error parsing UEI properties", (Throwable)e);
            MTJLogger.log((int)2, (String)contents);
        }
        return props;
    }
}

