/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.mtj.internal.core.build.IBuildConsoleProxy;

public class BuildConsoleProxy
implements IBuildConsoleProxy {
    private static final BuildConsoleProxy instance = new BuildConsoleProxy();
    private static NullOutputStream nullStream = new NullOutputStream();
    private IBuildConsoleProxy proxy;
    private PrintWriter traceWriter;

    public static synchronized BuildConsoleProxy getInstance() {
        return instance;
    }

    private BuildConsoleProxy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsoleStreamListener(IBuildConsoleProxy.Stream id, IStreamMonitor monitor) {
        final PrintWriter writer = this.getConsoleWriter(id);
        IStreamListener listener = new IStreamListener(){

            public void streamAppended(String text, IStreamMonitor monitor) {
                writer.print(text);
                writer.flush();
            }
        };
        IStreamMonitor iStreamMonitor = monitor;
        synchronized (iStreamMonitor) {
            String collected = monitor.getContents();
            if (collected != null) {
                listener.streamAppended(collected, monitor);
            }
            monitor.addListener(listener);
        }
        writer.print(monitor.getContents());
        writer.flush();
    }

    public PrintWriter getConsoleWriter(IBuildConsoleProxy.Stream id) {
        return this.proxy == null ? new PrintWriter(nullStream) : this.proxy.getConsoleWriter(id);
    }

    public void setProxy(IBuildConsoleProxy proxy) {
        this.proxy = proxy;
        this.traceWriter = null;
    }

    public void trace(String text) {
        if (this.traceWriter == null) {
            this.traceWriter = this.getConsoleWriter(IBuildConsoleProxy.Stream.TRACE);
        }
        this.traceWriter.print(text);
        this.traceWriter.flush();
    }

    public void traceln(String text) {
        this.trace(String.valueOf(text) + "\n");
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int arg0) throws IOException {
        }
    }
}

