/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.build.MTJBuildPropertiesChangeListener;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJBuildProperties
extends Properties {
    public static final String FILE_NAME = "build.properties";
    private static final long serialVersionUID = -3576616481147533654L;
    private static Map<IMTJProject, MTJBuildProperties> map;
    private Map<MTJRuntime, RuntimeBuildProperties> runtimeProperties;
    private List<MTJBuildPropertiesChangeListener> listeners;
    private IMTJProject mtjProject;
    private Object mutex;

    public static synchronized MTJBuildProperties getBuildProperties(IMTJProject mtjProject) {
        MTJBuildProperties buildProperties;
        if (map == null) {
            map = new HashMap<IMTJProject, MTJBuildProperties>();
        }
        if ((buildProperties = map.get(mtjProject)) == null) {
            buildProperties = new MTJBuildProperties(mtjProject);
            map.put(mtjProject, buildProperties);
        }
        return buildProperties;
    }

    private MTJBuildProperties(IMTJProject _mtjProject) {
        if (_mtjProject == null) {
            throw new IllegalArgumentException(Messages.MTJBuildProperties_invalidMTJProject);
        }
        this.listeners = new ArrayList<MTJBuildPropertiesChangeListener>();
        this.mtjProject = _mtjProject;
        this.mutex = new Object();
        this.runtimeProperties = new HashMap<MTJRuntime, RuntimeBuildProperties>();
        for (MTJRuntime runtime : this.mtjProject.getRuntimeList()) {
            RuntimeBuildProperties runtimeProperties = new RuntimeBuildProperties();
            this.runtimeProperties.put(runtime, runtimeProperties);
        }
        this.loadFromFile();
    }

    public void load() {
        this.loadFromFile();
        this.notifyListeners();
    }

    private synchronized void loadFromFile() {
        IFile file = this.getBuildPropertyFile();
        if (file.exists()) {
            try {
                FileInputStream in = new FileInputStream(file.getLocation().toOSString());
                try {
                    this.doLoad(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                MTJLogger.log(4, e);
            }
        }
    }

    private void doLoad(InputStream inputStream) throws IOException {
        super.load(inputStream);
        MTJRuntimeList runtimeList = this.mtjProject.getRuntimeList();
        for (MTJRuntime runtime : runtimeList) {
            String includes = this.getProperty(NLS.bind((String)"{0}.includes", (Object)runtime.getName()));
            String excludes = this.getProperty(NLS.bind((String)"{0}.excludes", (Object)runtime.getName()));
            RuntimeBuildProperties runtimeProperties = this.runtimeProperties.get(runtime);
            if (runtimeProperties == null) continue;
            runtimeProperties.clear();
            if (includes == null && excludes == null) {
                this.includeDefaultResources(runtimeProperties.includes);
                continue;
            }
            this.parseResourcesList(runtimeProperties.includes, includes);
            this.parseResourcesList(runtimeProperties.excludes, excludes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertiesChangeListener(MTJBuildPropertiesChangeListener listener) {
        List<MTJBuildPropertiesChangeListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertiesChangeListener(MTJBuildPropertiesChangeListener listener) {
        List<MTJBuildPropertiesChangeListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(listener)) {
                this.listeners.remove(listener);
            }
        }
    }

    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        throw new IllegalAccessError(Messages.MTJBuildProperties_invalidMethodAccess);
    }

    @Override
    public synchronized void load(Reader reader) throws IOException {
        throw new IllegalAccessError(Messages.MTJBuildProperties_invalidMethodAccess);
    }

    @Override
    public synchronized void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        throw new IllegalAccessError(Messages.MTJBuildProperties_invalidMethodAccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void includeDefaultResources(List<IResource> list) {
        Object object = this.mutex;
        synchronized (object) {
            list.clear();
            IResource[] sources = Utils.getSourceFolders(this.mtjProject.getJavaProject());
            try {
                list.addAll(Arrays.asList(sources));
            }
            catch (Exception e) {
                MTJLogger.log(4, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseResourcesList(List<IResource> list, String stringList) {
        if (stringList != null) {
            String separator = System.getProperty("line.separator");
            stringList = stringList.replaceAll(separator, "");
            Object object = this.mutex;
            synchronized (object) {
                String[] paths;
                IProject project = this.mtjProject.getProject();
                String[] stringArray = paths = stringList.split(",");
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    IResource resource = project.findMember(path);
                    if (resource != null) {
                        list.add(resource);
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public void store(Writer writer, String comments) throws IOException {
        PrintWriter printWriter = null;
        printWriter = !(writer instanceof PrintWriter) ? new PrintWriter(writer) : (PrintWriter)writer;
        try {
            this.writeProperties(printWriter, comments);
            printWriter.flush();
            printWriter.close();
        }
        finally {
            this.notifyListeners();
        }
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out));
        this.store(writer, comments);
    }

    public void store() throws IOException {
        IFile file = this.getBuildPropertyFile();
        PrintWriter printWriter = new PrintWriter(new FileWriter(file.getLocation().toFile()));
        try {
            this.store(printWriter, Messages.MTJBuildProperties_mtjBuildPropertiesComment);
        }
        finally {
            printWriter.close();
        }
        RefreshJob job = new RefreshJob("refresh build.properties", (IResource)file);
        job.schedule();
    }

    public IFile getBuildPropertyFile() {
        return this.mtjProject.getProject().getFile(FILE_NAME);
    }

    public IMTJProject getMTJProject() {
        return this.mtjProject;
    }

    public void setContent(InputStream stream) throws IOException {
        this.doLoad(stream);
    }

    public StringBuffer getContent() {
        StringWriter writer = new StringWriter();
        this.writeProperties(new PrintWriter(writer), null);
        return writer.getBuffer();
    }

    public void deleteResource(IResource _resource) {
        for (MTJRuntime runtime : this.mtjProject.getRuntimeList()) {
            RuntimeBuildProperties runtimeProperties = this.runtimeProperties.get(runtime);
            if (runtimeProperties == null) continue;
            this.removeResourceAndChildren(runtimeProperties.includes, _resource);
            this.removeResourceAndChildren(runtimeProperties.excludes, _resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeResourceAndChildren(List<IResource> list, IResource _resource) {
        ArrayList<IResource> removals = new ArrayList<IResource>();
        for (IResource resource : list) {
            IPath candidatePath = resource.getProjectRelativePath();
            IPath myPath = _resource.getProjectRelativePath();
            if (!myPath.isPrefixOf(candidatePath) && !myPath.equals((Object)candidatePath)) continue;
            removals.add(resource);
        }
        Object object = this.mutex;
        synchronized (object) {
            list.removeAll(removals);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void includeResource(IResource _resource, MTJRuntime _runtime) {
        RuntimeBuildProperties runtimeProperties = this.runtimeProperties.get(_runtime);
        if (runtimeProperties != null) {
            Object object = this.mutex;
            synchronized (object) {
                this.removeResourceAndChildren(runtimeProperties.excludes, _resource);
                this.removeResourceAndChildren(runtimeProperties.includes, _resource);
                if (!this.isResourceIncludedByParent(_resource, _runtime)) {
                    runtimeProperties.includes.add(_resource);
                }
            }
        }
    }

    private boolean isResourceIncludedByParent(IResource _resource, MTJRuntime _runtime) {
        RuntimeBuildProperties runtimeProperties = this.runtimeProperties.get(_runtime);
        if (runtimeProperties == null) {
            return false;
        }
        boolean result = false;
        IPath myPath = _resource.getFullPath();
        List<IResource> includes = runtimeProperties.includes;
        for (IResource include : includes) {
            IPath includePath = include.getFullPath();
            if (!includePath.isPrefixOf(myPath)) continue;
            result = true;
            List<IResource> excludes = runtimeProperties.excludes;
            for (IResource exclude : excludes) {
                IPath excludePath = exclude.getFullPath();
                if (!includePath.isPrefixOf(excludePath) || !excludePath.isPrefixOf(myPath)) continue;
                result = false;
                break;
            }
            if (result) break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void excludeResource(IResource _resource, MTJRuntime _runtime) {
        RuntimeBuildProperties runtimeProperties = this.runtimeProperties.get(_runtime);
        if (runtimeProperties != null) {
            Object object = this.mutex;
            synchronized (object) {
                this.removeResourceAndChildren(runtimeProperties.includes, _resource);
                this.removeResourceAndChildren(runtimeProperties.excludes, _resource);
                if (!this.isResourceExcludedByParent(_resource, _runtime)) {
                    runtimeProperties.excludes.add(_resource);
                }
            }
        }
    }

    private boolean isResourceExcludedByParent(IResource _resource, MTJRuntime _runtime) {
        RuntimeBuildProperties runtimeProperties = this.runtimeProperties.get(_runtime);
        if (runtimeProperties == null) {
            return false;
        }
        boolean result = false;
        IPath myPath = _resource.getFullPath();
        List<IResource> excludes = runtimeProperties.excludes;
        for (IResource exclude : excludes) {
            IPath excludePath = exclude.getFullPath();
            if (!excludePath.isPrefixOf(myPath)) continue;
            result = true;
            List<IResource> includes = runtimeProperties.includes;
            for (IResource include : includes) {
                IPath includePath = include.getFullPath();
                if (!excludePath.isPrefixOf(includePath) || !includePath.isPrefixOf(myPath)) continue;
                result = false;
                break;
            }
            if (result) break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResource[] getIncludes(MTJRuntime _runtime) {
        IResource[] result = new IResource[]{};
        RuntimeBuildProperties runtimeProperties = this.runtimeProperties.get(_runtime);
        if (runtimeProperties == null) {
            this.addRuntime(_runtime);
            runtimeProperties = this.runtimeProperties.get(_runtime);
        }
        Object object = this.mutex;
        synchronized (object) {
            result = runtimeProperties.includes.toArray(new IResource[0]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IResource[] getExcludes(MTJRuntime _runtime) {
        IResource[] result = new IResource[]{};
        RuntimeBuildProperties runtimeProperties = this.runtimeProperties.get(_runtime);
        if (runtimeProperties == null) {
            this.addRuntime(_runtime);
            runtimeProperties = this.runtimeProperties.get(_runtime);
        }
        Object object = this.mutex;
        synchronized (object) {
            result = runtimeProperties.excludes.toArray(new IResource[0]);
        }
        return result;
    }

    private void addRuntime(MTJRuntime _runtime) {
        RuntimeBuildProperties runtimeProperties = this.runtimeProperties.get(_runtime);
        if (runtimeProperties == null) {
            runtimeProperties = new RuntimeBuildProperties();
            this.includeDefaultResources(runtimeProperties.includes);
            this.runtimeProperties.put(_runtime, runtimeProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProperties(PrintWriter printWriter, String comments) {
        printWriter.println(comments == null ? Messages.MTJBuildProperties_mtjBuildPropertiesComment : comments);
        Object object = this.mutex;
        synchronized (object) {
            for (MTJRuntime runtime : this.mtjProject.getRuntimeList()) {
                RuntimeBuildProperties runtimeProperties = this.runtimeProperties.get(runtime);
                if (runtimeProperties == null) continue;
                String key = null;
                String value = null;
                key = NLS.bind((String)"{0}.includes", (Object)runtime.getName());
                value = this.format(this.getResourcesString(runtimeProperties.includes));
                printWriter.println(NLS.bind((String)"{0}={1}", (Object[])new String[]{key, value}));
                key = NLS.bind((String)"{0}.excludes", (Object)runtime.getName());
                value = this.format(this.getResourcesString(runtimeProperties.excludes));
                printWriter.println(NLS.bind((String)"{0}={1}", (Object[])new String[]{key, value}));
            }
        }
    }

    private String format(String value) {
        String separator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        if (value != null) {
            String[] values;
            String[] stringArray = values = value.split(",");
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                if (buffer.length() > 0) {
                    buffer.append(",");
                }
                buffer.append(NLS.bind((String)"{0}\\{1}", (Object[])new String[]{path, separator}));
                ++n2;
            }
        }
        return buffer.toString();
    }

    private String getResourcesString(List<IResource> list) {
        StringBuffer buffer = new StringBuffer();
        for (IResource resource : list) {
            String path = resource.getProjectRelativePath().toString();
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(path);
        }
        return buffer.toString();
    }

    private void notifyListeners() {
        for (MTJBuildPropertiesChangeListener listener : this.listeners) {
            listener.propertiesChanged(this);
        }
    }

    private class RefreshJob
    extends WorkspaceJob {
        private IResource file;

        public RefreshJob(String name, IResource file) {
            super(name);
            this.file = file;
            this.setSystem(true);
            this.setUser(false);
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            if (this.file != null) {
                this.file.refreshLocal(0, monitor);
            }
            return Status.OK_STATUS;
        }
    }

    private class RuntimeBuildProperties {
        List<IResource> includes = new ArrayList<IResource>();
        List<IResource> excludes = new ArrayList<IResource>();

        public void clear() {
            this.includes.clear();
            this.excludes.clear();
        }
    }
}

