/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.export.states;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.symbol.ISymbol;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.build.export.AntennaExportException;
import org.eclipse.mtj.internal.core.build.export.states.AbstractCreateAntTaskState;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.statemachine.StateMachine;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateAntPreprocessTaskState
extends AbstractCreateAntTaskState {
    public CreateAntPreprocessTaskState(StateMachine _stateMachine, IMidletSuiteProject _suiteProject, Document _document, String buildFolder, String buildFile) {
        super(_stateMachine, _suiteProject, _document, buildFolder, buildFile);
    }

    protected void onEnter(MTJRuntime runtime) throws AntennaExportException {
        Document document = this.getDocument();
        Element root = document.getDocumentElement();
        IProject project = this.getMidletSuiteProject().getProject();
        String configName = this.getFormatedName(runtime.getName());
        Element preprocess = XMLUtils.createTargetElement(document, root, NLS.bind((String)"preprocess-{0}", (Object)configName), this.getDependencies(runtime));
        try {
            ISymbolSet symbolset = runtime.getSymbolSetForPreprocessing();
            List<ISymbolSet> sets = runtime.getWorkspaceScopeSymbolSets();
            if (sets != null && !sets.isEmpty()) {
                for (ISymbolSet set : sets) {
                    symbolset.add(set.getSymbols());
                }
            }
            IFile symbolSetFile = this.createSymbolSetFile(configName, symbolset);
            this.writePreprocessTask(project, document, preprocess, runtime, symbolSetFile);
            Set<IProject> requiredProjects = this.getRequiredProjects(project);
            if (requiredProjects.size() > 0) {
                for (IProject required : requiredProjects) {
                    this.writePreprocessTask(required, document, preprocess, runtime, symbolSetFile);
                }
                Element copy = document.createElement("copy");
                preprocess.appendChild(copy);
                copy.setAttribute("overwrite", "true");
                copy.setAttribute("todir", NLS.bind((String)"{0}/{1}/{2}/classes/", (Object[])new String[]{this.getBuildFolder(), configName, this.getFormatedName(project.getName())}));
                for (IProject required : requiredProjects) {
                    Element fileset = document.createElement("fileset");
                    copy.appendChild(fileset);
                    fileset.setAttribute("dir", NLS.bind((String)"{0}/{1}/{2}/classes/", (Object[])new String[]{this.getBuildFolder(), configName, this.getFormatedName(required.getName())}));
                }
            }
        }
        catch (IOException e) {
            throw new AntennaExportException(e, Messages.CreateAntPreprocessTaskState_UnableToCreateSymbolSet);
        }
    }

    private void writePreprocessTask(IProject _project, Document _document, Element _root, MTJRuntime _runtime, IFile _symbolSetFile) throws AntennaExportException {
        IResource[] sources;
        IJavaProject javaProject = JavaCore.create((IProject)_project);
        if (javaProject == null) {
            return;
        }
        IMidletSuiteProject suiteProject = MidletSuiteFactory.getMidletSuiteProject(javaProject);
        if (suiteProject == null) {
            return;
        }
        String configName = this.getFormatedName(_runtime.getName());
        IResource[] iResourceArray = sources = Utils.getSourceFolders(suiteProject.getJavaProject());
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource source = iResourceArray[n2];
            Element wtkpreprocess = _document.createElement("wtkpreprocess");
            _root.appendChild(wtkpreprocess);
            wtkpreprocess.setAttribute("debuglevel", "info");
            wtkpreprocess.setAttribute("verbose", "true");
            wtkpreprocess.setAttribute("printsymbols", "true");
            wtkpreprocess.setAttribute("srcdir", NLS.bind((String)"..{0}", (Object)source.getFullPath()));
            wtkpreprocess.setAttribute("destdir", NLS.bind((String)"{0}/{1}/{2}/classes/", (Object[])new String[]{this.getBuildFolder(), configName, this.getFormatedName(_project.getName())}));
            Element symbolsFile = _document.createElement("symbols_file");
            symbolsFile.setAttribute("name", NLS.bind((String)"{0}/{1}/", (Object[])new String[]{"${basedir}", _symbolSetFile.getProjectRelativePath().toString()}));
            wtkpreprocess.appendChild(symbolsFile);
            ++n2;
        }
    }

    private IFile createSymbolSetFile(String configName, ISymbolSet symbolset) throws IOException {
        StringBuffer buffer = new StringBuffer();
        for (ISymbol symbol : symbolset.getSymbols()) {
            buffer.append(NLS.bind((String)"{0}={1}\n", (Object[])new String[]{symbol.getName(), symbol.getSafeValue()}));
        }
        IProject project = this.getMidletSuiteProject().getProject();
        IFile file = project.getFile(NLS.bind((String)"mtj-build/{0}.symbols", (Object)configName));
        File symbols = file.getLocation().toFile();
        FileOutputStream stream = new FileOutputStream(symbols);
        stream.write(buffer.toString().getBytes());
        stream.flush();
        stream.close();
        return file;
    }
}

