/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.preverifier.builder;

import de.schlichtherle.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.build.packaging.PackageBuilder;
import org.eclipse.mtj.internal.core.build.preverifier.builder.SourceResourcesFilter;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.text.IResourceFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BuildInfo {
    private int buildKind;
    private Map<?, ?> buildArgs;
    private IMidletSuiteProject midletSuite;
    private IMidletSuiteProject targetMidletSuite;
    private IJavaProject baseJavaProject;
    private IJavaProject currentJavaProject;
    private IPath[] outputFolders;
    private IResourceDelta currentResourceDelta;
    private IResourceFilter resourceFilter;
    private boolean packageDirty;
    private boolean classpathChanged;
    private Set<File> preverifiedLibraries;

    BuildInfo(int kind, Map<?, ?> args, IJavaProject baseJavaProject) throws JavaModelException {
        this.buildKind = kind;
        this.buildArgs = args;
        this.baseJavaProject = baseJavaProject;
        this.midletSuite = MidletSuiteFactory.getMidletSuiteProject(baseJavaProject);
        this.classpathChanged = false;
        this.preverifiedLibraries = new HashSet<File>();
        this.setCurrentJavaProject(baseJavaProject);
    }

    public void addPreverifiedLibrary(File libraryFile) {
        this.preverifiedLibraries.add(libraryFile);
    }

    public boolean areClassesPreverified() {
        boolean preverify = true;
        String stringValue = (String)this.buildArgs.get("preverifyClasses");
        if (stringValue != null && stringValue.equals("false")) {
            preverify = false;
        }
        return preverify;
    }

    public boolean areLibrariesPreverified() {
        boolean preverify = true;
        String stringValue = (String)this.buildArgs.get("preverifyLibraries");
        if (stringValue != null && stringValue.equals("false")) {
            preverify = false;
        }
        return preverify;
    }

    public IJavaProject getBaseJavaProject() {
        return this.baseJavaProject;
    }

    public Map<?, ?> getBuildArgs() {
        return this.buildArgs;
    }

    public int getBuildKind() {
        return this.buildKind;
    }

    public IJavaProject getCurrentJavaProject() {
        return this.currentJavaProject;
    }

    public IResourceDelta getCurrentResourceDelta() {
        return this.buildKind == 6 ? null : this.currentResourceDelta;
    }

    public IMidletSuiteProject getMidletSuite() {
        return this.midletSuite;
    }

    public IResourceFilter getResourceFilter() {
        return this.resourceFilter;
    }

    public IMidletSuiteProject getTargetMidletSuite() {
        if (this.targetMidletSuite == null) {
            String targetProjectName = (String)this.buildArgs.get("preverifyTargetProject");
            if (targetProjectName == null) {
                this.targetMidletSuite = this.midletSuite;
            } else {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(targetProjectName);
                IJavaProject javaProject = JavaCore.create((IProject)project);
                this.targetMidletSuite = MidletSuiteFactory.getMidletSuiteProject(javaProject);
            }
        }
        return this.targetMidletSuite;
    }

    public boolean isCurrentProjectMidletSuite() {
        return this.currentJavaProject.equals(this.baseJavaProject);
    }

    IFolder getVerifiedClassesFolder(IProgressMonitor monitor) throws CoreException {
        IFolder verifiedClassesFolder = null;
        IMidletSuiteProject current = null;
        IMidletSuiteProject target = null;
        current = MidletSuiteFactory.getMidletSuiteProject(this.currentJavaProject);
        target = MidletSuiteFactory.getMidletSuiteProject(this.baseJavaProject);
        if (current.getProject() == target.getProject()) {
            verifiedClassesFolder = target.getVerifiedClassesOutputFolder(monitor);
        } else {
            IFolder verifiedFolder = target.getVerifiedOutputFolder(monitor);
            verifiedClassesFolder = verifiedFolder.getFolder("required-classes");
        }
        PackageBuilder.createFolders(verifiedClassesFolder, monitor);
        return verifiedClassesFolder;
    }

    IFolder getVerifiedLibsFolder(IProgressMonitor monitor) throws CoreException {
        IFolder verifiedLibrariesFolder = null;
        IMidletSuiteProject current = null;
        IMidletSuiteProject target = null;
        current = MidletSuiteFactory.getMidletSuiteProject(this.currentJavaProject);
        target = MidletSuiteFactory.getMidletSuiteProject(this.baseJavaProject);
        if (current.getProject() == target.getProject()) {
            verifiedLibrariesFolder = target.getVerifiedLibrariesOutputFolder(monitor);
        } else {
            IFolder verifiedFolder = target.getVerifiedOutputFolder(monitor);
            verifiedLibrariesFolder = verifiedFolder.getFolder("required-libs");
        }
        PackageBuilder.createFolders(verifiedLibrariesFolder, monitor);
        return verifiedLibrariesFolder;
    }

    boolean isCurrentProjectTheBaseProject() {
        return this.currentJavaProject.equals(this.baseJavaProject);
    }

    boolean isOutputResource(IResource resource) {
        boolean isOutput = false;
        IPath resourcePath = resource.getFullPath();
        int i = 0;
        while (i < this.outputFolders.length) {
            IPath outputPath = this.outputFolders[i];
            if (outputPath.isPrefixOf(resourcePath)) {
                isOutput = true;
                break;
            }
            ++i;
        }
        return isOutput;
    }

    public void setCurrentJavaProject(IJavaProject currentJavaProject) throws JavaModelException {
        this.currentJavaProject = currentJavaProject;
        this.resourceFilter = new SourceResourcesFilter(currentJavaProject);
        this.initializeOutputFolders(currentJavaProject);
    }

    public void setCurrentResourceDelta(IResourceDelta currentResourceDelta) {
        this.currentResourceDelta = currentResourceDelta;
    }

    public boolean hasLibraryBeenPreverified(File libraryFile) {
        return this.preverifiedLibraries.contains(libraryFile);
    }

    public boolean isBuildArgumentTrue(String argName) {
        Boolean value = (Boolean)this.getBuildArgs().get(argName);
        return value != null && value != false;
    }

    public boolean isClasspathChanged() {
        return this.classpathChanged;
    }

    protected boolean isPackageDirty() {
        return this.packageDirty;
    }

    public void setClasspathChanged(boolean classpathChanged) {
        this.classpathChanged = classpathChanged;
    }

    protected void setPackageDirty(boolean dirtyPackage) {
        this.packageDirty = dirtyPackage;
    }

    private void initializeOutputFolders(IJavaProject javaProject) throws JavaModelException {
        HashSet<IPath> outputFolderSet = new HashSet<IPath>();
        outputFolderSet.add(javaProject.getOutputLocation());
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IPath outputPath;
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 3 && (outputPath = entry.getOutputLocation()) != null) {
                outputFolderSet.add(outputPath);
            }
            ++i;
        }
        this.outputFolders = outputFolderSet.toArray(new IPath[outputFolderSet.size()]);
    }
}

