/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.build.sign;

import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mtj.core.build.sign.ISignatureProperties;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.build.sign.JadSignature;
import org.eclipse.mtj.internal.core.build.sign.KeyChainSet;
import org.eclipse.mtj.internal.core.build.sign.SignaturePasswords;
import org.eclipse.mtj.internal.core.project.midp.IJadSignature;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;

public class SignatureUtils {
    public static IJadSignature getSignatureObject(IMidletSuiteProject project) throws CoreException {
        ISignatureProperties sigProps = project.getSignatureProperties();
        return SignatureUtils.getSignatureObject(project, sigProps);
    }

    public static IJadSignature getSignatureObject(IMidletSuiteProject project, ISignatureProperties sigProps) throws CoreException {
        JadSignature sigObject;
        block27: {
            FileInputStream fis;
            block26: {
                if (!sigProps.isSignProject()) {
                    return null;
                }
                if (sigProps.getAbsoluteKeyStorePath(project.getProject()) == null) {
                    MTJLogger.log(4, Messages.SignatureUtils_noKeystoreConfigured);
                    return null;
                }
                if (sigProps.getKeyAlias() == null) {
                    MTJLogger.log(4, Messages.SignatureUtils_noAliasSelected);
                    return null;
                }
                sigObject = null;
                fis = null;
                String strKeyStorePass = null;
                String strKeyPass = null;
                switch (sigProps.getPasswordStorageMethod()) {
                    case 1: 
                    case 2: {
                        strKeyStorePass = sigProps.getKeyStorePassword();
                        strKeyPass = sigProps.getKeyPassword();
                        break;
                    }
                    default: {
                        if (project == null) break;
                        strKeyStorePass = project.getTempKeystorePassword();
                        strKeyPass = project.getTempKeyPassword();
                    }
                }
                boolean bPromptedForPasswords = false;
                if (strKeyStorePass == null || strKeyPass == null) {
                    Status status = new Status(1, "org.eclipse.mtj.core", 103, Messages.SignatureUtils_passwordDialogTitle, null);
                    SignaturePasswords passwords = (SignaturePasswords)MTJStatusHandler.statusPrompt((IStatus)status, new Object[]{project.getProject(), strKeyStorePass, strKeyPass});
                    if (passwords == null) {
                        return null;
                    }
                    strKeyStorePass = passwords.getKeystorePassword();
                    strKeyPass = passwords.getKeyPassword();
                    bPromptedForPasswords = true;
                }
                try {
                    try {
                        fis = new FileInputStream(sigProps.getAbsoluteKeyStorePath(project.getProject()));
                        KeyChainSet set = KeyChainSet.getInstance(fis, sigProps.getKeyStoreType(), sigProps.getKeyStoreProvider(), strKeyStorePass, sigProps.getKeyAlias(), strKeyPass);
                        sigObject = new JadSignature(set);
                        sigObject.checkKeyChainSet();
                        if (!bPromptedForPasswords) break block26;
                        switch (sigProps.getPasswordStorageMethod()) {
                            case 1: 
                            case 2: {
                                sigProps.setKeyPassword(strKeyPass);
                                sigProps.setKeyStorePassword(strKeyStorePass);
                                if (project != null) {
                                    project.saveMetaData();
                                }
                                break;
                            }
                            default: {
                                if (project != null) {
                                    project.setTempKeystorePassword(strKeyStorePass);
                                    project.setTempKeyPassword(strKeyPass);
                                }
                                break;
                            }
                        }
                    }
                    catch (IOException ioe) {
                        MTJStatusHandler.throwCoreException(4, 99999, ioe);
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (Exception exception) {}
                        }
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        return sigObject;
    }
}

