/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.externallibrary.manager;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.internal.core.externallibrary.model.IExternalLibrary;
import org.eclipse.mtj.internal.core.externallibrary.model.MidletExternalLibrary;
import org.eclipse.mtj.internal.core.util.MTJStatusHandler;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.osgi.util.NLS;

public class ExternalLibraryManager
implements IRegistryChangeListener {
    private static final String EXT_MIDLETLIBRARY = "externallibrary";
    private static ExternalLibraryManager LibraryManagerInstance;
    private Map<String, MidletExternalLibrary> midletLibraries;

    public static synchronized ExternalLibraryManager getInstance() {
        if (LibraryManagerInstance == null) {
            LibraryManagerInstance = new ExternalLibraryManager();
            Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)LibraryManagerInstance);
        }
        return LibraryManagerInstance;
    }

    private ExternalLibraryManager() {
        this.initialize();
    }

    public boolean addLibraryToMidletProject(IProject project, String libName) throws CoreException {
        IExternalLibrary library;
        if (!project.hasNature("org.eclipse.mtj.core.nature")) {
            String message = NLS.bind((String)"Project {0} must have a {1} nature.", (Object[])new String[]{project.getName(), "org.eclipse.mtj.core.nature"});
            MTJStatusHandler.throwCoreException(4, -999, message);
        }
        if ((library = this.getMidletLibrary(libName)) == null) {
            String message = NLS.bind((String)"ExternalLibraryManager does not contain a {0} library.", (Object)libName);
            MTJStatusHandler.throwCoreException(4, -999, message);
        }
        Path libPath = new Path("org.eclipse.mtj.core.EXTERNAL_LIBRARY" + File.separator + library.getName());
        IJavaProject javaProject = JavaCore.create((IProject)project);
        LinkedList<IClasspathEntry> entriesList = new LinkedList<IClasspathEntry>();
        entriesList.addAll(Arrays.asList(javaProject.getRawClasspath()));
        for (IClasspathEntry classpathEntry : entriesList) {
            if (!classpathEntry.getPath().equals((Object)libPath)) continue;
            return false;
        }
        try {
            entriesList.add(JavaCore.newContainerEntry((IPath)libPath, (boolean)true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        javaProject.setRawClasspath(null, (IProgressMonitor)new NullProgressMonitor());
        javaProject.setRawClasspath(entriesList.toArray(new IClasspathEntry[entriesList.size()]), (IProgressMonitor)new NullProgressMonitor());
        return true;
    }

    public synchronized IExternalLibrary getMidletLibrary(String libName) {
        return this.midletLibraries.get(libName);
    }

    public synchronized String[] getMidletLibraryNames() {
        Set<String> set = this.midletLibraries.keySet();
        return set.toArray(new String[set.size()]);
    }

    public boolean removeLibraryFromMidletProject(IProject project, String libName) throws CoreException {
        IExternalLibrary library;
        boolean result = false;
        if (!project.hasNature("org.eclipse.mtj.core.nature")) {
            String message = NLS.bind((String)"Project {0} must have a {1} nature.", (Object[])new String[]{project.getName(), "org.eclipse.mtj.core.nature"});
            MTJStatusHandler.throwCoreException(4, -999, message);
        }
        if ((library = this.getMidletLibrary(libName)) == null) {
            String message = NLS.bind((String)"ExternalLibraryManager does not contain a {0} library.", (Object)libName);
            MTJStatusHandler.throwCoreException(4, -999, message);
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        LinkedList<IClasspathEntry> entriesList = new LinkedList<IClasspathEntry>();
        entriesList.addAll(Arrays.asList(javaProject.getRawClasspath()));
        Path path = new Path("org.eclipse.mtj.core.EXTERNAL_LIBRARY" + File.separator + library.getName());
        for (IClasspathEntry classpathEntry : entriesList) {
            if (!classpathEntry.getPath().toString().equals(path.toString())) continue;
            entriesList.remove(classpathEntry);
            result = true;
            break;
        }
        javaProject.setRawClasspath(null, (IProgressMonitor)new NullProgressMonitor());
        javaProject.setRawClasspath(entriesList.toArray(new IClasspathEntry[entriesList.size()]), (IProgressMonitor)new NullProgressMonitor());
        return result;
    }

    private void initialize() {
        IConfigurationElement[] elements;
        this.midletLibraries = new HashMap<String, MidletExternalLibrary>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.mtj.core", EXT_MIDLETLIBRARY);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            MidletExternalLibrary midletLibrary = this.getMidletLibrary(element);
            if (midletLibrary != null) {
                this.midletLibraries.put(midletLibrary.getName(), midletLibrary);
            }
            ++n2;
        }
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.mtj.core", EXT_MIDLETLIBRARY);
        int i = 0;
        while (i < deltas.length) {
            IConfigurationElement element;
            int n;
            int n2;
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] elements;
            if (deltas[i].getKind() == 1) {
                iConfigurationElementArray = elements = deltas[i].getExtension().getConfigurationElements();
                n2 = elements.length;
                n = 0;
                while (n < n2) {
                    element = iConfigurationElementArray[n];
                    MidletExternalLibrary midletLibrary = this.getMidletLibrary(element);
                    if (midletLibrary != null) {
                        this.midletLibraries.put(midletLibrary.getName(), midletLibrary);
                    }
                    ++n;
                }
            } else {
                iConfigurationElementArray = elements = deltas[i].getExtension().getConfigurationElements();
                n2 = elements.length;
                n = 0;
                while (n < n2) {
                    element = iConfigurationElementArray[n];
                    String midletLibraryName = MidletExternalLibrary.getMidletLibraryName(element);
                    if (midletLibraryName != null) {
                        this.midletLibraries.remove(midletLibraryName);
                    }
                    ++n;
                }
            }
            ++i;
        }
    }

    private MidletExternalLibrary getMidletLibrary(IConfigurationElement element) {
        MidletExternalLibrary midletLibrary = null;
        try {
            midletLibrary = new MidletExternalLibrary(element);
        }
        catch (Throwable e) {
            MTJLogger.log(4, "Failed to load MidletExternalLibrary", e);
        }
        return midletLibrary;
    }
}

