/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.persistence;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.IBundleReferencePersistable;
import org.eclipse.mtj.core.persistence.IPersistable;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPersistenceProvider
implements IPersistenceProvider {
    private Map<String, String> bundleMappings;
    private Stack<Bundle> bundleStack;
    private Element element;
    private int identifier;
    private Map<Object, Object> referenceMap;

    private static Element createRootElement(String elementName) throws PersistenceException {
        String pluginVersion = MTJCore.getMTJCoreVersion();
        Version version = new Version(pluginVersion);
        Element element = null;
        try {
            element = XMLUtils.createRootElement(elementName, version);
        }
        catch (ParserConfigurationException e) {
            throw new PersistenceException(e.getMessage(), e);
        }
        return element;
    }

    public XMLPersistenceProvider(Document document) {
        this(document.getDocumentElement());
    }

    public XMLPersistenceProvider(Element rootElement) {
        this.element = rootElement;
        this.bundleStack = new Stack();
        this.referenceMap = new HashMap<Object, Object>();
        this.bundleMappings = new HashMap<String, String>();
        this.bundleMappings.put("org.eclipse.mtj.toolkit.nokia", "org.eclipse.mtj.toolkit.uei");
        this.bundleMappings.put("org.eclipse.mtj.toolkit.sonyericsson", "org.eclipse.mtj.toolkit.uei");
        this.bundleMappings.put("org.eclipse.mtj.toolkit.sprint", "org.eclipse.mtj.toolkit.uei");
        this.bundleMappings.put("org.eclipse.mtj.toolkit.sun", "org.eclipse.mtj.toolkit.uei");
    }

    public XMLPersistenceProvider(String rootElementName) throws PersistenceException {
        this(XMLPersistenceProvider.createRootElement(rootElementName));
    }

    public Document getDocument() {
        return this.element.getOwnerDocument();
    }

    @Override
    public boolean loadBoolean(String name) throws PersistenceException {
        String value = this.loadString(name);
        return value == null ? false : Boolean.TRUE.toString().equalsIgnoreCase(value);
    }

    @Override
    public int loadInteger(String name) throws PersistenceException {
        String value = this.loadString(name);
        int integer = 0;
        try {
            integer = value == null ? 0 : Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {}
        return integer;
    }

    @Override
    public IPersistable loadPersistable(String name) throws PersistenceException {
        IPersistable persistable = null;
        Element persistableElement = this.getNamedElement(name);
        if (persistableElement != null) {
            boolean pushedNewBundle = this.pushNewBundle(persistableElement);
            persistable = this.createPersistableInstance(persistableElement);
            if (persistable != null) {
                Bundle bundle;
                this.element = persistableElement;
                if (persistable instanceof IBundleReferencePersistable && (bundle = this.getCurrentBundle()) != null) {
                    IBundleReferencePersistable bundlePersistable = (IBundleReferencePersistable)persistable;
                    bundlePersistable.setBundle(bundle.getSymbolicName());
                }
                persistable.loadUsing(this);
                String idString = persistableElement.getAttribute("id");
                Integer id = 0;
                if (!idString.equals("")) {
                    try {
                        id = Integer.valueOf(idString);
                    }
                    catch (NumberFormatException nfe) {
                        MTJLogger.log(2, NLS.bind((String)Messages.XMLPersistenceProvider_8, (Object)name), nfe);
                        Random random = new Random(System.currentTimeMillis());
                        id = random.nextInt();
                    }
                } else {
                    Random random = new Random(System.currentTimeMillis());
                    id = random.nextInt();
                }
                this.referenceMap.put(id, persistable);
                this.element = (Element)this.element.getParentNode();
            }
            if (pushedNewBundle && !this.bundleStack.isEmpty()) {
                this.bundleStack.pop();
            }
        }
        return persistable;
    }

    @Override
    public Properties loadProperties(String name) throws PersistenceException {
        Properties properties = null;
        Element namedElement = this.getNamedElement(name);
        if (namedElement != null) {
            properties = new Properties();
            NodeList propertyElements = namedElement.getElementsByTagName("property");
            int i = 0;
            while (i < propertyElements.getLength()) {
                Element propertyElement = (Element)propertyElements.item(i);
                String key = propertyElement.getAttribute("key");
                String value = propertyElement.getAttribute("value");
                properties.setProperty(key, value);
                ++i;
            }
        }
        return properties;
    }

    @Override
    public Object loadReference(String name) throws PersistenceException {
        Object object = null;
        Element namedElement = this.getNamedElement(name);
        if (namedElement != null) {
            try {
                String refidString = namedElement.getAttribute("refid");
                Integer refid = Integer.valueOf(refidString);
                object = this.referenceMap.get(refid);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return object;
    }

    @Override
    public String loadString(String name) throws PersistenceException {
        Element namedElement = this.getNamedElement(name);
        return namedElement == null ? null : namedElement.getAttribute("value");
    }

    @Override
    public void storeBoolean(String name, boolean value) throws PersistenceException {
        this.storeString(name, Boolean.toString(value));
    }

    @Override
    public void storeInteger(String name, int value) throws PersistenceException {
        this.storeString(name, Integer.toString(value));
    }

    @Override
    public void storePersistable(String name, IPersistable value) throws PersistenceException {
        if (value != null) {
            String bundle;
            this.element = XMLUtils.createChild(this.element, name);
            if (value instanceof IBundleReferencePersistable && (bundle = ((IBundleReferencePersistable)value).getBundle()) != null) {
                this.element.setAttribute("bundle", bundle);
            }
            this.element.setAttribute("class", value.getClass().getName());
            Integer id = this.identifier++;
            this.element.setAttribute("id", id.toString());
            this.referenceMap.put(value, id);
            value.storeUsing(this);
            this.element = (Element)this.element.getParentNode();
        }
    }

    @Override
    public void storeProperties(String name, Properties properties) throws PersistenceException {
        if (properties != null) {
            Element propertiesElement = XMLUtils.createChild(this.element, name);
            Iterator<Map.Entry<Object, Object>> entries = properties.entrySet().iterator();
            while (entries.hasNext()) {
                Element propertyElement = XMLUtils.createChild(propertiesElement, "property");
                Map.Entry<Object, Object> entry = entries.next();
                propertyElement.setAttribute("key", entry.getKey().toString());
                propertyElement.setAttribute("value", entry.getValue().toString());
            }
        }
    }

    @Override
    public void storeReference(String name, Object referenceObject) throws PersistenceException {
        Integer refid = (Integer)this.referenceMap.get(referenceObject);
        if (refid != null) {
            Element newElement = XMLUtils.createChild(this.element, name);
            newElement.setAttribute("refid", refid.toString());
        }
    }

    @Override
    public void storeString(String name, String value) throws PersistenceException {
        if (value != null) {
            try {
                Element newElement = XMLUtils.createChild(this.element, name);
                if (newElement == null) {
                    throw new PersistenceException(Messages.XMLPersistenceProvider_1);
                }
                newElement.setAttribute("value", value);
            }
            catch (DOMException e) {
                throw new PersistenceException(Messages.XMLPersistenceProvider_0, e);
            }
        }
    }

    private IPersistable createPersistableInstance(Element persistableElement) throws PersistenceException {
        IPersistable persistable = null;
        String className = persistableElement.getAttribute("class");
        String bunbleName = persistableElement.getAttribute("bundle");
        try {
            Class<?> clazz = this.loadClass(bunbleName, className);
            if (clazz != null) {
                persistable = (IPersistable)clazz.newInstance();
            }
        }
        catch (InstantiationException e) {
            throw new PersistenceException("InstantiationException: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new PersistenceException("IllegalAccessException: " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new PersistenceException("ClassNotFoundException: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new PersistenceException("Exception: " + e.getMessage(), e);
        }
        return persistable;
    }

    private Bundle getCurrentBundle() {
        Bundle bundle = null;
        if (!this.bundleStack.isEmpty()) {
            bundle = this.bundleStack.peek();
        }
        return bundle;
    }

    private Element getNamedElement(String name) {
        Element namedElement = null;
        NodeList nodes = this.element.getElementsByTagName(name);
        int i = 0;
        while (namedElement == null && i < nodes.getLength()) {
            Node parentNone;
            Element elem = (Element)nodes.item(i);
            if (elem != null && (parentNone = elem.getParentNode()) != null && parentNone.equals(this.element)) {
                namedElement = elem;
            }
            ++i;
        }
        return namedElement;
    }

    private Class<?> loadClass(String bundlename, String className) throws ClassNotFoundException {
        Class<?> clazz = null;
        Bundle bundle = Platform.getBundle((String)bundlename);
        clazz = bundle != null ? bundle.loadClass(className) : this.getClass().getClassLoader().loadClass(className);
        return clazz;
    }

    private boolean pushNewBundle(Element persistableElement) {
        boolean pushed = false;
        String bundleId = persistableElement.getAttribute("bundle");
        if (bundleId != null && bundleId.length() > 0) {
            Bundle bundle;
            String bundleMapping = this.bundleMappings.get(bundleId);
            if (bundleMapping != null) {
                bundleId = bundleMapping;
            }
            if ((bundle = Platform.getBundle((String)bundleId)) != null) {
                this.bundleStack.push(bundle);
                pushed = true;
            }
        }
        return pushed;
    }
}

