/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.project.midp;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.core.project.midp.ProjectConvertionException;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPDevice;
import org.eclipse.mtj.internal.core.Messages;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteFactory;
import org.eclipse.mtj.internal.core.project.midp.MidletSuiteProject;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJProjectConverter {
    private static final String DEFAULT_PREFERENCES_DIRNAME = ".settings";
    private static final String EclipseME_JAVAME_CONTAINER = "J2MELIB";
    private static final String EclipseME_METADATA_ELEM_ROOT = "eclipsemeMetadata";
    private static final String EclipseME_METADATA_FILE = ".eclipseme";
    private static final String EclipseME_NATURE_PREFIX = "eclipseme.core.";
    private static final String EclipseME_PREFERENCE_STORE = "eclipseme.core.prefs";
    private static final String EcliseME_TEMP_FOLDER_NAME = ".eclipseme.tmp";
    private static final String FILENAME_PROJECT = ".project";
    private static final String MTJ_METADATA_ELEM_PASSWORDS = "passwords";
    private static final String MTJ_METADATA_ELEM_ROOT = "mtjMetadata";
    private static String oldJadFilePath;
    private static final String PREFS_FILE_EXTENSION = "prefs";
    private static MTJProjectConverter instance;

    static {
        instance = new MTJProjectConverter();
    }

    public static MTJProjectConverter getInstance() {
        return instance;
    }

    private MTJProjectConverter() {
    }

    public synchronized void convertEclipseMeProject(IProject project, IProgressMonitor monitor) throws ProjectConvertionException {
        this.convertEclipseMeProject(project, this.getDevice(project), monitor);
    }

    public synchronized void convertEclipseMeProject(IProject project, IMIDPDevice device, IProgressMonitor monitor) throws ProjectConvertionException {
        File projectFile = null;
        File importedRootFolder = new File(project.getLocationURI());
        List<File> files = this.getChildrenFiles(importedRootFolder);
        monitor.beginTask(Messages.MTJProjectConverter_convert_taskname, 10);
        for (File file : files) {
            this.renameEclipseMETmpFolder(file, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.renamePreferenceStoreFile(project, file, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.modifyMetadata(project, file, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!file.isFile() || !file.getName().equals(FILENAME_PROJECT)) continue;
            projectFile = file;
        }
        this.renameProjectJAD(project);
        try {
            project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.convertProject(project, device, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
            this.recoverJADFileNameInMetadata(project);
            this.removeBuilderAndNature(projectFile, monitor);
            project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            project.build(15, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            monitor.done();
        }
        catch (CoreException e) {
            throw new ProjectConvertionException(e.getMessage(), e);
        }
    }

    public void convertJavaProject(IJavaProject javaProject, IMIDPDevice device, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, JavaModelException {
        IProject project = javaProject.getProject();
        String jadFileName = MidletSuiteProject.getDefaultJadFileName(project);
        MidletSuiteFactory.getMidletSuiteCreationRunnable(project, javaProject, device, jadFileName).run(monitor);
        this.removeJ2SELibraries(javaProject, monitor);
    }

    private void convertProject(IProject project, IMIDPDevice device, IProgressMonitor monitor) throws ProjectConvertionException {
        this.deleteDeviceFromMetadata(project);
        if (device == null) {
            throw new ProjectConvertionException(Messages.MTJProjectConverter_convertProject_device_unavailable);
        }
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            MidletSuiteFactory.removeMidletSuiteProject(javaProject);
            this.removeJ2SEAndEclipseMELibraries(javaProject, monitor);
            String jadFileName = MidletSuiteProject.getDefaultJadFileName(project);
            MidletSuiteFactory.getMidletSuiteCreationRunnable(project, javaProject, device, jadFileName).run(monitor);
        }
        catch (Exception exception) {
            throw new ProjectConvertionException(Messages.MTJProjectConverter_convertProject_convertion_error);
        }
    }

    private void deleteDeviceFromMetadata(IProject project) {
        IFile metadateFile = project.getFile(".mtj");
        try {
            Document document = XMLUtils.readDocument(metadateFile.getLocation().toFile());
            Element deviceNode = (Element)document.getElementsByTagName("device").item(0);
            deviceNode.getParentNode().removeChild(deviceNode);
            XMLUtils.writeDocument(metadateFile.getLocation().toFile(), document);
        }
        catch (Exception e) {
            MTJLogger.log(4, e);
        }
    }

    private List<File> getChildrenFiles(File root) {
        ArrayList<File> result = new ArrayList<File>();
        if (root.isDirectory()) {
            String[] file;
            String[] stringArray = file = root.list();
            int n = file.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                result.add(new File(root, element));
                ++n2;
            }
        }
        return result;
    }

    private IMIDPDevice getDevice(IProject project) {
        IMIDPDevice device = null;
        IFile metadateFile = project.getFile(".mtj");
        try {
            Document document = XMLUtils.readDocument(metadateFile.getLocation().toFile());
            Element deviceElement = (Element)document.getElementsByTagName("device").item(0);
            String deviceGroup = deviceElement.getAttribute("group");
            String deviceName = deviceElement.getAttribute("name");
            device = (IMIDPDevice)MTJCore.getDeviceRegistry().getDevice(deviceGroup, deviceName);
        }
        catch (Exception exception) {
            device = null;
        }
        if (device == null) {
            device = (IMIDPDevice)MTJCore.getDeviceRegistry().getDefaultDevice();
        }
        return device;
    }

    private IMidletSuiteProject getMidletSuiteProject(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IMidletSuiteProject midletProject = MidletSuiteFactory.getMidletSuiteProject(javaProject);
        return midletProject;
    }

    private String getOldJadFilePath(File elcipsemeMetadataFile, String defaultPath) {
        String oldJadFilePath = null;
        try {
            Document document = XMLUtils.readDocument(elcipsemeMetadataFile);
            Element rootElement = document.getDocumentElement();
            oldJadFilePath = rootElement.getAttribute("jad");
            if (oldJadFilePath.length() == 0) {
                oldJadFilePath = defaultPath;
            }
        }
        catch (Exception e) {
            MTJLogger.log(4, e);
        }
        return oldJadFilePath;
    }

    private boolean isEclipseMELibraryEntry(IClasspathEntry entry) {
        boolean isEclipseMEEntry = false;
        if (entry.getEntryKind() == 5 && entry.getPath().lastSegment().equals(EclipseME_JAVAME_CONTAINER)) {
            isEclipseMEEntry = true;
        }
        return isEclipseMEEntry;
    }

    private boolean isJ2SELibraryEntry(IClasspathEntry entry) {
        boolean isJ2SEEntry = false;
        if (entry.getEntryKind() == 1) {
            if (entry.getPath().lastSegment().equals("JRE_LIB")) {
                isJ2SEEntry = true;
            }
        } else if (entry.getEntryKind() == 5 && entry.getPath().lastSegment().equals("org.eclipse.jdt.launching.JRE_CONTAINER")) {
            isJ2SEEntry = true;
        }
        return isJ2SEEntry;
    }

    private void modifyMetadata(IProject project, File elcipsemeMetadataFile, IProgressMonitor monitor) {
        if (elcipsemeMetadataFile.isFile() && elcipsemeMetadataFile.getName().equals(EclipseME_METADATA_FILE)) {
            oldJadFilePath = this.getOldJadFilePath(elcipsemeMetadataFile, MidletSuiteProject.getDefaultJadFileName(project));
            monitor.beginTask(Messages.MTJProjectConverter_modifyMetadata_taskname, 2);
            Path metadataPath = new Path(elcipsemeMetadataFile.getPath());
            File renamedMetaFile = new File(metadataPath.removeLastSegments(1) + File.separator + ".mtj");
            elcipsemeMetadataFile.renameTo(renamedMetaFile);
            monitor.worked(1);
            try {
                Document document = XMLUtils.readDocument(renamedMetaFile);
                Element oldRootElement = document.getDocumentElement();
                if (!oldRootElement.getNodeName().equals(EclipseME_METADATA_ELEM_ROOT)) {
                    renamedMetaFile.delete();
                    return;
                }
                Element newRootElement = document.createElement(MTJ_METADATA_ELEM_ROOT);
                while (oldRootElement.hasChildNodes()) {
                    newRootElement.appendChild(oldRootElement.getFirstChild());
                }
                document.replaceChild(newRootElement, oldRootElement);
                Element passwordNode = (Element)document.getElementsByTagName(MTJ_METADATA_ELEM_PASSWORDS).item(0);
                if (passwordNode != null) {
                    passwordNode.getParentNode().removeChild(passwordNode);
                }
                XMLUtils.writeDocument(renamedMetaFile, document);
            }
            catch (Exception e) {
                MTJLogger.log(4, Messages.MTJProjectConverter_modifyMetadata_exception, e);
                renamedMetaFile.delete();
            }
            monitor.done();
        }
    }

    private void recoverJADFileNameInMetadata(IProject project) throws CoreException {
        String generatedJADFileName;
        IMidletSuiteProject midletProject = this.getMidletSuiteProject(project);
        IFile oldJadFile = project.getFile(oldJadFilePath);
        String oldJadFileName = oldJadFile.getName();
        if (!oldJadFileName.equals(generatedJADFileName = midletProject.getJadFileName())) {
            midletProject.setJadFileName(oldJadFileName);
            midletProject.saveMetaData();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void removeBuilderAndNature(File projectFile, IProgressMonitor monitor) {
        if (projectFile.isFile() && projectFile.getName().equals(FILENAME_PROJECT)) {
            monitor.beginTask(Messages.MTJProjectConverter_removeBuilderAndNature_taskname, 2);
            try {
                void var6_8;
                Document document = XMLUtils.readDocument(projectFile);
                NodeList nameNodeList = document.getElementsByTagName("name");
                ArrayList<Object> buildersToRemove = new ArrayList<Object>();
                boolean bl = false;
                while (var6_8 < nameNodeList.getLength()) {
                    Node node = nameNodeList.item((int)var6_8);
                    if (node.getTextContent().indexOf(EclipseME_NATURE_PREFIX) >= 0) {
                        buildersToRemove.add(node);
                    }
                    ++var6_8;
                }
                for (Node node : buildersToRemove) {
                    Node buildCommandNode = node.getParentNode();
                    buildCommandNode.getParentNode().removeChild(buildCommandNode);
                }
                monitor.worked(1);
                NodeList nodeList = document.getElementsByTagName("nature");
                ArrayList<Node> naturesToRemove = new ArrayList<Node>();
                int i2 = 0;
                while (i2 < nodeList.getLength()) {
                    Node node = nodeList.item(i2);
                    if (node.getTextContent().indexOf(EclipseME_NATURE_PREFIX) >= 0) {
                        naturesToRemove.add(node);
                    }
                    ++i2;
                }
                for (Node n : naturesToRemove) {
                    n.getParentNode().removeChild(n);
                }
                XMLUtils.writeDocument(projectFile, document);
            }
            catch (Exception e) {
                MTJLogger.log(4, ".project error", e);
            }
            monitor.done();
        }
    }

    private void removeJ2SEAndEclipseMELibraries(IJavaProject javaProject, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < entries.length) {
            if (!this.isJ2SELibraryEntry(entries[i]) && !this.isEclipseMELibraryEntry(entries[i])) {
                list.add(entries[i]);
            }
            ++i;
        }
        entries = list.toArray(new IClasspathEntry[list.size()]);
        javaProject.setRawClasspath(entries, monitor);
    }

    private void removeJ2SELibraries(IJavaProject javaProject, IProgressMonitor monitor) throws JavaModelException {
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < entries.length) {
            if (!this.isJ2SELibraryEntry(entries[i])) {
                list.add(entries[i]);
            }
            ++i;
        }
        entries = list.toArray(new IClasspathEntry[list.size()]);
        javaProject.setRawClasspath(entries, monitor);
    }

    private void renameEclipseMETmpFolder(File eclipseMeTmpFolder, IProgressMonitor monitor) {
        if (eclipseMeTmpFolder.isDirectory() && eclipseMeTmpFolder.getName().equals(EcliseME_TEMP_FOLDER_NAME)) {
            monitor.beginTask(Messages.MTJProjectConverter_renameEclipseMETmpFolder_taskname, 1);
            Path path = new Path(eclipseMeTmpFolder.getPath());
            IPath mtjTmpFolderPath = path.removeLastSegments(1).append(".mtj.tmp");
            File mtjTmpFolder = new File(mtjTmpFolderPath.toFile().getPath());
            eclipseMeTmpFolder.renameTo(mtjTmpFolder);
            monitor.done();
        }
    }

    private void renamePreferenceStoreFile(IProject project, File preferenceFolder, IProgressMonitor monitor) {
        if (preferenceFolder.isDirectory() && preferenceFolder.getName().equals(DEFAULT_PREFERENCES_DIRNAME)) {
            monitor.beginTask(Messages.MTJProjectConverter_renamePreferenceStoreFile_taskname, 1);
            List<File> preferencesStoreFiles = this.getChildrenFiles(preferenceFolder);
            for (File aPreferencesStoreFile : preferencesStoreFiles) {
                if (!aPreferencesStoreFile.getName().equals(EclipseME_PREFERENCE_STORE)) continue;
                ProjectScope projectScope = new ProjectScope(project);
                IEclipsePreferences prefNode = projectScope.getNode("org.eclipse.mtj.core");
                Path path = new Path(aPreferencesStoreFile.getPath());
                File renamedPrefFile = new File(path.removeLastSegments(1) + File.separator + prefNode.name() + "." + PREFS_FILE_EXTENSION);
                aPreferencesStoreFile.renameTo(renamedPrefFile);
                break;
            }
            monitor.done();
        }
    }

    private void renameProjectJAD(IProject project) {
        IFile jadFile = project.getFile(oldJadFilePath);
        File localFile = jadFile.getLocation().toFile();
        IMidletSuiteProject suite = this.getMidletSuiteProject(project);
        File dest = suite.getApplicationDescriptorFile().getLocation().toFile();
        localFile.renameTo(dest);
    }
}

