/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.project.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.project.IMTJProject;
import org.eclipse.mtj.core.project.IMetaData;
import org.eclipse.mtj.core.project.ProjectType;
import org.eclipse.mtj.core.project.runtime.MTJRuntime;
import org.eclipse.mtj.core.project.runtime.MTJRuntimeList;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.symbol.ISymbol;
import org.eclipse.mtj.core.symbol.ISymbolSet;
import org.eclipse.mtj.internal.core.project.midp.MetaData;
import org.eclipse.mtj.internal.core.sdk.device.IDeviceMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTJRuntimeListUtils {
    public static final String MATCH_ATT_CLASS = "class";
    public static final String MATCH_EXTENSIONPOINT_ID = "org.eclipse.mtj.core.devicematcher";
    public static final String MATCH_ELEMENT_MATCHER = "matcher";
    public static final String MATCH_ATT_PRIORITY = "priority";

    public static boolean mtjRuntimeListContentsEquals(MTJRuntimeList cs1, MTJRuntimeList cs2) {
        if (cs1.size() != cs2.size()) {
            return false;
        }
        for (MTJRuntime cInCs1 : cs1) {
            int index = cs2.indexOf(cInCs1);
            if (index < 0) {
                return false;
            }
            MTJRuntime cInCs2 = (MTJRuntime)cs2.get(index);
            if (!MTJRuntimeListUtils.deviceEquals(cInCs1, cInCs2)) {
                return false;
            }
            if (!MTJRuntimeListUtils.workspaceSymbolsetsEquals(cInCs1.getWorkspaceScopeSymbolSets(), cInCs2.getWorkspaceScopeSymbolSets())) {
                return false;
            }
            if (MTJRuntimeListUtils.symbolSetEquals(cInCs1, cInCs2)) continue;
            return false;
        }
        return true;
    }

    public static boolean mtjRuntimeListEquals(MTJRuntimeList cs1, MTJRuntimeList cs2) {
        if (!MTJRuntimeListUtils.mtjRuntimeListContentsEquals(cs1, cs2)) {
            return false;
        }
        return cs1.getActiveMTJRuntime().equals(cs2.getActiveMTJRuntime());
    }

    private static boolean deviceEquals(MTJRuntime cInCs1, MTJRuntime cInCs2) {
        return cInCs1.getDevice().equals(cInCs2.getDevice());
    }

    public static boolean isMTJRuntimeListDirty(IMTJProject midletProject) {
        MTJRuntimeList configsInMemory = midletProject.getRuntimeList();
        boolean isDirty = true;
        IMetaData metaData = MTJCore.createMetaData(midletProject.getProject(), ProjectType.MIDLET_SUITE);
        MTJRuntimeList configsInMetadataFile = metaData.getRuntimeList();
        isDirty = !MTJRuntimeListUtils.mtjRuntimeListEquals(configsInMemory, configsInMetadataFile);
        return isDirty;
    }

    public static boolean isOnlyActiveMTJRuntimeDirty(IMTJProject midletProject) {
        MTJRuntimeList configsInMemory = midletProject.getRuntimeList();
        MTJRuntimeList configsInMetadataFile = new MetaData(midletProject.getProject()).getRuntimeList();
        boolean same = MTJRuntimeListUtils.mtjRuntimeListContentsEquals(configsInMemory, configsInMetadataFile);
        return same;
    }

    private static boolean symbolSetEquals(MTJRuntime cInCs1, MTJRuntime cInCs2) {
        ISymbolSet symbolSet2;
        ISymbolSet symbolSet1 = cInCs1.getSymbolSet();
        if (!symbolSet1.equals(symbolSet2 = cInCs2.getSymbolSet())) {
            return false;
        }
        ArrayList<ISymbol> symbolList1 = new ArrayList<ISymbol>(symbolSet1.getSymbols());
        ArrayList<ISymbol> symbolList2 = new ArrayList<ISymbol>(symbolSet2.getSymbols());
        for (ISymbol symbol : symbolList1) {
            if (symbolList2.contains(symbol)) continue;
            return false;
        }
        return true;
    }

    public static boolean workspaceSymbolsetsEquals(List<ISymbolSet> sets1, List<ISymbolSet> sets2) {
        if (sets1 == null && sets2 == null) {
            return true;
        }
        if (sets1 == null && sets2 != null) {
            return false;
        }
        if (sets1 != null && sets2 == null) {
            return false;
        }
        if (sets1.size() != sets2.size()) {
            return false;
        }
        for (ISymbolSet s : sets1) {
            if (sets2.contains(s)) continue;
            return false;
        }
        return true;
    }

    public static String[] match(String configName, String sdkName, String deviceName, Set<String> existingConfigNames) {
        List<IConfigurationElement> matchers = MTJRuntimeListUtils.getMatcherExtensions();
        if (matchers == null) {
            return null;
        }
        MTJRuntimeListUtils.sortElementsByPriority(matchers);
        return MTJRuntimeListUtils.executeMatchers(matchers, configName, sdkName, deviceName, existingConfigNames);
    }

    public static IDevice match(String sdkName, String deviceName) {
        List<IConfigurationElement> matchers = MTJRuntimeListUtils.getMatcherExtensions();
        if (matchers == null) {
            return null;
        }
        MTJRuntimeListUtils.sortElementsByPriority(matchers);
        return MTJRuntimeListUtils.executeMatchers(matchers, sdkName, deviceName);
    }

    private static String[] executeMatchers(List<IConfigurationElement> matchers, String configName, String sdkName, String deviceName, Set<String> existingConfigNames) {
        String[] matched = null;
        for (IConfigurationElement elem : matchers) {
            try {
                IDeviceMatcher matcher = (IDeviceMatcher)elem.createExecutableExtension(MATCH_ATT_CLASS);
                matched = matcher.match(configName, sdkName, deviceName, existingConfigNames);
                if (matched == null) continue;
                break;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return matched;
    }

    private static IDevice executeMatchers(List<IConfigurationElement> matchers, String sdkName, String deviceName) {
        IDevice device = null;
        for (IConfigurationElement elem : matchers) {
            try {
                IDeviceMatcher matcher = (IDeviceMatcher)elem.createExecutableExtension(MATCH_ATT_CLASS);
                device = matcher.match(sdkName, deviceName);
                if (device == null) continue;
                break;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return device;
    }

    private static List<IConfigurationElement> getMatcherExtensions() {
        ArrayList<IConfigurationElement> matchers = new ArrayList<IConfigurationElement>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(MATCH_EXTENSIONPOINT_ID);
        if (point == null) {
            return null;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                if (element.getName().equals(MATCH_ELEMENT_MATCHER)) {
                    matchers.add(element);
                }
                ++j;
            }
            ++i;
        }
        return matchers;
    }

    private static void sortElementsByPriority(List<IConfigurationElement> matchers) {
        Collections.sort(matchers, new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement e1, IConfigurationElement e2) {
                int prio2;
                int prio1 = Integer.parseInt(e1.getAttribute(MTJRuntimeListUtils.MATCH_ATT_PRIORITY));
                if (prio1 == (prio2 = Integer.parseInt(e2.getAttribute(MTJRuntimeListUtils.MATCH_ATT_PRIORITY)))) {
                    return 0;
                }
                if (prio1 > prio1) {
                    return 1;
                }
                return -1;
            }
        });
    }

    public static final MTJRuntime createMTJRuntime(String configName) {
        return new MTJRuntime(configName);
    }

    public static final MTJRuntimeList createMTJRuntimeList() {
        return new MTJRuntimeList();
    }
}

