/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.refactoring.RefactoringMessages;
import org.eclipse.osgi.util.NLS;

public class JadLaunchConfigProjectRenameChange
extends Change {
    private ILaunchConfiguration launchConfiguration;
    private String newProjectName;

    public JadLaunchConfigProjectRenameChange(ILaunchConfiguration launchConfiguration, String newProjectName) {
        this.launchConfiguration = launchConfiguration;
        this.newProjectName = newProjectName;
    }

    public Object getModifiedElement() {
        return this.launchConfiguration;
    }

    public String getName() {
        return NLS.bind((String)RefactoringMessages.JadLaunchConfigProjectRenameChange_name, (Object)this.launchConfiguration.getName());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.launchConfiguration.exists()) {
            return RefactoringStatus.createFatalErrorStatus((String)NLS.bind((String)RefactoringMessages.JadLaunchConfig_doNotExist, (Object)this.launchConfiguration.getName()));
        }
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.launchConfiguration.getWorkingCopy();
        String oldJadFileLocation = wc.getAttribute("mtj.specified_jad_url", "");
        String newJadFileLocation = this.getNewJadFileLocation(oldJadFileLocation, this.newProjectName);
        wc.setAttribute("mtj.specified_jad_url", newJadFileLocation);
        if (wc.isDirty()) {
            wc.doSave();
        }
        return null;
    }

    private String getNewJadFileLocation(String oldJadFileLocation, String newProjectName) {
        IPath newProjectPath = MTJCore.getWorkspace().getRoot().getProject(newProjectName).getLocation();
        Path oldJadPath = new Path(oldJadFileLocation);
        IPath relativeJadPath = oldJadPath.removeFirstSegments(newProjectPath.segmentCount());
        IPath newJadPath = newProjectPath.append(relativeJadPath);
        return newJadPath.toPortableString();
    }
}

