/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.refactoring;

import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.mtj.internal.core.l10n.Messages;
import org.eclipse.mtj.internal.core.util.Utils;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class L10NResourcesMoveParticipant
extends MoveParticipant {
    private IJavaElement oldParent;
    private IJavaProject jProject;

    protected boolean initialize(Object element) {
        ICompilationUnit compilationUnit;
        if (element instanceof ICompilationUnit && (compilationUnit = (ICompilationUnit)element).getElementName().equals("L10nResources.java")) {
            this.jProject = compilationUnit.getJavaProject();
            this.oldParent = compilationUnit.getParent();
            return true;
        }
        return false;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IPackageFragment pack;
        ICompilationUnit compilationUnit;
        block10: {
            MoveArguments arguments = this.getArguments();
            Object destination = arguments.getDestination();
            if (destination instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)destination;
                IProject project = this.jProject.getProject();
                IFile locationsXml = project.getFile("Localization Data");
                if (locationsXml.exists()) {
                    try {
                        IPath xmlPath = locationsXml.getLocation();
                        Document document = Utils.getXmlDocument(xmlPath);
                        Element root = document.getDocumentElement();
                        root.setAttribute("package", packageFragment.getElementName());
                        TransformerFactory factory = TransformerFactory.newInstance();
                        Transformer transformer = factory.newTransformer();
                        transformer.transform(new DOMSource(document), new StreamResult(xmlPath.toFile()));
                    }
                    catch (IOException iOException) {
                        MTJLogger.log(4, Messages.L10nBuilder_ErrorParsingLocalizationData);
                        this.jProject.getProject().refreshLocal(2, pm);
                        break block10;
                    }
                    catch (Exception e) {
                        try {
                            MTJLogger.log(4, e);
                            break block10;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.jProject.getProject().refreshLocal(2, pm);
                        }
                    }
                    this.jProject.getProject().refreshLocal(2, pm);
                }
            }
        }
        if (this.oldParent != null && this.oldParent instanceof IPackageFragment && (compilationUnit = (pack = (IPackageFragment)this.oldParent).getCompilationUnit("L10nConstants.java")) != null && compilationUnit.exists()) {
            compilationUnit.delete(true, pm);
        }
        return null;
    }

    public String getName() {
        return "Localization Data Participant";
    }
}

