/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.util.Set;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.internal.core.sdk.device.DeviceMatchCache;
import org.eclipse.mtj.internal.core.sdk.device.IDeviceMatchCache;
import org.eclipse.mtj.internal.core.sdk.device.IDeviceMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedDeviceMatcher
implements IDeviceMatcher {
    @Override
    public IDevice match(String deviceGroup, String deviceName) {
        String[] cachedValue = this.getCachedValue(deviceGroup, deviceName);
        if (cachedValue != null) {
            try {
                IDevice cachedDevice = MTJCore.getDeviceRegistry().getDevice(cachedValue[0], cachedValue[1]);
                return cachedDevice;
            }
            catch (PersistenceException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String[] getCachedValue(String deviceGroup, String deviceName) {
        IDeviceMatchCache cache = DeviceMatchCache.getInstance();
        String[] cachedValue = cache.getValueFromCache(cache.createKey(deviceGroup, deviceName));
        return cachedValue;
    }

    @Override
    public String[] match(String configurationName, String deviceGroup, String deviceName, Set<String> existingConfigNames) {
        String[] cachedValue = this.getCachedValue(deviceGroup, deviceName);
        if (cachedValue != null) {
            return new String[]{cachedValue[1], cachedValue[0], cachedValue[1]};
        }
        return null;
    }
}

