/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.build.preverifier.IPreverifier;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.IDeviceRegistry;
import org.eclipse.mtj.core.sdk.device.IDeviceRegistryListener;
import org.eclipse.mtj.core.sdk.device.IManagedDevice;
import org.eclipse.mtj.internal.core.persistence.XMLPersistenceProvider;
import org.eclipse.mtj.internal.core.sdk.device.ImportedDeviceRegistry;
import org.eclipse.mtj.internal.core.sdk.device.ManagedDeviceRegistry;
import org.eclipse.mtj.internal.core.util.migration.DeviceRegistryMigration;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceRegistry
implements IDeviceRegistry {
    private static IDeviceRegistry instance = null;
    private ManagedDeviceRegistry managedDeviceRegistry;
    private ImportedDeviceRegistry importedDeviceRegistry;
    private Object persistenceMutex = new Object();
    private IDevice defaultDevice;
    private IPreverifier defaultPreverifier;
    private boolean fireDeviceAddedEvent;
    private ArrayList<IDeviceRegistryListener> listenerList;

    public static synchronized IDeviceRegistry getInstance() {
        if (instance == null) {
            instance = new DeviceRegistry();
        }
        return instance;
    }

    protected DeviceRegistry() {
        this.managedDeviceRegistry = new ManagedDeviceRegistry();
        this.importedDeviceRegistry = new ImportedDeviceRegistry();
        this.listenerList = new ArrayList();
        try {
            this.load();
        }
        catch (PersistenceException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addDevice(IDevice device) throws IllegalArgumentException, PersistenceException {
        if (device instanceof IManagedDevice) {
            return;
        }
        this.importedDeviceRegistry.addDevice(device);
        if (this.fireDeviceAddedEvent) {
            this.fireDeviceAddedEvent(device);
        }
    }

    @Override
    public void addRegistryListener(IDeviceRegistryListener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void clear() throws PersistenceException {
        this.importedDeviceRegistry.clear();
    }

    @Override
    public void enableDeviceAddedEvent(boolean fire) {
        this.fireDeviceAddedEvent = fire;
    }

    @Override
    public List<IDevice> getAllDevices() throws PersistenceException {
        ArrayList<IDevice> allDevices = new ArrayList<IDevice>(this.managedDeviceRegistry.getAllDevices());
        allDevices.addAll(this.importedDeviceRegistry.getAllDevices());
        return allDevices;
    }

    @Override
    public IDevice getDefaultDevice() {
        return this.defaultDevice;
    }

    @Override
    public IPreverifier getDefaultPreferifier() {
        return this.defaultPreverifier;
    }

    @Override
    public IDevice getDevice(String groupName, String deviceName) throws PersistenceException {
        IDevice device = this.managedDeviceRegistry.getDevice(groupName, deviceName);
        if (device == null) {
            device = this.importedDeviceRegistry.getDevice(groupName, deviceName);
        }
        return device;
    }

    @Override
    public int getDeviceCount() throws PersistenceException {
        return this.managedDeviceRegistry.getDeviceCount() + this.importedDeviceRegistry.getDeviceCount();
    }

    @Override
    public List<IDevice> getDevices(String groupName) throws PersistenceException {
        List<IDevice> devices = this.managedDeviceRegistry.getDevices(groupName);
        if (devices == null) {
            devices = this.importedDeviceRegistry.getDevices(groupName);
        }
        return devices;
    }

    @Override
    public List<String> getSDKNames() throws PersistenceException {
        ArrayList<String> sdksNames = new ArrayList<String>(this.managedDeviceRegistry.getSDKNames());
        sdksNames.addAll(this.importedDeviceRegistry.getSDKNames());
        return sdksNames;
    }

    @Override
    public boolean isDeviceAddedEventEnabled() {
        return this.fireDeviceAddedEvent;
    }

    @Override
    public void load() throws PersistenceException {
        this.load(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(boolean loadOnlyValidDevices) throws PersistenceException {
        Object object = this.persistenceMutex;
        synchronized (object) {
            XMLPersistenceProvider persistenceProvider = DeviceRegistry.createPersistenceProvider();
            if (persistenceProvider != null) {
                this.loadUsing(persistenceProvider);
                this.importedDeviceRegistry.loadUsing(persistenceProvider, loadOnlyValidDevices);
            }
        }
    }

    @Override
    public void loadUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        String defaultDeviceName;
        String defaultDeviceSdkName;
        try {
            this.enableDeviceAddedEvent(false);
            defaultDeviceSdkName = persistenceProvider.loadString("defaultDeviceSdkName");
            defaultDeviceName = persistenceProvider.loadString("defaultDevicename");
            this.defaultPreverifier = (IPreverifier)persistenceProvider.loadPersistable("defaultPreverifier");
        }
        finally {
            this.enableDeviceAddedEvent(true);
        }
        this.defaultDevice = this.getDevice(defaultDeviceSdkName, defaultDeviceName);
    }

    public void updateReferences() throws PersistenceException, TransformerException, IOException {
        this.load(true);
        this.store();
    }

    @Override
    public synchronized void removeDevice(IDevice device) throws PersistenceException {
        if (!(device instanceof IManagedDevice)) {
            this.importedDeviceRegistry.removeDevice(device);
            this.fireDeviceRemovedEvent(device);
            if (device.equals(this.defaultDevice)) {
                this.defaultDevice = null;
            }
        }
    }

    @Override
    public void removeRegistryListener(IDeviceRegistryListener listener) {
        this.listenerList.remove(listener);
    }

    @Override
    public void setDefaultDevice(IDevice device) {
        this.defaultDevice = device;
    }

    @Override
    public void setDefaultPreverifer(IPreverifier preverifier) {
        this.defaultPreverifier = preverifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store() throws PersistenceException, TransformerException, IOException {
        Object object = this.persistenceMutex;
        synchronized (object) {
            XMLPersistenceProvider provider = new XMLPersistenceProvider("deviceRegistry");
            this.storeUsing(provider);
            XMLUtils.writeDocument(DeviceRegistry.getComponentStoreFile(), provider.getDocument());
        }
    }

    @Override
    public void storeUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        if (this.defaultPreverifier != null) {
            persistenceProvider.storePersistable("defaultPreverifier", this.defaultPreverifier);
        }
        if (this.defaultDevice != null) {
            String defaultDeviceSdkName = this.defaultDevice.getSDKName();
            String defaultDeviceName = this.defaultDevice.getName();
            if (defaultDeviceSdkName != null && defaultDeviceName != null) {
                persistenceProvider.storeString("defaultDeviceSdkName", defaultDeviceSdkName);
                persistenceProvider.storeString("defaultDevicename", defaultDeviceName);
            }
        }
        this.importedDeviceRegistry.storeUsing(persistenceProvider);
    }

    private void fireDeviceAddedEvent(IDevice device) {
        for (IDeviceRegistryListener listener : this.listenerList) {
            listener.deviceAdded(device);
        }
    }

    private void fireDeviceRemovedEvent(IDevice device) {
        for (IDeviceRegistryListener listener : this.listenerList) {
            listener.deviceRemoved(device);
        }
    }

    static File getComponentStoreFile() {
        IPath pluginStatePath = MTJCore.getMTJCore().getStateLocation();
        IPath storePath = pluginStatePath.append("devices.xml");
        return storePath.toFile();
    }

    public List<String> getInvalidSDKNames() {
        return this.importedDeviceRegistry.getInvalidSDKNames();
    }

    static XMLPersistenceProvider createPersistenceProvider() throws PersistenceException {
        File storeFile = DeviceRegistry.getComponentStoreFile();
        XMLPersistenceProvider persistenceProvider = null;
        if (storeFile.exists()) {
            Document document;
            block11: {
                block10: {
                    document = XMLUtils.readDocument(storeFile);
                    if (document != null) break block10;
                    return null;
                }
                Element rootXmlElement = document.getDocumentElement();
                if (rootXmlElement.getNodeName().equals("deviceRegistry")) break block11;
                return null;
            }
            try {
                DeviceRegistryMigration migration = new DeviceRegistryMigration();
                migration.migrate(document);
                if (migration.isMigrated()) {
                    try {
                        XMLUtils.writeDocument(storeFile, document);
                    }
                    catch (TransformerException e) {
                        e.printStackTrace();
                    }
                    document = XMLUtils.readDocument(storeFile);
                }
                persistenceProvider = new XMLPersistenceProvider(document);
            }
            catch (ParserConfigurationException e) {
                throw new PersistenceException(e.getMessage(), e);
            }
            catch (SAXException e) {
                throw new PersistenceException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new PersistenceException(e.getMessage(), e);
            }
        }
        return persistenceProvider;
    }
}

