/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.ISDK;
import org.eclipse.mtj.core.sdk.device.IDevice;
import org.eclipse.mtj.core.sdk.device.ILibrary;
import org.eclipse.mtj.core.sdk.device.IManagedDevice;
import org.eclipse.mtj.internal.core.persistence.XMLPersistenceProvider;
import org.eclipse.mtj.internal.core.sdk.BasicSDK;
import org.eclipse.mtj.internal.core.sdk.device.DeviceRegistry;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImportedDeviceRegistry {
    private Map<String, Map<String, IDevice>> deviceGroupsMap;
    private Map<String, Map<String, IDevice>> invalidDeviceGroupsMap = new HashMap<String, Map<String, IDevice>>();

    ImportedDeviceRegistry() {
    }

    void addDevice(IDevice device) throws IllegalArgumentException, PersistenceException {
        if (device.getSDKName() == null || device.getName() == null) {
            throw new IllegalArgumentException();
        }
        Map<String, IDevice> groupMap = this.getDeviceGroupMap(device.getSDKName(), true);
        groupMap.put(device.getName(), device);
    }

    void clear() throws PersistenceException {
        this.getDeviceGroupsMap().clear();
    }

    List<IDevice> getAllDevices() throws PersistenceException {
        return this.getAllDevicesInternal(false, null);
    }

    IDevice getDevice(String groupName, String deviceName) throws PersistenceException {
        IDevice device = null;
        Map<String, IDevice> groupMap = this.getDeviceGroupMap(groupName, false);
        if (groupMap != null) {
            device = groupMap.get(deviceName);
        }
        return device;
    }

    int getDeviceCount() throws PersistenceException {
        int deviceCount = 0;
        for (Map<String, IDevice> groupMap : this.getDeviceGroupsMap().values()) {
            deviceCount += groupMap.size();
        }
        return deviceCount;
    }

    List<IDevice> getDevices(String groupName) throws PersistenceException {
        List<IDevice> devices = this.getAllDevicesInternal(true, groupName);
        return devices.isEmpty() ? null : devices;
    }

    List<String> getSDKNames() throws PersistenceException {
        return new ArrayList<String>(this.getDeviceGroupsMap().keySet());
    }

    void load() throws PersistenceException {
        XMLPersistenceProvider persistenceProvider = DeviceRegistry.createPersistenceProvider();
        if (persistenceProvider != null) {
            this.loadUsing(persistenceProvider, false);
        }
    }

    void loadUsing(IPersistenceProvider persistenceProvider, boolean loadOnlyValidDevices) throws PersistenceException {
        this.getDeviceGroupsMap().clear();
        this.invalidDeviceGroupsMap.clear();
        int deviceCount = persistenceProvider.loadInteger("deviceCount");
        int i = 0;
        while (i < deviceCount) {
            IDevice device = (IDevice)persistenceProvider.loadPersistable("device" + i);
            List<ILibrary> entries = device.getClasspath().getEntries();
            boolean isValidDevice = true;
            for (ILibrary library : entries) {
                File file = library.toFile();
                if (file.exists()) continue;
                isValidDevice = false;
                break;
            }
            if (!loadOnlyValidDevices) {
                this.addDevice(device);
                if (!isValidDevice) {
                    Map<String, IDevice> sdkMap = this.invalidDeviceGroupsMap.get(device.getSDKName());
                    if (sdkMap == null) {
                        sdkMap = new HashMap<String, IDevice>();
                        this.invalidDeviceGroupsMap.put(device.getSDKName(), sdkMap);
                    }
                    if (!sdkMap.containsKey(device.getName())) {
                        sdkMap.put(device.getName(), device);
                    }
                }
            } else if (isValidDevice) {
                this.addDevice(device);
            }
            ++i;
        }
    }

    synchronized void removeDevice(IDevice device) throws PersistenceException {
        ISDK sdk;
        if (device instanceof IManagedDevice) {
            return;
        }
        Map<String, IDevice> groupMap = this.getDeviceGroupMap(device.getSDKName(), false);
        if (groupMap != null) {
            String key = this.getDeviceKey(groupMap, device);
            if (key != null) {
                groupMap.remove(key);
            }
            if (groupMap.isEmpty()) {
                this.deviceGroupsMap.remove(device.getSDKName());
            }
        }
        if ((sdk = device.getSDK()) instanceof BasicSDK) {
            ((BasicSDK)sdk).deleteDevice(device);
        }
    }

    private String getDeviceKey(Map<String, IDevice> groupMap, IDevice device) {
        String key = null;
        for (Map.Entry<String, IDevice> entry : groupMap.entrySet()) {
            IDevice currentDevice = entry.getValue();
            if (currentDevice != device) continue;
            key = entry.getKey();
            break;
        }
        return key;
    }

    void store() throws PersistenceException, TransformerException, IOException {
        XMLPersistenceProvider provider = new XMLPersistenceProvider("deviceRegistry");
        this.storeUsing(provider);
        XMLUtils.writeDocument(this.getComponentStoreFile(), provider.getDocument());
    }

    void storeUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        List<IDevice> allDevices = this.getAllDevices();
        int deviceCount = 0;
        for (IDevice device : allDevices) {
            if (device instanceof IManagedDevice) continue;
            persistenceProvider.storePersistable("device" + deviceCount++, device);
        }
        persistenceProvider.storeInteger("deviceCount", deviceCount);
    }

    protected void createAndLoadDeviceGroups() throws PersistenceException {
        this.deviceGroupsMap = new HashMap<String, Map<String, IDevice>>();
        this.load();
    }

    private File getComponentStoreFile() {
        IPath pluginStatePath = MTJCore.getMTJCore().getStateLocation();
        IPath storePath = pluginStatePath.append("devices.xml");
        return storePath.toFile();
    }

    protected Map<String, IDevice> getDeviceGroupMap(String groupName, boolean createIfNull) throws PersistenceException {
        Map<String, Map<String, IDevice>> groupsMap = this.getDeviceGroupsMap();
        Map<String, IDevice> deviceGroupMap = groupsMap.get(groupName);
        if (deviceGroupMap == null && createIfNull) {
            deviceGroupMap = new HashMap<String, IDevice>();
            groupsMap.put(groupName, deviceGroupMap);
        }
        return deviceGroupMap;
    }

    private synchronized Map<String, Map<String, IDevice>> getDeviceGroupsMap() throws PersistenceException {
        if (this.deviceGroupsMap == null) {
            this.createAndLoadDeviceGroups();
        }
        return this.deviceGroupsMap;
    }

    List<String> getInvalidSDKNames() {
        return new ArrayList<String>(this.invalidDeviceGroupsMap.keySet());
    }

    private List<IDevice> getAllDevicesInternal(boolean filterByGroupName, String groupName) throws PersistenceException {
        if (!filterByGroupName && groupName != null) {
            throw new IllegalArgumentException("If filterByGroupName is false, groupName should be null");
        }
        if (filterByGroupName && groupName == null) {
            throw new IllegalArgumentException("If filterByGroupName is true, groupName cannot be null");
        }
        ArrayList<IDevice> allDevices = new ArrayList<IDevice>();
        for (Map<String, IDevice> deviceMap : this.getDeviceGroupsMap().values()) {
            allDevices.addAll(deviceMap.values());
        }
        if (filterByGroupName) {
            ArrayList<IDevice> filteredDevices = new ArrayList<IDevice>();
            for (IDevice importedDevice : allDevices) {
                if (!importedDevice.getSDKName().equals(groupName)) continue;
                filteredDevices.add(importedDevice);
            }
            return filteredDevices;
        }
        return allDevices;
    }
}

