/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.sdk.device.midp;

import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.sdk.device.midp.IMIDPAPI;
import org.eclipse.mtj.core.sdk.device.midp.MIDPAPIType;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class MIDPAPI
implements IMIDPAPI {
    private static final String VERSION_ENTRY = "version";
    private static final String TYPE_ENTRY = "type";
    private static final String NAME_ENTRY = "name";
    private static final String IDENTIFIER_ENTRY = "identifier";
    private String identifier;
    private String name;
    private MIDPAPIType type = MIDPAPIType.UNKNOWN;
    private Version version;

    public MIDPAPI() {
        this.identifier = MIDPAPIType.UNKNOWN.toString();
        this.name = MIDPAPIType.UNKNOWN.toString();
        this.version = Version.emptyVersion;
    }

    public MIDPAPIType getType() {
        return this.type;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(MIDPAPIType type) {
        this.type = type;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public void loadUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        this.identifier = persistenceProvider.loadString(IDENTIFIER_ENTRY);
        this.version = new Version(persistenceProvider.loadString(VERSION_ENTRY));
        this.name = persistenceProvider.loadString(NAME_ENTRY);
        int typeCode = persistenceProvider.loadInteger(TYPE_ENTRY);
        this.type = MIDPAPIType.getMIDPAPITypeByCode(typeCode);
    }

    public void storeUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        persistenceProvider.storeString(IDENTIFIER_ENTRY, this.identifier);
        persistenceProvider.storeString(NAME_ENTRY, this.name);
        persistenceProvider.storeInteger(TYPE_ENTRY, this.type.getTypecode());
        persistenceProvider.storeString(VERSION_ENTRY, NLS.bind((String)"{0}.{1}", (Object[])new Object[]{this.version.getMajor(), this.version.getMinor()}));
    }

    public String toString() {
        Version version = this.getVersion();
        return String.valueOf(this.getIdentifier()) + (Version.emptyVersion.equals((Object)version) ? "" : "-" + version.getMajor() + "." + version.getMinor());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MIDPAPI other = (MIDPAPI)obj;
        if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals((Object)other.type)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals((Object)other.version));
    }
}

