/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.security.meep;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

class JarFileDataAccessor {
    private File filePointer;
    private Set<String> entryNames = new HashSet<String>();

    public JarFileDataAccessor(File filePointer) throws IOException {
        this.filePointer = filePointer;
        JarFile jarFile = new JarFile(filePointer);
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                this.entryNames.add(entries.nextElement().getName());
            }
        }
        finally {
            jarFile.close();
        }
    }

    private byte[] getData(InputStream in) throws IOException {
        try {
            int b;
            BufferedInputStream bin = new BufferedInputStream(in);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            while ((b = bin.read()) != -1) {
                result.write(b);
            }
            byte[] byArray = result.toByteArray();
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public boolean hasEntry(String name) {
        return this.entryNames.contains(name);
    }

    public synchronized byte[] getEntryData(String entryName) throws IOException {
        if (entryName == null) {
            throw new IOException("no entry name specified");
        }
        if (!this.hasEntry(entryName)) {
            throw new FileNotFoundException("JAR entry " + entryName + " not found in " + this.filePointer.getName());
        }
        JarFile jarFile = new JarFile(this.filePointer);
        try {
            byte[] byArray = this.getData(jarFile.getInputStream(jarFile.getEntry(entryName)));
            return byArray;
        }
        finally {
            jarFile.close();
        }
    }

    private synchronized long getEntryLength(String entryName) throws IOException {
        if (entryName == null) {
            return this.filePointer.length();
        }
        if (!this.hasEntry(entryName)) {
            return -1L;
        }
        JarFile jarFile = new JarFile(this.filePointer);
        try {
            long l = jarFile.getEntry(entryName).getSize();
            return l;
        }
        finally {
            jarFile.close();
        }
    }

    public URL getEntryURL(String entryName) {
        if (entryName == null || !this.hasEntry(entryName)) {
            return null;
        }
        try {
            return new URL("jar", "", -1, this.filePointer.toURI().toURL() + "!/" + entryName, new URLStreamHandler(){

                protected URLConnection openConnection(URL u) throws IOException {
                    return new EntryURLConnection(u);
                }

                protected URLConnection openConnection(URL u, Proxy p) throws IOException {
                    return this.openConnection(u);
                }
            });
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private class EntryURLConnection
    extends URLConnection {
        private Permission permission;
        private String contentType;
        private String entryName;

        EntryURLConnection(URL url) throws IOException {
            super(url);
            this.entryName = null;
            String spec = url.getFile();
            int idx = spec.indexOf("!/");
            if (idx >= 0 && idx + 2 != spec.length()) {
                this.entryName = spec.substring(idx + 2);
            }
        }

        public Permission getPermission() throws IOException {
            if (this.permission == null) {
                this.permission = new FilePermission(JarFileDataAccessor.this.filePointer.getAbsolutePath(), "read");
            }
            return this.permission;
        }

        public void connect() throws IOException {
            if (!this.connected) {
                if (this.entryName != null && !JarFileDataAccessor.this.hasEntry(this.entryName)) {
                    throw new FileNotFoundException("JAR entry " + this.entryName + " not found in " + JarFileDataAccessor.this.filePointer.getPath());
                }
                this.connected = true;
            }
        }

        public InputStream getInputStream() throws IOException {
            if (this.entryName == null || !JarFileDataAccessor.this.hasEntry(this.entryName)) {
                return null;
            }
            byte[] data = JarFileDataAccessor.this.getEntryData(this.entryName);
            return data == null ? null : new ByteArrayInputStream(data);
        }

        public int getContentLength() {
            try {
                return (int)JarFileDataAccessor.this.getEntryLength(this.entryName);
            }
            catch (IOException iOException) {
                return -1;
            }
        }

        public Object getContent() throws IOException {
            this.connect();
            return super.getContent();
        }

        public String getContentType() {
            if (this.contentType == null) {
                block19: {
                    if (this.entryName == null) {
                        this.contentType = "x-java/jar";
                    } else {
                        BufferedInputStream in = null;
                        try {
                            try {
                                this.connect();
                                in = new BufferedInputStream(this.getInputStream());
                                this.contentType = EntryURLConnection.guessContentTypeFromStream(in);
                            }
                            catch (IOException iOException) {
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (IOException iOException2) {}
                                }
                                break block19;
                            }
                        }
                        catch (Throwable throwable) {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                if (this.contentType == null) {
                    this.contentType = EntryURLConnection.guessContentTypeFromName(this.entryName);
                }
                if (this.contentType == null) {
                    this.contentType = "content/unknown";
                }
            }
            return this.contentType;
        }
    }
}

