/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util.migration;

import org.eclipse.mtj.core.MTJCore;
import org.eclipse.mtj.internal.core.util.migration.AbstractMigration;
import org.eclipse.mtj.internal.core.util.migration.ISymbolDefinitionsMigrationConstants;
import org.eclipse.mtj.internal.core.util.xml.DocumentAdapter;
import org.eclipse.mtj.internal.core.util.xml.DocumentVisitor;
import org.eclipse.mtj.internal.core.util.xml.XMLUtils;
import org.osgi.framework.Version;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SymbolDefinitionsMigration
extends AbstractMigration
implements ISymbolDefinitionsMigrationConstants {
    public Document migrate(Document document) {
        this.migrated = false;
        if (document == null) {
            return null;
        }
        Element rootXmlElement = document.getDocumentElement();
        if (!rootXmlElement.getNodeName().equals("symbolDefinitionsRegistry")) {
            return null;
        }
        Version version = XMLUtils.getVersion(document);
        if (version.compareTo(new Version(MTJCore.getMTJCoreVersion())) < 0) {
            DocumentAdapter documentAdapter = new DocumentAdapter(document);
            documentAdapter.accept(new ConversionDocumentVisitor());
            String pluginVersion = MTJCore.getMTJCoreVersion();
            Version newVersion = new Version(pluginVersion);
            rootXmlElement.setAttribute("version", newVersion.toString());
            this.migrated = true;
        }
        return document;
    }

    private final class ConversionDocumentVisitor
    implements DocumentVisitor {
        private ConversionDocumentVisitor() {
        }

        public void visitElement(Element element) {
            Attr attr = element.getAttributeNode("class");
            if (attr != null) {
                attr.setValue("org.eclipse.mtj.internal.core.symbol.SymbolSet");
            }
        }
    }
}

