/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util.xml;

import org.eclipse.mtj.internal.core.util.xml.DocumentVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentAdapter {
    private Document document;

    public DocumentAdapter(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Document can not be null.");
        }
        this.document = document;
    }

    public void accept(DocumentVisitor visitor) {
        Element root = this.document.getDocumentElement();
        visitor.visitElement(root);
        NodeList nodes = root.getChildNodes();
        if (nodes.getLength() > 0) {
            this.accept(nodes, visitor);
        }
    }

    private void accept(NodeList nodes, DocumentVisitor visitor) {
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    visitor.visitElement((Element)node);
                }
            }
            NodeList children = node.getChildNodes();
            if (children.getLength() > 0) {
                this.accept(children, visitor);
            }
            ++i;
        }
    }
}

