/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.core.util.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XMLUtils {
    public static final String ATTR_VERSION = "version";
    private static final String PROP_LOG_XMLUTILS = "mtj.log.xmlutils";
    private static final boolean DO_LOG = System.getProperty("mtj.log.xmlutils", Boolean.FALSE.toString()).equalsIgnoreCase(Boolean.TRUE.toString());
    private static final String XSLT_TEMPLATE = "<xsl:stylesheet version=\"1.0\"\r\n      xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\r\n   <xsl:output method=\"xml\"/>\r\n   <xsl:param name=\"indent-increment\" select=\"'   '\" />\r\n\r\n   <xsl:template match=\"*\">\r\n      <xsl:param name=\"indent\" select=\"'&#xA;'\"/>\r\n\r\n      <xsl:value-of select=\"$indent\"/>\r\n      <xsl:copy>\r\n        <xsl:copy-of select=\"@*\" />\r\n        <xsl:apply-templates>\r\n          <xsl:with-param name=\"indent\"\r\n               select=\"concat($indent, $indent-increment)\"/>\r\n        </xsl:apply-templates>\r\n        <xsl:if test=\"*\">\r\n          <xsl:value-of select=\"$indent\"/>\r\n        </xsl:if>\r\n      </xsl:copy>\r\n   </xsl:template>\r\n\r\n   <xsl:template match=\"comment()|processing-instruction()\">\r\n      <xsl:copy />\r\n   </xsl:template>\r\n\r\n   <!-- WARNING: this is dangerous. Handle with care -->\r\n   <xsl:template match=\"text()[normalize-space(.)='']\"/>\r\n\r\n</xsl:stylesheet>";

    public static Element createChild(Element parent, String name) throws DOMException {
        Element child = null;
        if (parent != null && name != null && !name.equals("")) {
            Document ownerDocument;
            if (DO_LOG) {
                System.out.println(NLS.bind((String)"createChild: parent = {0}; name = {1}", (Object[])new String[]{parent.getTagName(), name}));
            }
            if ((ownerDocument = parent.getOwnerDocument()) != null) {
                child = ownerDocument.createElement(name);
                parent.appendChild(child);
            }
        }
        return child;
    }

    public static Element createRootElement(String elementName, Version version) throws ParserConfigurationException {
        if (DO_LOG) {
            System.out.println(NLS.bind((String)"createRootElement: elementName = {0}; version = {1}", (Object[])new String[]{elementName, version.toString()}));
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element element = document.createElement(elementName);
        document.appendChild(element);
        element.setAttribute(ATTR_VERSION, version.toString());
        return element;
    }

    public static void createTextElement(Element parent, String name, String text) {
        if (DO_LOG) {
            System.out.println("createTextElement: parent = " + parent.getTagName() + "; name = " + name + "; text = " + text);
        }
        Element child = XMLUtils.createChild(parent, name);
        if (text != null) {
            Text textNode = parent.getOwnerDocument().createTextNode(text);
            child.appendChild(textNode);
        }
    }

    public static String getElementText(Element element) {
        StringBuffer sb = new StringBuffer();
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node.getNodeType() == 3) {
                sb.append(((Text)node).getData());
            }
            ++i;
        }
        return sb.toString();
    }

    public static Element getFirstElementWithTagName(Element element, String name) {
        Element firstElement = null;
        NodeList nodes = element.getElementsByTagName(name);
        if (nodes.getLength() > 0) {
            firstElement = (Element)nodes.item(0);
        }
        return firstElement;
    }

    public static Version getVersion(Document document) {
        Element docElement = document.getDocumentElement();
        String versionString = docElement.getAttribute(ATTR_VERSION);
        if (versionString.length() == 0) {
            versionString = Version.emptyVersion.toString();
        }
        return new Version(versionString);
    }

    public static Document readDocument(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        Document document = null;
        if (xmlFile != null && xmlFile.exists()) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(xmlFile);
        }
        return document;
    }

    public static Document readDocument(InputStream xmlStream) throws ParserConfigurationException, SAXException, IOException {
        Document document = null;
        if (xmlStream != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(xmlStream);
        }
        return document;
    }

    public static void writeDocument(File xmlFile, Document document) throws TransformerException, IOException {
        FileOutputStream fos = new FileOutputStream(xmlFile);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        try {
            XMLUtils.writeDocument(writer, document);
        }
        finally {
            writer.close();
        }
    }

    public static void writeDocument(Writer writer, Document document) throws TransformerException, IOException {
        StreamResult destination = new StreamResult(writer);
        DOMSource source = new DOMSource(document);
        StringReader xslReader = new StringReader(XSLT_TEMPLATE);
        StreamSource xslSource = new StreamSource(xslReader);
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer serializer = tfactory.newTransformer(xslSource);
        serializer.transform(source, destination);
    }

    public static Element createTargetElement(Document _document, Element _parent, String name, String depends) {
        Element newElement = _document.createElement("target");
        _parent.appendChild(newElement);
        newElement.setAttribute("name", name);
        newElement.setAttribute("depends", depends);
        return newElement;
    }

    private XMLUtils() {
    }
}

