/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.core.api;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.internal.jmunit.JMUnitMessages;
import org.eclipse.mtj.internal.jmunit.core.api.ITestFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMUnitTestFinder
implements ITestFinder {
    private String fSuperclass;

    public JMUnitTestFinder(String superclass) {
        this.fSuperclass = superclass;
    }

    public void findTestImplementorClasses(ITypeHierarchy typeHierarchy, IType testInterface, IRegion region, Set<IType> result) throws JavaModelException {
        IType[] subtypes;
        IType[] iTypeArray = subtypes = typeHierarchy.getAllSubtypes(testInterface);
        int n = subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            int cachedFlags = typeHierarchy.getCachedFlags(type);
            if (!Flags.isInterface((int)cachedFlags) && !Flags.isAbstract((int)cachedFlags) && region.contains((IJavaElement)type) && this.isAccessibleClass(type)) {
                result.add(type);
            }
            ++n2;
        }
    }

    @Override
    public void findTestsInContainer(IJavaElement element, Set<IType> result, IProgressMonitor pm) throws CoreException {
        if (element == null || result == null) {
            throw new IllegalArgumentException();
        }
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask(JMUnitMessages.JMUnitTestFinder_findTestsInContainer_taskName, 10);
        try {
            if (element instanceof IType) {
                if (this.isTest((IType)element)) {
                    result.add((IType)element);
                }
            } else if (element instanceof ICompilationUnit) {
                IType[] types;
                IType[] iTypeArray = types = ((ICompilationUnit)element).getAllTypes();
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    if (this.isTest(type)) {
                        result.add(type);
                    }
                    ++n2;
                }
            } else {
                this.findTestCases(element, result, (IProgressMonitor)new SubProgressMonitor(pm, 7));
                if (pm.isCanceled()) {
                    return;
                }
            }
            if (pm.isCanceled()) {
                return;
            }
        }
        finally {
            pm.done();
        }
    }

    public IRegion getRegion(IJavaElement element) throws JavaModelException {
        IRegion result = JavaCore.newRegion();
        if (element.getElementType() == 2) {
            IPackageFragmentRoot[] roots = ((IJavaProject)element).getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (!roots[i].isArchive()) {
                    result.add((IJavaElement)roots[i]);
                }
                ++i;
            }
        } else {
            result.add(element);
        }
        return result;
    }

    public boolean isAccessibleClass(IType type) throws JavaModelException {
        int flags = type.getFlags();
        if (Flags.isInterface((int)flags)) {
            return false;
        }
        IJavaElement parent = type.getParent();
        while (!(parent instanceof ICompilationUnit) && !(parent instanceof IClassFile)) {
            if (!(parent instanceof IType && Flags.isStatic((int)flags) && Flags.isPublic((int)flags))) {
                return false;
            }
            flags = ((IType)parent).getFlags();
            parent = parent.getParent();
        }
        return true;
    }

    @Override
    public boolean isTest(IType type) throws CoreException {
        return this.isAccessibleClass(type) && !Flags.isAbstract((int)type.getFlags()) && this.isTestImplementor(type);
    }

    public boolean isTestImplementor(IType type) throws JavaModelException {
        IType[] superClasses;
        ITypeHierarchy typeHier = type.newSupertypeHierarchy(null);
        IType[] iTypeArray = superClasses = typeHier.getAllClasses();
        int n = superClasses.length;
        int n2 = 0;
        while (n2 < n) {
            IType superInterface = iTypeArray[n2];
            if (this.fSuperclass.equals(superInterface.getFullyQualifiedName('.'))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void findTestCases(IJavaElement element, Set<IType> result, IProgressMonitor pm) throws JavaModelException {
        IJavaProject javaProject = element.getJavaProject();
        IType testCaseType = javaProject.findType(this.fSuperclass);
        if (testCaseType == null) {
            return;
        }
        IRegion region = this.getRegion(element);
        ITypeHierarchy typeHierarchy = javaProject.newTypeHierarchy(testCaseType, region, pm);
        this.findTestImplementorClasses(typeHierarchy, testCaseType, region, result);
    }
}

