/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.jmunit.ui.wizards.testcase;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageOne;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageTwo;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.internal.core.externallibrary.manager.ExternalLibraryManager;
import org.eclipse.mtj.internal.core.util.log.MTJLogger;
import org.eclipse.mtj.internal.jmunit.JMUnitMessages;
import org.eclipse.mtj.internal.jmunit.JMUnitPlugin;
import org.eclipse.mtj.internal.jmunit.core.api.JMUnitTestFinder;
import org.eclipse.mtj.internal.jmunit.core.api.TestCaseWriter;
import org.eclipse.mtj.internal.jmunit.ui.part.MethodStubsSelectionButtonGroup;
import org.eclipse.mtj.internal.jmunit.util.JMUnitStatus;
import org.eclipse.mtj.internal.jmunit.util.LayoutUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class NewJMUnitTestCasePageOne
extends NewTestCaseWizardPageOne {
    private static final int IDX_SETUP = 0;
    private static final int IDX_TEARDOWN = 1;
    private static final String STORE_SETUP = "NewTestCaseCreationWizardPage.USE_SETUP";
    private static final String STORE_TEARDOWN = "NewTestCaseCreationWizardPage.USE_TEARDOWN";
    private Label fImage;
    private boolean fIsJMunitCLDC11;
    private IStatus fJMunitCLDC11Status;
    private Link fLink;
    private MethodStubsSelectionButtonGroup fMethodStubsButtons;
    private NewTestCaseWizardPageTwo page2;

    public NewJMUnitTestCasePageOne(NewTestCaseWizardPageTwo page2) {
        super(page2);
        this.page2 = page2;
        this.setTitle(JMUnitMessages.NewJMUnitTestCasePageOne_title);
        this.setDescription(JMUnitMessages.NewJMUnitTestCasePageOne_description);
        String[] buttonNames = new String[]{"set&Up()", "&tearDown()"};
        this.fMethodStubsButtons = new MethodStubsSelectionButtonGroup(32, buttonNames, 3);
        this.fMethodStubsButtons.setLabelText(JMUnitMessages.NewJMUnitTestCasePageOne_methodStubs_label);
        this.enableCommentControl(true);
        this.fJMunitCLDC11Status = new JMUnitStatus();
        this.fIsJMunitCLDC11 = true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.createCommentControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createClassUnderTestControls(composite, nColumns);
        this.createBuildPathConfigureControls(composite, nColumns);
        this.setControl((Control)composite);
        String classUnderTest = this.getClassUnderTestText();
        if (classUnderTest.length() > 0) {
            this.setTypeName(String.valueOf(Signature.getSimpleName((String)classUnderTest)) + "Test", true);
        }
        Dialog.applyDialogFont((Control)composite);
        this.setFocus();
    }

    public void init(IStructuredSelection selection) {
        super.init(selection);
        this.restoreWidgetValues();
        this.setSuperClass("jmunit.framework.cldc11.TestCase", true);
        this.handleFieldChanged("NewContainerWizardPage.container");
        this.updateStatus(this.getStatusList());
    }

    public boolean isJMUnit11() {
        return this.fIsJMunitCLDC11;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.saveWidgetValues();
        }
    }

    private void performBuildpathConfiguration(Object data) {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return;
        }
        IJavaProject javaProject = root.getJavaProject();
        if ("cldc10".equals(data)) {
            try {
                ExternalLibraryManager.getInstance().addLibraryToMidletProject(javaProject.getProject(), "JMUnit for CLDC 1.0");
            }
            catch (CoreException e) {
                MTJLogger.log((int)4, (Throwable)e);
            }
        } else if ("cldc11".equals(data)) {
            try {
                ExternalLibraryManager.getInstance().addLibraryToMidletProject(javaProject.getProject(), "JMUnit for CLDC 1.1");
            }
            catch (CoreException e) {
                MTJLogger.log((int)4, (Throwable)e);
            }
        }
        this.handleFieldChanged("NewContainerWizardPage.container");
        this.updateBuildPathMessage();
    }

    private IType resolveClassNameToType(IJavaProject jproject, IPackageFragment pack, String classToTestName) throws JavaModelException {
        IType type = jproject.findType(classToTestName);
        if (type == null && pack != null && !pack.isDefaultPackage()) {
            type = jproject.findType(pack.getElementName(), classToTestName);
        }
        if (type == null) {
            type = jproject.findType("java.lang", classToTestName);
        }
        return type;
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fMethodStubsButtons.setSelection(0, settings.getBoolean(STORE_SETUP));
            this.fMethodStubsButtons.setSelection(1, settings.getBoolean(STORE_TEARDOWN));
        } else {
            this.fMethodStubsButtons.setSelection(0, false);
            this.fMethodStubsButtons.setSelection(1, false);
        }
    }

    private void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_SETUP, this.fMethodStubsButtons.isSelected(0));
            settings.put(STORE_TEARDOWN, this.fMethodStubsButtons.isSelected(1));
        }
    }

    private void updateBuildPathMessage() {
        if (this.fLink == null || this.fLink.isDisposed()) {
            return;
        }
        String message = null;
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null) {
            try {
                IJavaProject project = root.getJavaProject();
                if (project.exists()) {
                    if (this.isJMUnit11()) {
                        if (project.findType("jmunit.framework.cldc11.TestCase") == null) {
                            message = NLS.bind((String)JMUnitMessages.NewJMUnitTestCasePageOne_jmunit_cldc11_not_in_classpath, (Object)project.getElementName());
                        }
                    } else if (project.findType("jmunit.framework.cldc10.TestCase") == null) {
                        message = NLS.bind((String)JMUnitMessages.NewJMUnitTestCasePageOne_jmunit_cldc10_not_in_classpath, (Object)project.getElementName());
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        this.fLink.setVisible(message != null);
        this.fImage.setVisible(message != null);
        if (message != null) {
            this.fLink.setText(message);
        }
    }

    protected void createBuildPathConfigureControls(Composite composite, int nColumns) {
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(4, 4, false, false, nColumns, 1));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        inner.setLayout((Layout)layout);
        this.fImage = new Label(inner, 0);
        this.fImage.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        this.fImage.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        this.fLink = new Link(inner, 64);
        this.fLink.setText("\n\n");
        this.fLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewJMUnitTestCasePageOne.this.performBuildpathConfiguration(e.text);
            }
        });
        GridData gd = new GridData(4, 1, true, false, 1, 1);
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        this.fLink.setLayoutData((Object)gd);
        this.updateBuildPathMessage();
    }

    protected void createMethodStubSelectionControls(Composite composite, int nColumns) {
        LayoutUtil.setHorizontalSpan((Control)this.fMethodStubsButtons.getLabelControl(composite), nColumns);
        LayoutUtil.createEmptySpace(composite, 1);
        LayoutUtil.setHorizontalSpan((Control)this.fMethodStubsButtons.getSelectionButtonsGroup(composite), nColumns - 1);
    }

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        TestCaseWriter writer = new TestCaseWriter(type, type.getElementName());
        boolean comment = this.isAddComments();
        boolean teardown = this.fMethodStubsButtons.isSelected(1);
        boolean setup = this.fMethodStubsButtons.isSelected(0);
        boolean finalise = this.page2.getCreateFinalMethodStubsButtonSelection();
        boolean stubs = this.page2.isCreateTasks();
        writer.writeCode(this.page2.getCheckedMethods(), setup, teardown, comment, stubs, finalise, monitor);
    }

    protected IStatus[] getStatusList() {
        ArrayList<IStatus> status = new ArrayList<IStatus>();
        IStatus[] iStatusArray = super.getStatusList();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus stat = iStatusArray[n2];
            status.add(stat);
            ++n2;
        }
        status.add(this.fJMunitCLDC11Status);
        return status.toArray(new IStatus[0]);
    }

    protected IStatus superClassChanged() {
        String superClassName = this.getSuperClass();
        JMUnitStatus status = new JMUnitStatus();
        if (superClassName == null || superClassName.trim().equals("")) {
            status = JMUnitStatus.createError(JMUnitMessages.NewJMUnitTestCasePageOne_empty_superclass);
            return status;
        }
        if (this.getPackageFragmentRoot() != null) {
            try {
                IType type = this.resolveClassNameToType(this.getPackageFragmentRoot().getJavaProject(), this.getPackageFragment(), superClassName);
                if (type == null) {
                    status = JMUnitStatus.createError(JMUnitMessages.NewJMUnitTestCasePageOne_missing_superclass);
                    return status;
                }
                if (type.isInterface()) {
                    status = JMUnitStatus.createError(JMUnitMessages.NewJMUnitTestCasePageOne_interface_as_superclass);
                    return status;
                }
                if (!new JMUnitTestFinder(this.isJMUnit11() ? "jmunit.framework.cldc11.TestCase" : "jmunit.framework.cldc10.TestCase").isTestImplementor(type)) {
                    status = JMUnitStatus.createError(String.valueOf(JMUnitMessages.NewJMUnitTestCasePageOne_superclass_not_text_impl) + (this.isJMUnit11() ? "jmunit.framework.cldc11.TestCase" : "jmunit.framework.cldc10.TestCase"));
                    return status;
                }
            }
            catch (JavaModelException e) {
                JMUnitPlugin.log(e.getStatus());
            }
        }
        return status;
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.updateBuildPathMessage();
    }
}

