/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.microemu;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.mtj.core.launching.LaunchEnvironment;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDevice;
import org.eclipse.mtj.internal.core.sdk.device.LaunchTemplateProperties;
import org.eclipse.mtj.internal.core.util.ReplaceableParametersProcessor;
import org.eclipse.mtj.internal.toolkit.microemu.MicroEmuDeviceSkin;
import org.eclipse.mtj.internal.toolkit.microemu.MicroEmuLaunchTemplateProperties;

public class MicroEmuDevice
extends JavaEmulatorDevice {
    private File root;
    private MicroEmuDeviceSkin skin;

    public String getLaunchCommand(LaunchEnvironment launchEnvironment, IProgressMonitor monitor) throws CoreException {
        ILaunchConfiguration launchConfiguration = launchEnvironment.getLaunchConfiguration();
        boolean launchFromJAD = this.shouldDirectLaunchJAD(launchConfiguration);
        HashMap<String, String> executionProperties = new HashMap<String, String>();
        executionProperties.put(LaunchTemplateProperties.EXECUTABLE.toString(), this.getJavaExecutable().toString());
        executionProperties.put(MicroEmuLaunchTemplateProperties.TOOLKITROOT.toString(), this.root.toString());
        executionProperties.put(MicroEmuLaunchTemplateProperties.SKINJARFILE.toString(), this.skin.getJarFile());
        executionProperties.put(MicroEmuLaunchTemplateProperties.SKINPATHINJAR.toString(), this.skin.getPath());
        executionProperties.put(MicroEmuLaunchTemplateProperties.PATHSEPARATOR.toString(), System.getProperty("path.separator"));
        if (launchEnvironment.isDebugLaunch()) {
            executionProperties.put(LaunchTemplateProperties.DEBUGPORT.toString(), new Integer(launchEnvironment.getDebugListenerPort()).toString());
        }
        executionProperties.put(LaunchTemplateProperties.USERSPECIFIEDARGUMENTS.toString(), launchConfiguration.getAttribute("mtj.launch_params", ""));
        if (launchFromJAD) {
            executionProperties.put(LaunchTemplateProperties.JADFILE.toString(), this.getSpecifiedJadURL(launchConfiguration));
        } else {
            File tempDeployed;
            IMidletSuiteProject midletSuite = (IMidletSuiteProject)launchEnvironment.getProject();
            File jadFile = this.getJadForLaunch(midletSuite, tempDeployed = this.copyForLaunch(midletSuite, monitor, launchFromJAD), monitor);
            if (jadFile.exists()) {
                executionProperties.put(LaunchTemplateProperties.JADFILE.toString(), jadFile.toString());
            }
        }
        return ReplaceableParametersProcessor.processReplaceableValues((String)this.launchCommandTemplate, executionProperties);
    }

    public File getRoot() {
        return this.root;
    }

    public MicroEmuDeviceSkin getSkin() {
        return this.skin;
    }

    public void loadUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        super.loadUsing(persistenceProvider);
        String rootString = persistenceProvider.loadString("toolkitRoot");
        this.root = new File(rootString);
        String skinJarFile = persistenceProvider.loadString("skinJar");
        String skinPathInFile = persistenceProvider.loadString("skinPathInJar");
        String skinName = persistenceProvider.loadString("skinName");
        this.skin = new MicroEmuDeviceSkin(skinJarFile, skinPathInFile, skinName);
    }

    public void setRoot(File mppRoot) {
        this.root = mppRoot;
    }

    public void setSkin(MicroEmuDeviceSkin skin) {
        this.skin = skin;
    }

    public void storeUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        super.storeUsing(persistenceProvider);
        persistenceProvider.storeString("toolkitRoot", this.root.toString());
        persistenceProvider.storeString("skinJar", this.skin.getJarFile());
        persistenceProvider.storeString("skinPathInJar", this.skin.getPath());
        persistenceProvider.storeString("skinName", this.skin.getName());
    }

    public File getWorkingDirectory() {
        return null;
    }
}

