/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.toolkit.mpowerplayer;

import java.io.File;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.mtj.core.launching.LaunchEnvironment;
import org.eclipse.mtj.core.persistence.IPersistenceProvider;
import org.eclipse.mtj.core.persistence.PersistenceException;
import org.eclipse.mtj.core.project.midp.IMidletSuiteProject;
import org.eclipse.mtj.internal.core.sdk.device.AbstractMIDPDevice;
import org.eclipse.mtj.internal.core.sdk.device.JavaEmulatorDevice;
import org.eclipse.mtj.internal.core.sdk.device.LaunchTemplateProperties;
import org.eclipse.mtj.internal.core.util.ReplaceableParametersProcessor;

public class MpowerplayerDevice
extends JavaEmulatorDevice {
    private static final String MPP_ROOT_PERSISTENCE_KEY = "mppRoot";
    private File mppRoot;

    public String getLaunchCommand(LaunchEnvironment launchEnvironment, IProgressMonitor monitor) throws CoreException {
        File tempDeployed;
        IMidletSuiteProject midletSuite;
        File jadFile;
        HashMap<String, String> executionProperties = new HashMap<String, String>();
        ILaunchConfiguration launchConfiguration = launchEnvironment.getLaunchConfiguration();
        boolean launchFromJAD = this.shouldDirectLaunchJAD(launchConfiguration);
        executionProperties.put(LaunchTemplateProperties.EXECUTABLE.toString(), this.getJavaExecutable().toString());
        executionProperties.put("mpproot", this.mppRoot.toString());
        if (launchEnvironment.isDebugLaunch()) {
            executionProperties.put(LaunchTemplateProperties.DEBUGPORT.toString(), new Integer(launchEnvironment.getDebugListenerPort()).toString());
        }
        String extraArguments = launchConfiguration.getAttribute("mtj.launch_params", "");
        executionProperties.put(LaunchTemplateProperties.USERSPECIFIEDARGUMENTS.toString(), extraArguments);
        if (launchFromJAD) {
            executionProperties.put(LaunchTemplateProperties.JADFILE.toString(), this.getSpecifiedJadURL(launchConfiguration));
        } else if (launchEnvironment.getProject() instanceof IMidletSuiteProject && (jadFile = this.getJadForLaunch(midletSuite = (IMidletSuiteProject)launchEnvironment.getProject(), tempDeployed = this.copyForLaunch(midletSuite, monitor, launchFromJAD), monitor)).exists()) {
            executionProperties.put(LaunchTemplateProperties.JADFILE.toString(), jadFile.toString());
        }
        return ReplaceableParametersProcessor.processReplaceableValues((String)this.launchCommandTemplate, executionProperties);
    }

    public File getMppRoot() {
        return this.mppRoot;
    }

    public void loadUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        super.loadUsing(persistenceProvider);
        String rootString = persistenceProvider.loadString(MPP_ROOT_PERSISTENCE_KEY);
        this.mppRoot = new File(rootString);
    }

    public void setMppRoot(File mppRoot) {
        this.mppRoot = mppRoot;
    }

    public void storeUsing(IPersistenceProvider persistenceProvider) throws PersistenceException {
        super.storeUsing(persistenceProvider);
        persistenceProvider.storeString(MPP_ROOT_PERSISTENCE_KEY, this.mppRoot.toString());
    }

    public File getWorkingDirectory() {
        return null;
    }

    public boolean equals(Object obj) {
        boolean areEqual = false;
        if (obj instanceof MpowerplayerDevice) {
            areEqual = super.equals((AbstractMIDPDevice)((MpowerplayerDevice)((Object)obj)));
        }
        return areEqual;
    }
}

